/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.SnapshotRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.SnapshotVerifyProcedure;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureRSCrashes
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureRSCrashes.class);

    @Test
    public void testRegionServerCrashWhileTakingSnapshot() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)procExec.getEnvironment();
        SnapshotProcedure sp = new SnapshotProcedure(env, this.snapshotProto);
        long procId = procExec.submitProcedure((Procedure)sp);
        SnapshotRegionProcedure snp = this.waitProcedureRunnableAndGetFirst(SnapshotRegionProcedure.class, 60000L);
        ServerName targetServer = env.getAssignmentManager().getRegionStates().getRegionStateNode(snp.getRegion()).getRegionLocation();
        TEST_UTIL.getHBaseCluster().killRegionServer(targetServer);
        TEST_UTIL.waitFor(60000L, () -> snp.inRetrying());
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        SnapshotTestingUtils.assertOneSnapshotThatMatches(TEST_UTIL.getAdmin(), this.snapshotProto);
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
    }

    @Test
    public void testRegionServerCrashWhileVerifyingSnapshot() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)procExec.getEnvironment();
        SnapshotProcedure sp = new SnapshotProcedure(env, this.snapshotProto);
        long procId = procExec.submitProcedure((Procedure)sp);
        SnapshotVerifyProcedure svp = this.waitProcedureRunnableAndGetFirst(SnapshotVerifyProcedure.class, 60000L);
        TEST_UTIL.waitFor(10000L, () -> svp.getServerName() != null);
        ServerName previousTargetServer = svp.getServerName();
        HRegionServer rs = TEST_UTIL.getHBaseCluster().getRegionServer(previousTargetServer);
        TEST_UTIL.getHBaseCluster().killRegionServer(rs.getServerName());
        TEST_UTIL.waitFor(60000L, () -> svp.getServerName() != null && !svp.getServerName().equals((Object)previousTargetServer));
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        SnapshotTestingUtils.assertOneSnapshotThatMatches(TEST_UTIL.getAdmin(), this.snapshotProto);
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
    }
}

