/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestThreadHandlerUsageQuota {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestThreadHandlerUsageQuota.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)UUID.randomUUID().toString());
    private static final int REFRESH_TIME = 5;
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    private static final int MAX_OPS = 1000;

    @AfterClass
    public static void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
        EnvironmentEdgeManager.reset();
        TEST_UTIL.deleteTable(TABLE_NAME);
        TEST_UTIL.shutdownMiniCluster();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 5);
        TEST_UTIL.getConfiguration().setFloat("hfile.block.cache.size", 0.0f);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        TEST_UTIL.flush(TABLE_NAME);
    }

    @Test
    public void testHandlerUsageThrottleForReads() throws Exception {
        try (Table table = this.getTable();){
            this.unthrottleUser();
            long unthrottledAttempts = ThrottleQuotaTestUtil.doGets(1000, FAMILY, QUALIFIER, table);
            this.configureThrottle();
            long throttledAttempts = ThrottleQuotaTestUtil.doGets(1000, FAMILY, QUALIFIER, table);
            Assert.assertTrue((String)"Throttled attempts should be less than unthrottled attempts", (throttledAttempts < unthrottledAttempts ? 1 : 0) != 0);
        }
    }

    @Test
    public void testHandlerUsageThrottleForWrites() throws Exception {
        try (Table table = this.getTable();){
            this.unthrottleUser();
            long unthrottledAttempts = ThrottleQuotaTestUtil.doPuts(1000, FAMILY, QUALIFIER, table);
            this.configureThrottle();
            long throttledAttempts = ThrottleQuotaTestUtil.doPuts(1000, FAMILY, QUALIFIER, table);
            Assert.assertTrue((String)"Throttled attempts should be less than unthrottled attempts", (throttledAttempts < unthrottledAttempts ? 1 : 0) != 0);
        }
    }

    private void configureThrottle() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.setQuota(QuotaSettingsFactory.throttleUser((String)TestThreadHandlerUsageQuota.getUserName(), (ThrottleType)ThrottleType.REQUEST_HANDLER_USAGE_MS, (long)1L, (TimeUnit)TimeUnit.SECONDS));
        }
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
    }

    private void unthrottleUser() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)TestThreadHandlerUsageQuota.getUserName(), (ThrottleType)ThrottleType.REQUEST_HANDLER_USAGE_MS));
        }
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, true, TABLE_NAME);
    }

    private static String getUserName() throws IOException {
        return User.getCurrent().getShortName();
    }

    private Table getTable() throws IOException {
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        return TEST_UTIL.getConnection().getTableBuilder(TABLE_NAME, null).setOperationTimeout(250).build();
    }
}

