/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.replication.CopyReplicationPeers;
import org.apache.hadoop.hbase.replication.DummyReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorageType;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestMigrateRepliationPeerStorageOnline {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMigrateRepliationPeerStorageOnline.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().set("hbase.replication.peer.storage.impl", ReplicationPeerStorageType.ZOOKEEPER.name());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMigrate() throws Exception {
        Configuration newConf;
        Admin admin = UTIL.getAdmin();
        ReplicationPeerConfig rpc = ReplicationPeerConfig.newBuilder().setClusterKey(UTIL.getClusterKey() + "-test").setReplicationEndpointImpl(DummyReplicationEndpoint.class.getName()).build();
        admin.addReplicationPeer("1", rpc);
        admin.replicationPeerModificationSwitch(false, true);
        Configuration conf = new Configuration(UTIL.getConfiguration());
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)new CopyReplicationPeers(conf), (String[])new String[]{"zookeeper", "filesystem"}));
        conf.set("hbase.replication.peer.storage.impl", ReplicationPeerStorageType.FILESYSTEM.name());
        ReplicationPeerStorage fsPeerStorage = ReplicationStorageFactory.getReplicationPeerStorage((FileSystem)UTIL.getTestFileSystem(), (ZKWatcher)UTIL.getZooKeeperWatcher(), (Configuration)conf);
        Assert.assertNotNull((Object)fsPeerStorage.getPeerConfig("1"));
        for (JVMClusterUtil.MasterThread mt : UTIL.getMiniHBaseCluster().getMasterThreads()) {
            newConf = new Configuration(mt.getMaster().getConfiguration());
            newConf.set("hbase.replication.peer.storage.impl", ReplicationPeerStorageType.FILESYSTEM.name());
            mt.getMaster().getConfigurationManager().notifyAllObservers(newConf);
        }
        for (JVMClusterUtil.RegionServerThread rt : UTIL.getMiniHBaseCluster().getRegionServerThreads()) {
            newConf = new Configuration(rt.getRegionServer().getConfiguration());
            newConf.set("hbase.replication.peer.storage.impl", ReplicationPeerStorageType.FILESYSTEM.name());
            rt.getRegionServer().getConfigurationManager().notifyAllObservers(newConf);
        }
        admin.replicationPeerModificationSwitch(true);
        admin.removeReplicationPeer("1");
        MatcherAssert.assertThat((Object)fsPeerStorage.listPeerIds(), (Matcher)Matchers.empty());
    }
}

