/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellBuilderFactory;
import org.apache.hadoop.hbase.CellBuilderType;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALStreamReader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompressedWALTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(CompressedWALTestBase.class);
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final byte[] VALUE = new byte[4180];

    @Test
    public void test() throws Exception {
        this.testForSize(1000);
    }

    @Test
    public void testLarge() throws Exception {
        this.testForSize(0x100000);
    }

    private void testForSize(int size) throws Exception {
        TableName tableName = TableName.valueOf((String)(this.getClass().getSimpleName() + "_testForSize_" + size));
        this.doTest(tableName, size);
    }

    public void doTest(TableName tableName, int valueSize) throws Exception {
        TreeMap<byte[], Integer> scopes = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        scopes.put(tableName.getName(), 0);
        RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        int total = 1000;
        byte[] row = Bytes.toBytes((String)"row");
        byte[] family = Bytes.toBytes((String)"family");
        byte[] value = new byte[valueSize];
        int offset = 0;
        while (offset + VALUE.length < value.length) {
            System.arraycopy(VALUE, 0, value, offset, VALUE.length);
            offset += VALUE.length;
        }
        WALFactory wals = new WALFactory(TEST_UTIL.getConfiguration(), tableName.getNameAsString());
        WAL wal = wals.getWAL(regionInfo);
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        for (int i = 0; i < 1000; ++i) {
            WALEdit kvs = new WALEdit();
            kvs.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.Put).setRow(row).setFamily(family).setQualifier(Bytes.toBytes((int)i)).setValue(value).build());
            kvs.add(CellBuilderFactory.create((CellBuilderType)CellBuilderType.SHALLOW_COPY).setType(Cell.Type.DeleteFamily).setRow(row).setFamily(family).build());
            wal.appendData(regionInfo, new WALKeyImpl(regionInfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), mvcc, scopes), kvs);
            wal.sync();
        }
        Path walPath = AbstractFSWALProvider.getCurrentFileName((WAL)wal);
        wals.shutdown();
        try (WALStreamReader reader = wals.createStreamReader(TEST_UTIL.getTestFileSystem(), walPath);){
            int count = 0;
            WAL.Entry entry = new WAL.Entry();
            while (reader.next(entry) != null) {
                ++count;
                ArrayList cells = entry.getEdit().getCells();
                MatcherAssert.assertThat((String)"Should be two KVs per WALEdit", (Object)cells, (Matcher)Matchers.hasSize((int)2));
                Cell putCell = (Cell)cells.get(0);
                Assert.assertEquals((Object)Cell.Type.Put, (Object)putCell.getType());
                Assert.assertTrue((String)"Incorrect row", (boolean)Bytes.equals((byte[])putCell.getRowArray(), (int)putCell.getRowOffset(), (int)putCell.getRowLength(), (byte[])row, (int)0, (int)row.length));
                Assert.assertTrue((String)"Incorrect family", (boolean)Bytes.equals((byte[])putCell.getFamilyArray(), (int)putCell.getFamilyOffset(), (int)putCell.getFamilyLength(), (byte[])family, (int)0, (int)family.length));
                Assert.assertTrue((String)"Incorrect value", (boolean)Bytes.equals((byte[])putCell.getValueArray(), (int)putCell.getValueOffset(), (int)putCell.getValueLength(), (byte[])value, (int)0, (int)value.length));
                Cell deleteCell = (Cell)cells.get(1);
                Assert.assertEquals((Object)Cell.Type.DeleteFamily, (Object)deleteCell.getType());
                Assert.assertTrue((String)"Incorrect row", (boolean)Bytes.equals((byte[])deleteCell.getRowArray(), (int)deleteCell.getRowOffset(), (int)deleteCell.getRowLength(), (byte[])row, (int)0, (int)row.length));
                Assert.assertTrue((String)"Incorrect family", (boolean)Bytes.equals((byte[])deleteCell.getFamilyArray(), (int)deleteCell.getFamilyOffset(), (int)deleteCell.getFamilyLength(), (byte[])family, (int)0, (int)family.length));
            }
            Assert.assertEquals((String)"Should have read back as many KVs as written", (long)1000L, (long)count);
        }
    }

    static {
        int off = 0;
        Arrays.fill(VALUE, off++, off, (byte)65);
        Arrays.fill(VALUE, off++, off, (byte)66);
        Arrays.fill(VALUE, off, off += 2, (byte)67);
        Arrays.fill(VALUE, off, off += 3, (byte)68);
        Arrays.fill(VALUE, off, off += 5, (byte)69);
        Arrays.fill(VALUE, off, off += 8, (byte)70);
        Arrays.fill(VALUE, off, off += 13, (byte)71);
        Arrays.fill(VALUE, off, off += 21, (byte)72);
        Arrays.fill(VALUE, off, off += 34, (byte)73);
        Arrays.fill(VALUE, off, off += 55, (byte)74);
        Arrays.fill(VALUE, off, off += 89, (byte)75);
        Arrays.fill(VALUE, off, off += 144, (byte)76);
        Arrays.fill(VALUE, off, off += 233, (byte)77);
        Arrays.fill(VALUE, off, off += 377, (byte)78);
        Arrays.fill(VALUE, off, off += 610, (byte)79);
        Arrays.fill(VALUE, off, off += 987, (byte)80);
        Arrays.fill(VALUE, off, off += 1597, (byte)81);
    }
}

