/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.hadoop.hbase.wal.WALCorruptionWithMultiPutDueToDanglingByteBufferTestBase;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestFSHLogCorruptionWithMultiPutDueToDanglingByteBuffer
extends WALCorruptionWithMultiPutDueToDanglingByteBufferTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSHLogCorruptionWithMultiPutDueToDanglingByteBuffer.class);

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.wal.provider", PauseWALProvider.class, WALProvider.class);
        UTIL.getConfiguration().setInt(HRegion.HBASE_REGIONSERVER_MINIBATCH_SIZE, 1);
        UTIL.getConfiguration().set("hbase.rpc.server.impl", SimpleRpcServer.class.getName());
        UTIL.getConfiguration().setInt("hbase.server.allocator.max.buffer.count", 1);
        UTIL.getConfiguration().setInt("hbase.server.allocator.buffer.size", 1024);
        UTIL.getConfiguration().setInt("hbase.server.allocator.minimal.allocate.size", 500);
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, CF);
        UTIL.waitTableAvailable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    public static final class PauseWALProvider
    extends AbstractFSWALProvider<PauseWAL> {
        protected PauseWAL createWAL() throws IOException {
            return new PauseWAL(CommonFSUtils.getWALFileSystem((Configuration)this.conf), CommonFSUtils.getWALRootDir((Configuration)this.conf), PauseWALProvider.getWALDirectoryName((String)this.factory.factoryId), PauseWALProvider.getWALArchiveDirectoryName((Configuration)this.conf, (String)this.factory.factoryId), this.conf, this.listeners, true, this.logPrefix, ".meta".equals(this.providerId) ? ".meta" : null);
        }

        protected void doInit(Configuration conf) throws IOException {
        }
    }

    public static final class PauseWAL
    extends FSHLog {
        private int testTableWalAppendsCount = 0;

        public PauseWAL(FileSystem fs, Path rootDir, String logDir, String archiveDir, Configuration conf, List<WALActionsListener> listeners, boolean failIfWALExists, String prefix, String suffix) throws IOException {
            super(fs, rootDir, logDir, archiveDir, conf, listeners, failIfWALExists, prefix, suffix);
        }

        protected void atHeadOfRingBufferEventHandlerAppend() {
            if (WALCorruptionWithMultiPutDueToDanglingByteBufferTestBase.ARRIVE != null) {
                if (this.testTableWalAppendsCount == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.testTableWalAppendsCount == 1) {
                    WALCorruptionWithMultiPutDueToDanglingByteBufferTestBase.ARRIVE.countDown();
                    try {
                        WALCorruptionWithMultiPutDueToDanglingByteBufferTestBase.RESUME.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++this.testTableWalAppendsCount;
            }
        }
    }
}

