/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.ByteArrayOutputStream;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.encoding.NoneEncoder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RowIndexEncoderV1 {
    private static final Logger LOG = LoggerFactory.getLogger(RowIndexEncoderV1.class);
    private Cell lastCell = null;
    private DataOutputStream out;
    private NoneEncoder encoder;
    private int startOffset = -1;
    private ByteArrayOutputStream rowsOffsetBAOS = new ByteArrayOutputStream(256);
    private final HFileBlockEncodingContext context;

    public RowIndexEncoderV1(DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) {
        this.out = out;
        this.encoder = new NoneEncoder(out, encodingCtx);
        this.context = encodingCtx;
    }

    public void write(Cell cell) throws IOException {
        int extraBytesForRowIndex = 0;
        if (!this.checkRow(cell)) {
            if (this.startOffset < 0) {
                this.startOffset = this.out.size();
            }
            this.rowsOffsetBAOS.writeInt(this.out.size() - this.startOffset);
            extraBytesForRowIndex = 4;
        }
        this.lastCell = cell;
        int size = this.encoder.write(cell);
        this.context.getEncodingState().postCellEncode(size, size + extraBytesForRowIndex);
    }

    protected boolean checkRow(Cell cell) throws IOException {
        boolean isDuplicateRow = false;
        if (cell == null) {
            throw new IOException("Key cannot be null or empty");
        }
        if (this.lastCell != null) {
            int keyComp = this.context.getHFileContext().getCellComparator().compareRows(this.lastCell, cell);
            if (keyComp > 0) {
                throw new IOException("Added a key not lexically larger than previous. Current cell = " + cell + ", lastCell = " + this.lastCell);
            }
            if (keyComp == 0) {
                isDuplicateRow = true;
            }
        }
        return isDuplicateRow;
    }

    public void flush() throws IOException {
        int onDiskDataSize = 0;
        if (this.startOffset >= 0) {
            onDiskDataSize = this.out.size() - this.startOffset;
        }
        this.out.writeInt(this.rowsOffsetBAOS.size() / 4);
        if (this.rowsOffsetBAOS.size() > 0) {
            this.out.write(this.rowsOffsetBAOS.getBuffer(), 0, this.rowsOffsetBAOS.size());
        }
        this.out.writeInt(onDiskDataSize);
        if (LOG.isTraceEnabled()) {
            LOG.trace("RowNumber: " + this.rowsOffsetBAOS.size() / 4 + ", onDiskDataSize: " + onDiskDataSize + ", totalOnDiskSize: " + (this.out.size() - this.startOffset));
        }
    }

    void beforeShipped() {
        if (this.lastCell != null) {
            this.lastCell = KeyValueUtil.toNewKeyCell(this.lastCell);
        }
    }
}

