/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.RSGroupableBalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.hadoop.hbase.rsgroup.RSGroupBasedLoadBalancer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={LargeTests.class})
public class TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal
extends RSGroupableBalancerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.class);
    private static RSGroupBasedLoadBalancer loadBalancer;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        groups = new String[]{"default"};
        servers = TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.generateServers(3);
        groupMap = TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.constructGroupInfo(servers, groups);
        tableDescs = TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.constructTableDesc(false);
        conf.set("hbase.regions.slop", "0");
        conf.setFloat("hbase.master.balancer.stochastic.readRequestCost", 10000.0f);
        conf.set("hbase.rsgroup.grouploadbalancer.class", StochasticLoadBalancer.class.getCanonicalName());
        conf.setClass("hbase.util.ip.to.rack.determiner", BalancerTestBase.MockMapping.class, DNSToSwitchMapping.class);
        loadBalancer = new RSGroupBasedLoadBalancer();
        loadBalancer.setRsGroupInfoManager(TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.getMockedGroupInfoManager());
        loadBalancer.setMasterServices(TestRSGroupBasedLoadBalancerWithStochasticLoadBalancerAsInternal.getMockedMaster());
        loadBalancer.initialize();
    }

    private ServerMetrics mockServerMetricsWithReadRequests(ServerName server, List<RegionInfo> regionsOnServer, long readRequestCount) {
        ServerMetrics serverMetrics = (ServerMetrics)Mockito.mock(ServerMetrics.class);
        TreeMap<byte[], RegionMetrics> regionLoadMap = new TreeMap<byte[], RegionMetrics>(Bytes.BYTES_COMPARATOR);
        for (RegionInfo info : regionsOnServer) {
            RegionMetrics rl = (RegionMetrics)Mockito.mock(RegionMetrics.class);
            Mockito.when((Object)rl.getReadRequestCount()).thenReturn((Object)readRequestCount);
            Mockito.when((Object)rl.getWriteRequestCount()).thenReturn((Object)0L);
            Mockito.when((Object)rl.getMemStoreSize()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)rl.getStoreFileSize()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)rl.getRegionSizeMB()).thenReturn((Object)Size.ZERO);
            Mockito.when((Object)Float.valueOf(rl.getCurrentRegionCachedRatio())).thenReturn((Object)Float.valueOf(0.0f));
            regionLoadMap.put(info.getRegionName(), rl);
        }
        Mockito.when((Object)serverMetrics.getRegionMetrics()).thenReturn(regionLoadMap);
        return serverMetrics;
    }

    @Test
    public void testBalanceCluster() throws IOException {
        HashMap<ServerName, List<RegionInfo>> clusterState = new HashMap<ServerName, List<RegionInfo>>();
        ServerName serverA = (ServerName)servers.get(0);
        ServerName serverB = (ServerName)servers.get(1);
        ServerName serverC = (ServerName)servers.get(2);
        List<RegionInfo> regionsOnServerA = this.randomRegions(3);
        List<RegionInfo> regionsOnServerB = this.randomRegions(3);
        List<RegionInfo> regionsOnServerC = this.randomRegions(3);
        clusterState.put(serverA, regionsOnServerA);
        clusterState.put(serverB, regionsOnServerB);
        clusterState.put(serverC, regionsOnServerC);
        TreeMap<ServerName, ServerMetrics> serverMetricsMap = new TreeMap<ServerName, ServerMetrics>();
        serverMetricsMap.put(serverA, this.mockServerMetricsWithReadRequests(serverA, regionsOnServerA, 0L));
        serverMetricsMap.put(serverB, this.mockServerMetricsWithReadRequests(serverB, regionsOnServerB, 0L));
        serverMetricsMap.put(serverC, this.mockServerMetricsWithReadRequests(serverC, regionsOnServerC, 0L));
        ClusterMetrics clusterStatus = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterStatus.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterStatus);
        serverMetricsMap = new TreeMap();
        serverMetricsMap.put(serverA, this.mockServerMetricsWithReadRequests(serverA, regionsOnServerA, 1000L));
        serverMetricsMap.put(serverB, this.mockServerMetricsWithReadRequests(serverB, regionsOnServerB, 0L));
        serverMetricsMap.put(serverC, this.mockServerMetricsWithReadRequests(serverC, regionsOnServerC, 0L));
        clusterStatus = (ClusterMetrics)Mockito.mock(ClusterMetrics.class);
        Mockito.when((Object)clusterStatus.getLiveServerMetrics()).thenReturn(serverMetricsMap);
        loadBalancer.updateClusterMetrics(clusterStatus);
        HashMap LoadOfAllTable = this.mockClusterServersWithTables(clusterState);
        List plans = loadBalancer.balanceCluster((Map)LoadOfAllTable);
        HashSet<RegionInfo> regionsMoveFromServerA = new HashSet<RegionInfo>();
        HashSet<ServerName> targetServers = new HashSet<ServerName>();
        for (RegionPlan plan : plans) {
            if (!plan.getSource().equals((Object)serverA)) continue;
            regionsMoveFromServerA.add(plan.getRegionInfo());
            targetServers.add(plan.getDestination());
        }
        Assert.assertEquals((long)2L, (long)regionsMoveFromServerA.size());
        Assert.assertEquals((long)2L, (long)targetServers.size());
        Assert.assertTrue((boolean)regionsOnServerA.containsAll(regionsMoveFromServerA));
    }
}

