/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.api.pattern;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.internal.license.FlywayRedgateEditionRequiredException;

public class ValidatePattern {
    private final String migrationType;
    private final String migrationState;
    private static final List<String> validMigrationTypes = Arrays.asList("*", "repeatable", "versioned");
    private static final List<String> validMigrationStates = Arrays.asList("*", MigrationState.MISSING_SUCCESS.getPattern(), MigrationState.PENDING.getPattern(), MigrationState.IGNORED.getPattern(), MigrationState.FUTURE_SUCCESS.getPattern());
    private final String pattern;

    public static ValidatePattern fromPattern(String pattern) {
        if (pattern == null) {
            throw new FlywayException("Null pattern not allowed.");
        }
        String[] patternParts = pattern.split(":");
        if (patternParts.length != 2) {
            throw new FlywayException("Invalid pattern '" + pattern + "'. Pattern must be of the form <migration_type>:<migration_state> See https://rd.gt/37m4hXD for full details");
        }
        String migrationType = patternParts[0].trim().toLowerCase();
        String migrationState = patternParts[1].trim().toLowerCase();
        if (migrationType.equals("repeatable") || migrationType.equals("versioned")) {
            throw new FlywayRedgateEditionRequiredException("ignoreMigrationPattern with type '" + migrationType + "'");
        }
        if (!validMigrationTypes.contains(migrationType)) {
            throw new FlywayException("Invalid migration type '" + patternParts[0] + "'. Valid types are: " + validMigrationTypes);
        }
        if (!validMigrationStates.contains(migrationState)) {
            throw new FlywayException("Invalid migration state '" + patternParts[1] + "'. Valid states are: " + validMigrationStates);
        }
        return new ValidatePattern(migrationType, migrationState, pattern);
    }

    public boolean matchesMigration(boolean isVersioned, MigrationState state) {
        if (!state.getDisplayName().equalsIgnoreCase(this.migrationState) && !this.migrationState.equals("*")) {
            return false;
        }
        if (this.migrationType.equals("*")) {
            return true;
        }
        if (isVersioned && this.migrationType.equalsIgnoreCase("versioned")) {
            return true;
        }
        return !isVersioned && this.migrationType.equalsIgnoreCase("repeatable");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidatePattern that = (ValidatePattern)o;
        return Objects.equals(this.migrationType, that.migrationType) && Objects.equals(this.migrationState, that.migrationState);
    }

    public int hashCode() {
        return Objects.hash(this.migrationType, this.migrationState);
    }

    public String toString() {
        return this.pattern;
    }

    private ValidatePattern(String migrationType, String migrationState, String pattern) {
        this.migrationType = migrationType;
        this.migrationState = migrationState;
        this.pattern = pattern;
    }
}

