/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class ExternalProcessRunner {
    public int run(String[] command, Consumer<? super String> onStdOut, Consumer<? super String> onStdErr) {
        return this.run(command, null, null, onStdOut, onStdErr);
    }

    public int run(String[] command, Path workingDirectory, Consumer<? super String> onStdOut, Consumer<? super String> onStdErr) {
        return this.run(command, workingDirectory, null, onStdOut, onStdErr);
    }

    public int run(String[] command, Path workingDirectory, String stdIn, Consumer<? super String> onStdOut, Consumer<? super String> onStdErr) {
        return this.run(command, workingDirectory, null, stdIn, onStdOut, onStdErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] command, Path workingDirectory, Map<String, String> env, String stdIn, Consumer<? super String> onStdOut, Consumer<? super String> onStdErr) {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        if (workingDirectory != null) {
            processBuilder.directory(workingDirectory.toFile());
        }
        if (env != null) {
            processBuilder.environment().putAll(env);
        }
        Process process = processBuilder.start();
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        try (InputStreamReader outStream = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
             InputStreamReader errStream = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
             OutputStreamWriter inputSteam = new OutputStreamWriter(process.getOutputStream(), StandardCharsets.UTF_8);
             Scanner stdOut = new Scanner(outStream);
             Scanner stdErr = new Scanner(errStream);){
            Future<?> handleStdOut = executorService.submit(() -> {
                while (stdOut.hasNextLine()) {
                    onStdOut.accept(stdOut.nextLine());
                }
            });
            Future<?> handleStdErr = executorService.submit(() -> {
                while (stdErr.hasNextLine()) {
                    onStdErr.accept(stdErr.nextLine());
                }
            });
            if (stdIn != null) {
                inputSteam.write(stdIn);
            }
            inputSteam.close();
            handleStdOut.get();
            handleStdErr.get();
        }
        finally {
            executorService.shutdown();
        }
        return process.waitFor();
    }
}

