/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.region;

import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.region.Region;
import com.huaweicloud.sdk.core.utils.PathUtils;
import com.huaweicloud.sdk.core.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ProfileRegionCache {
    private static final String REGIONS_FILE_REG = "^[a-zA-Z0-9._ -]+\\.(yml|yaml)$";
    private static final String DEFAULT_REGIONS_FILE_NAME = "regions.yaml";
    private static final String REGIONS_FILE_ENV = "HUAWEICLOUD_SDK_REGIONS_FILE";
    private static final ProfileRegionCache INSTANCE = ProfileRegionCache.createInstance();
    protected final Map<String, Region> value;

    private ProfileRegionCache(Map<String, Region> value) {
        this.value = value;
    }

    protected static ProfileRegionCache getInstance() {
        return INSTANCE;
    }

    private static ProfileRegionCache createInstance() {
        String regionsFilePath = ProfileRegionCache.getRegionsFilePath();
        if (Objects.isNull(regionsFilePath) || !PathUtils.isPathExist(regionsFilePath)) {
            return new ProfileRegionCache(Collections.unmodifiableMap(new LinkedHashMap()));
        }
        try {
            File file = new File(regionsFilePath).getCanonicalFile();
            if (!ProfileRegionCache.isValidRegionsFile(file)) {
                throw new SdkException(String.format("invalid regions file path: '%s'", regionsFilePath));
            }
            Map<String, Region> result = ProfileRegionCache.resolveRegions(file.getCanonicalPath());
            return new ProfileRegionCache(Collections.unmodifiableMap(result));
        }
        catch (IOException e) {
            throw new SdkException(String.format("failed to resolve file '%s'", regionsFilePath), e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Map<String, Region> resolveRegions(String filepath) {
        Map map;
        LinkedHashMap<String, Region> result;
        block10: {
            result = new LinkedHashMap<String, Region>();
            Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions()));
            try (FileInputStream inputStream = new FileInputStream(filepath);){
                Object obj = yaml.load((InputStream)inputStream);
                if (obj instanceof Map) {
                    map = (Map)obj;
                    break block10;
                }
                LinkedHashMap<String, Region> linkedHashMap = result;
                return linkedHashMap;
            }
            catch (IOException e) {
                throw new SdkException(String.format("failed to resolve file '%s'", filepath), e);
            }
        }
        for (Map.Entry next : map.entrySet()) {
            if (!(next.getValue() instanceof List)) continue;
            for (Object o : (List)next.getValue()) {
                if (!(o instanceof Map)) continue;
                Map regionMap = (Map)o;
                String id = (String)regionMap.get("id");
                String endpoint = (String)regionMap.get("endpoint");
                if (StringUtils.isEmpty(id) || StringUtils.isEmpty(endpoint)) continue;
                result.put(next.getKey().toString().toUpperCase(Locale.ROOT) + id, new Region(id, endpoint));
            }
        }
        return result;
    }

    private static String getRegionsFilePath() {
        String regionsFile = System.getenv(REGIONS_FILE_ENV);
        if (!StringUtils.isEmpty(regionsFile)) {
            return regionsFile;
        }
        String userHomePath = PathUtils.getUserHomePath();
        return StringUtils.isEmpty(userHomePath) ? null : userHomePath + File.separator + ".huaweicloud" + File.separator + DEFAULT_REGIONS_FILE_NAME;
    }

    private static boolean isValidRegionsFile(File file) {
        if (!file.getName().matches(REGIONS_FILE_REG)) {
            return false;
        }
        return PathUtils.isValidFile(file);
    }
}

