/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.otel.config;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.logback.appender.v1_0.OpenTelemetryAppender;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"warehouse.store.greptime.enabled"}, havingValue="true")
public class OpenTelemetryLogbackAppenderInstaller
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(OpenTelemetryLogbackAppenderInstaller.class);
    private final OpenTelemetry openTelemetry;

    @Autowired
    public OpenTelemetryLogbackAppenderInstaller(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    public void afterPropertiesSet() {
        if (this.openTelemetry instanceof OpenTelemetrySdk) {
            log.info("Auto-configured OpenTelemetry SDK detected. Installing OpenTelemetryAppender for Logback.");
            OpenTelemetryAppender.install((OpenTelemetry)this.openTelemetry);
        } else {
            log.warn("OpenTelemetry SDK is not an instance of OpenTelemetrySdk (type: {}). OpenTelemetryAppender for Logback will not be installed. Ensure OpenTelemetry auto-configuration is active and correctly providing an SDK.", (Object)(this.openTelemetry != null ? this.openTelemetry.getClass().getName() : "null"));
        }
    }
}

