/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;

public class HuaweiCloudExternAlert {
    public static final String FIELD_MESSAGE = "message";
    public static final String FIELD_MESSAGE_ID = "message_id";
    public static final String FIELD_TIMESTAMP = "timestamp";
    public static final String FIELD_TOPIC_URN = "topic_urn";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_SUBJECT = "subject";
    public static final String FIELD_SUBSCRIBE_URL = "subscribe_url";
    private String signature;
    private String subject;
    @JsonProperty(value="topic_urn")
    private String topicUrn;
    @JsonProperty(value="message_id")
    private String messageId;
    private String message;
    private String type;
    @JsonProperty(value="subscribe_url")
    private String subscribeUrl;
    @JsonProperty(value="signing_cert_url")
    private String signingCertUrl;
    private String timestamp;

    public static HuaweiCloudExternAlertBuilder builder() {
        return new HuaweiCloudExternAlertBuilder();
    }

    public String getSignature() {
        return this.signature;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTopicUrn() {
        return this.topicUrn;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getMessage() {
        return this.message;
    }

    public String getType() {
        return this.type;
    }

    public String getSubscribeUrl() {
        return this.subscribeUrl;
    }

    public String getSigningCertUrl() {
        return this.signingCertUrl;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @JsonProperty(value="topic_urn")
    public void setTopicUrn(String topicUrn) {
        this.topicUrn = topicUrn;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="subscribe_url")
    public void setSubscribeUrl(String subscribeUrl) {
        this.subscribeUrl = subscribeUrl;
    }

    @JsonProperty(value="signing_cert_url")
    public void setSigningCertUrl(String signingCertUrl) {
        this.signingCertUrl = signingCertUrl;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HuaweiCloudExternAlert)) {
            return false;
        }
        HuaweiCloudExternAlert other = (HuaweiCloudExternAlert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$topicUrn = this.getTopicUrn();
        String other$topicUrn = other.getTopicUrn();
        if (this$topicUrn == null ? other$topicUrn != null : !this$topicUrn.equals(other$topicUrn)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subscribeUrl = this.getSubscribeUrl();
        String other$subscribeUrl = other.getSubscribeUrl();
        if (this$subscribeUrl == null ? other$subscribeUrl != null : !this$subscribeUrl.equals(other$subscribeUrl)) {
            return false;
        }
        String this$signingCertUrl = this.getSigningCertUrl();
        String other$signingCertUrl = other.getSigningCertUrl();
        if (this$signingCertUrl == null ? other$signingCertUrl != null : !this$signingCertUrl.equals(other$signingCertUrl)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HuaweiCloudExternAlert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $topicUrn = this.getTopicUrn();
        result = result * 59 + ($topicUrn == null ? 43 : $topicUrn.hashCode());
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subscribeUrl = this.getSubscribeUrl();
        result = result * 59 + ($subscribeUrl == null ? 43 : $subscribeUrl.hashCode());
        String $signingCertUrl = this.getSigningCertUrl();
        result = result * 59 + ($signingCertUrl == null ? 43 : $signingCertUrl.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        return result;
    }

    public String toString() {
        return "HuaweiCloudExternAlert(signature=" + this.getSignature() + ", subject=" + this.getSubject() + ", topicUrn=" + this.getTopicUrn() + ", messageId=" + this.getMessageId() + ", message=" + this.getMessage() + ", type=" + this.getType() + ", subscribeUrl=" + this.getSubscribeUrl() + ", signingCertUrl=" + this.getSigningCertUrl() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public HuaweiCloudExternAlert(String signature, String subject, String topicUrn, String messageId, String message, String type, String subscribeUrl, String signingCertUrl, String timestamp) {
        this.signature = signature;
        this.subject = subject;
        this.topicUrn = topicUrn;
        this.messageId = messageId;
        this.message = message;
        this.type = type;
        this.subscribeUrl = subscribeUrl;
        this.signingCertUrl = signingCertUrl;
        this.timestamp = timestamp;
    }

    public HuaweiCloudExternAlert() {
    }

    public static class HuaweiCloudExternAlertBuilder {
        private String signature;
        private String subject;
        private String topicUrn;
        private String messageId;
        private String message;
        private String type;
        private String subscribeUrl;
        private String signingCertUrl;
        private String timestamp;

        HuaweiCloudExternAlertBuilder() {
        }

        public HuaweiCloudExternAlertBuilder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public HuaweiCloudExternAlertBuilder subject(String subject) {
            this.subject = subject;
            return this;
        }

        @JsonProperty(value="topic_urn")
        public HuaweiCloudExternAlertBuilder topicUrn(String topicUrn) {
            this.topicUrn = topicUrn;
            return this;
        }

        @JsonProperty(value="message_id")
        public HuaweiCloudExternAlertBuilder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public HuaweiCloudExternAlertBuilder message(String message) {
            this.message = message;
            return this;
        }

        public HuaweiCloudExternAlertBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="subscribe_url")
        public HuaweiCloudExternAlertBuilder subscribeUrl(String subscribeUrl) {
            this.subscribeUrl = subscribeUrl;
            return this;
        }

        @JsonProperty(value="signing_cert_url")
        public HuaweiCloudExternAlertBuilder signingCertUrl(String signingCertUrl) {
            this.signingCertUrl = signingCertUrl;
            return this;
        }

        public HuaweiCloudExternAlertBuilder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public HuaweiCloudExternAlert build() {
            return new HuaweiCloudExternAlert(this.signature, this.subject, this.topicUrn, this.messageId, this.message, this.type, this.subscribeUrl, this.signingCertUrl, this.timestamp);
        }

        public String toString() {
            return "HuaweiCloudExternAlert.HuaweiCloudExternAlertBuilder(signature=" + this.signature + ", subject=" + this.subject + ", topicUrn=" + this.topicUrn + ", messageId=" + this.messageId + ", message=" + this.message + ", type=" + this.type + ", subscribeUrl=" + this.subscribeUrl + ", signingCertUrl=" + this.signingCertUrl + ", timestamp=" + this.timestamp + ")";
        }
    }

    public static enum AlertType {
        SUBSCRIPTION("SubscriptionConfirmation"),
        UNSUBSCRIBE("UnsubscribeConfirmation"),
        NOTIFICATION("Notification");

        private final String type;

        private AlertType(String type) {
            this.type = type;
        }

        public static boolean valid(String type) {
            if (null == type || type.isEmpty()) {
                return false;
            }
            return Arrays.stream(AlertType.values()).anyMatch(alertType -> alertType.getType().equals(type));
        }

        public String getType() {
            return this.type;
        }
    }

    public static class AlertData {
        @JsonProperty(value="IsAlarm")
        private Boolean alarm;
        @JsonProperty(value="AlarmTime")
        private String alarmTime;
        @JsonProperty(value="ResourceId")
        private String resourceId;
        @JsonProperty(value="MetricName")
        private String metricName;
        @JsonProperty(value="AlarmLevel")
        private String alarmLevel;
        @JsonProperty(value="Namespace")
        private String namespace;
        @JsonProperty(value="Region")
        private String region;
        @JsonProperty(value="DimensionName")
        private String dimensionName;
        @JsonProperty(value="ResourceName")
        private String resourceName;
        @JsonProperty(value="AlarmRecordID")
        private String alarmRecordId;
        @JsonProperty(value="CurrentData")
        private String currentData;
        @JsonProperty(value="ComparisonOperator")
        private String comparisonOperator;
        @JsonProperty(value="Value")
        private String value;
        @JsonProperty(value="Count")
        private int count;

        public static AlertDataBuilder builder() {
            return new AlertDataBuilder();
        }

        public Boolean getAlarm() {
            return this.alarm;
        }

        public String getAlarmTime() {
            return this.alarmTime;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getAlarmLevel() {
            return this.alarmLevel;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getRegion() {
            return this.region;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public String getAlarmRecordId() {
            return this.alarmRecordId;
        }

        public String getCurrentData() {
            return this.currentData;
        }

        public String getComparisonOperator() {
            return this.comparisonOperator;
        }

        public String getValue() {
            return this.value;
        }

        public int getCount() {
            return this.count;
        }

        @JsonProperty(value="IsAlarm")
        public void setAlarm(Boolean alarm) {
            this.alarm = alarm;
        }

        @JsonProperty(value="AlarmTime")
        public void setAlarmTime(String alarmTime) {
            this.alarmTime = alarmTime;
        }

        @JsonProperty(value="ResourceId")
        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @JsonProperty(value="MetricName")
        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @JsonProperty(value="AlarmLevel")
        public void setAlarmLevel(String alarmLevel) {
            this.alarmLevel = alarmLevel;
        }

        @JsonProperty(value="Namespace")
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @JsonProperty(value="Region")
        public void setRegion(String region) {
            this.region = region;
        }

        @JsonProperty(value="DimensionName")
        public void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @JsonProperty(value="ResourceName")
        public void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @JsonProperty(value="AlarmRecordID")
        public void setAlarmRecordId(String alarmRecordId) {
            this.alarmRecordId = alarmRecordId;
        }

        @JsonProperty(value="CurrentData")
        public void setCurrentData(String currentData) {
            this.currentData = currentData;
        }

        @JsonProperty(value="ComparisonOperator")
        public void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @JsonProperty(value="Value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="Count")
        public void setCount(int count) {
            this.count = count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlertData)) {
                return false;
            }
            AlertData other = (AlertData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            Boolean this$alarm = this.getAlarm();
            Boolean other$alarm = other.getAlarm();
            if (this$alarm == null ? other$alarm != null : !((Object)this$alarm).equals(other$alarm)) {
                return false;
            }
            String this$alarmTime = this.getAlarmTime();
            String other$alarmTime = other.getAlarmTime();
            if (this$alarmTime == null ? other$alarmTime != null : !this$alarmTime.equals(other$alarmTime)) {
                return false;
            }
            String this$resourceId = this.getResourceId();
            String other$resourceId = other.getResourceId();
            if (this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId)) {
                return false;
            }
            String this$metricName = this.getMetricName();
            String other$metricName = other.getMetricName();
            if (this$metricName == null ? other$metricName != null : !this$metricName.equals(other$metricName)) {
                return false;
            }
            String this$alarmLevel = this.getAlarmLevel();
            String other$alarmLevel = other.getAlarmLevel();
            if (this$alarmLevel == null ? other$alarmLevel != null : !this$alarmLevel.equals(other$alarmLevel)) {
                return false;
            }
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$region = this.getRegion();
            String other$region = other.getRegion();
            if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
                return false;
            }
            String this$dimensionName = this.getDimensionName();
            String other$dimensionName = other.getDimensionName();
            if (this$dimensionName == null ? other$dimensionName != null : !this$dimensionName.equals(other$dimensionName)) {
                return false;
            }
            String this$resourceName = this.getResourceName();
            String other$resourceName = other.getResourceName();
            if (this$resourceName == null ? other$resourceName != null : !this$resourceName.equals(other$resourceName)) {
                return false;
            }
            String this$alarmRecordId = this.getAlarmRecordId();
            String other$alarmRecordId = other.getAlarmRecordId();
            if (this$alarmRecordId == null ? other$alarmRecordId != null : !this$alarmRecordId.equals(other$alarmRecordId)) {
                return false;
            }
            String this$currentData = this.getCurrentData();
            String other$currentData = other.getCurrentData();
            if (this$currentData == null ? other$currentData != null : !this$currentData.equals(other$currentData)) {
                return false;
            }
            String this$comparisonOperator = this.getComparisonOperator();
            String other$comparisonOperator = other.getComparisonOperator();
            if (this$comparisonOperator == null ? other$comparisonOperator != null : !this$comparisonOperator.equals(other$comparisonOperator)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlertData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            Boolean $alarm = this.getAlarm();
            result = result * 59 + ($alarm == null ? 43 : ((Object)$alarm).hashCode());
            String $alarmTime = this.getAlarmTime();
            result = result * 59 + ($alarmTime == null ? 43 : $alarmTime.hashCode());
            String $resourceId = this.getResourceId();
            result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
            String $metricName = this.getMetricName();
            result = result * 59 + ($metricName == null ? 43 : $metricName.hashCode());
            String $alarmLevel = this.getAlarmLevel();
            result = result * 59 + ($alarmLevel == null ? 43 : $alarmLevel.hashCode());
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $region = this.getRegion();
            result = result * 59 + ($region == null ? 43 : $region.hashCode());
            String $dimensionName = this.getDimensionName();
            result = result * 59 + ($dimensionName == null ? 43 : $dimensionName.hashCode());
            String $resourceName = this.getResourceName();
            result = result * 59 + ($resourceName == null ? 43 : $resourceName.hashCode());
            String $alarmRecordId = this.getAlarmRecordId();
            result = result * 59 + ($alarmRecordId == null ? 43 : $alarmRecordId.hashCode());
            String $currentData = this.getCurrentData();
            result = result * 59 + ($currentData == null ? 43 : $currentData.hashCode());
            String $comparisonOperator = this.getComparisonOperator();
            result = result * 59 + ($comparisonOperator == null ? 43 : $comparisonOperator.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "HuaweiCloudExternAlert.AlertData(alarm=" + this.getAlarm() + ", alarmTime=" + this.getAlarmTime() + ", resourceId=" + this.getResourceId() + ", metricName=" + this.getMetricName() + ", alarmLevel=" + this.getAlarmLevel() + ", namespace=" + this.getNamespace() + ", region=" + this.getRegion() + ", dimensionName=" + this.getDimensionName() + ", resourceName=" + this.getResourceName() + ", alarmRecordId=" + this.getAlarmRecordId() + ", currentData=" + this.getCurrentData() + ", comparisonOperator=" + this.getComparisonOperator() + ", value=" + this.getValue() + ", count=" + this.getCount() + ")";
        }

        public AlertData(Boolean alarm, String alarmTime, String resourceId, String metricName, String alarmLevel, String namespace, String region, String dimensionName, String resourceName, String alarmRecordId, String currentData, String comparisonOperator, String value, int count) {
            this.alarm = alarm;
            this.alarmTime = alarmTime;
            this.resourceId = resourceId;
            this.metricName = metricName;
            this.alarmLevel = alarmLevel;
            this.namespace = namespace;
            this.region = region;
            this.dimensionName = dimensionName;
            this.resourceName = resourceName;
            this.alarmRecordId = alarmRecordId;
            this.currentData = currentData;
            this.comparisonOperator = comparisonOperator;
            this.value = value;
            this.count = count;
        }

        public AlertData() {
        }

        public static class AlertDataBuilder {
            private Boolean alarm;
            private String alarmTime;
            private String resourceId;
            private String metricName;
            private String alarmLevel;
            private String namespace;
            private String region;
            private String dimensionName;
            private String resourceName;
            private String alarmRecordId;
            private String currentData;
            private String comparisonOperator;
            private String value;
            private int count;

            AlertDataBuilder() {
            }

            @JsonProperty(value="IsAlarm")
            public AlertDataBuilder alarm(Boolean alarm) {
                this.alarm = alarm;
                return this;
            }

            @JsonProperty(value="AlarmTime")
            public AlertDataBuilder alarmTime(String alarmTime) {
                this.alarmTime = alarmTime;
                return this;
            }

            @JsonProperty(value="ResourceId")
            public AlertDataBuilder resourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            @JsonProperty(value="MetricName")
            public AlertDataBuilder metricName(String metricName) {
                this.metricName = metricName;
                return this;
            }

            @JsonProperty(value="AlarmLevel")
            public AlertDataBuilder alarmLevel(String alarmLevel) {
                this.alarmLevel = alarmLevel;
                return this;
            }

            @JsonProperty(value="Namespace")
            public AlertDataBuilder namespace(String namespace) {
                this.namespace = namespace;
                return this;
            }

            @JsonProperty(value="Region")
            public AlertDataBuilder region(String region) {
                this.region = region;
                return this;
            }

            @JsonProperty(value="DimensionName")
            public AlertDataBuilder dimensionName(String dimensionName) {
                this.dimensionName = dimensionName;
                return this;
            }

            @JsonProperty(value="ResourceName")
            public AlertDataBuilder resourceName(String resourceName) {
                this.resourceName = resourceName;
                return this;
            }

            @JsonProperty(value="AlarmRecordID")
            public AlertDataBuilder alarmRecordId(String alarmRecordId) {
                this.alarmRecordId = alarmRecordId;
                return this;
            }

            @JsonProperty(value="CurrentData")
            public AlertDataBuilder currentData(String currentData) {
                this.currentData = currentData;
                return this;
            }

            @JsonProperty(value="ComparisonOperator")
            public AlertDataBuilder comparisonOperator(String comparisonOperator) {
                this.comparisonOperator = comparisonOperator;
                return this;
            }

            @JsonProperty(value="Value")
            public AlertDataBuilder value(String value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="Count")
            public AlertDataBuilder count(int count) {
                this.count = count;
                return this;
            }

            public AlertData build() {
                return new AlertData(this.alarm, this.alarmTime, this.resourceId, this.metricName, this.alarmLevel, this.namespace, this.region, this.dimensionName, this.resourceName, this.alarmRecordId, this.currentData, this.comparisonOperator, this.value, this.count);
            }

            public String toString() {
                return "HuaweiCloudExternAlert.AlertData.AlertDataBuilder(alarm=" + this.alarm + ", alarmTime=" + this.alarmTime + ", resourceId=" + this.resourceId + ", metricName=" + this.metricName + ", alarmLevel=" + this.alarmLevel + ", namespace=" + this.namespace + ", region=" + this.region + ", dimensionName=" + this.dimensionName + ", resourceName=" + this.resourceName + ", alarmRecordId=" + this.alarmRecordId + ", currentData=" + this.currentData + ", comparisonOperator=" + this.comparisonOperator + ", value=" + this.value + ", count=" + this.count + ")";
            }
        }
    }

    public static class AlertMessage {
        private String version;
        private AlertData data;

        public static AlertMessageBuilder builder() {
            return new AlertMessageBuilder();
        }

        public String getVersion() {
            return this.version;
        }

        public AlertData getData() {
            return this.data;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setData(AlertData data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlertMessage)) {
                return false;
            }
            AlertMessage other = (AlertMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            AlertData this$data = this.getData();
            AlertData other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AlertMessage;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            AlertData $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        public String toString() {
            return "HuaweiCloudExternAlert.AlertMessage(version=" + this.getVersion() + ", data=" + this.getData() + ")";
        }

        public AlertMessage(String version, AlertData data) {
            this.version = version;
            this.data = data;
        }

        public AlertMessage() {
        }

        public static class AlertMessageBuilder {
            private String version;
            private AlertData data;

            AlertMessageBuilder() {
            }

            public AlertMessageBuilder version(String version) {
                this.version = version;
                return this;
            }

            public AlertMessageBuilder data(AlertData data) {
                this.data = data;
                return this;
            }

            public AlertMessage build() {
                return new AlertMessage(this.version, this.data);
            }

            public String toString() {
                return "HuaweiCloudExternAlert.AlertMessage.AlertMessageBuilder(version=" + this.version + ", data=" + this.data + ")";
            }
        }
    }
}

