/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stanford.nlp.simple;

import edu.stanford.nlp.simple.Sentence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.Bag;
import org.apache.commons.collections4.bag.HashBag;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.ParsedSentence;

public final class ParsedSentenceImpl
implements ParsedSentence {
    private final Object[] inputRow;
    private final String sentenceText;
    private final List<String> sentenceWords;
    private final long index;
    private final long indexBegin;
    private final long indexEnd;
    private final long characterCount;
    private final long wordCount;
    private final List<String> sentencePosTags;
    private final Bag<String> sentencePosBag = new HashBag();
    private final String sentenceTextPosTagged;

    public ParsedSentenceImpl(Object[] inputRow, Sentence sentence, boolean pos) {
        this.inputRow = inputRow;
        this.sentenceText = StringUtils.trim((String)sentence.text());
        this.sentenceWords = sentence.words();
        this.index = sentence.sentenceIndex();
        this.indexBegin = sentence.sentenceTokenOffsetBegin();
        this.indexEnd = sentence.sentenceTokenOffsetEnd();
        this.characterCount = StringUtils.length((CharSequence)this.sentenceText);
        this.wordCount = this.sentenceWords.stream().filter(this::isWord).count();
        if (pos) {
            this.sentencePosTags = sentence.posTags();
            this.sentencePosBag.addAll(this.sentencePosTags);
            ArrayList<String> sentenceTextPosTagged = new ArrayList<String>(this.sentenceWords);
            for (int i = 0; i < this.sentencePosTags.size(); ++i) {
                sentenceTextPosTagged.set(i, (String)sentenceTextPosTagged.get(i) + "{" + this.sentencePosTags.get(i) + "}");
            }
            this.sentenceTextPosTagged = StringUtils.join(sentenceTextPosTagged, (String)" ");
        } else {
            this.sentencePosTags = Collections.emptyList();
            this.sentenceTextPosTagged = null;
        }
    }

    private boolean isWord(String word) {
        if (StringUtils.isBlank((CharSequence)(word = StringUtils.trim((String)word)))) {
            return false;
        }
        for (int i = 0; i < word.length(); ++i) {
            char ch = word.charAt(i);
            if (!Character.isLetterOrDigit(ch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object[] getInputRow() {
        return this.inputRow;
    }

    @Override
    public String getSentenceText() {
        return this.sentenceText;
    }

    @Override
    public List<String> getSentenceWords() {
        return this.sentenceWords;
    }

    @Override
    public List<String> getSentencePosTags() {
        return this.sentencePosTags;
    }

    @Override
    public Bag<String> getSentencePosBag() {
        return this.sentencePosBag;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public long getIndexBegin() {
        return this.indexBegin;
    }

    @Override
    public long getIndexEnd() {
        return this.indexEnd;
    }

    @Override
    public long getCharacterCount() {
        return this.characterCount;
    }

    @Override
    public long getWordCount() {
        return this.wordCount;
    }

    @Override
    public String getSentenceTextPosTagged() {
        return this.sentenceTextPosTagged;
    }
}

