/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.LegacyStackReader;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;
import org.gridkit.jvmtool.stacktrace.StackTraceReaderV1;
import org.gridkit.jvmtool.stacktrace.StackTraceReaderV2;
import org.gridkit.jvmtool.stacktrace.StackTraceWriter;
import org.gridkit.jvmtool.stacktrace.StackTraceWriterV2;
import org.gridkit.jvmtool.stacktrace.ThreadEventCodec;

public class StackTraceCodec {
    static final byte[] MAGIC = StackTraceCodec.toBytes("TRACEDUMP_1 ");
    static final byte[] MAGIC2 = StackTraceCodec.toBytes("TRACEDUMP_2 ");
    static final byte[] MAGIC4 = StackTraceCodec.toBytes("EVENTDUMP_1 ");
    static final String TK_PART = "(stored-parts)";
    static final String TK_PART_TIMESTAMP = "timestamp";
    static final String TK_PART_THREAD_DETAILS = "thread-details";
    static final String TK_PART_THREAD_STACK = "thread-stack";
    static final String TK_PART_TAGS = "tags";
    static final String TK_PART_COUNTERS = "counters";
    static final byte TAG_STRING = 1;
    static final byte TAG_FRAME = 2;
    static final byte TAG_EVENT = 3;
    static final byte TAG_DYN_STRING = 4;
    static final byte TAG_COUNTER = 5;
    static final byte TAG_TAG_SET = 6;
    static final long TIME_ANCHOR = 1391255854894L;
    static final byte DIC_ADD_TAG = 1;
    static final byte DIC_ADD_KEY = 2;
    static final byte DIC_SET_KEY = 3;
    static final byte DIC_REMOVE_KEY = 4;
    static final byte DIC_REMOVE_TAG = 5;
    static final String[] PRESET_TAG_KEY_V4 = new String[]{"(stored-parts)", "jvm.event", "thread.javaId", "thread.javaName", "thread.javaState", "java.cpu-time.ms", "java.cpu-time.user.ms", "java.allocated.bytes", "java.wait-count", "java.wait-time.ms", "java.blocked-count", "java.blocked-time.ms", "jvm.gc.name", "jvm.gc.memory-spaces", "jvm.gc.count", "jvm.gc.total-time"};
    static final String[] PRESET_TAG_TAG_V4 = new String[]{"", "counters", "tags", "thread-details", "thread-stack", "timestamp", "jvm.thread-snapshot", "jvm.event.gc", "jvm.event.stw"};

    private static byte[] toBytes(String text) {
        try {
            return text.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static StackTraceWriter newWriter(OutputStream os) throws IOException {
        return new StackTraceWriterV2(os);
    }

    public static StackTraceReader newReader(InputStream is) throws IOException {
        return StackTraceCodec.newReaderInternal(is);
    }

    public static StackTraceReader newReader(String ... files) throws IOException {
        return StackTraceCodec.newReaderInternal(files);
    }

    public static StackTraceReader newEventReader(InputStream is) throws IOException {
        return StackTraceCodec.newReaderInternal(is);
    }

    public static StackTraceReader newEventReader(String ... files) throws IOException {
        return StackTraceCodec.newReaderInternal(files);
    }

    private static StackTraceReader newReaderInternal(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        byte[] magic = new byte[MAGIC.length];
        dis.readFully(magic);
        if (Arrays.equals(MAGIC, magic)) {
            return new StackTraceReaderV1(is);
        }
        if (Arrays.equals(MAGIC2, magic)) {
            return new StackTraceReaderV2(is);
        }
        if (Arrays.equals(MAGIC4, magic)) {
            return new LegacyStackReader(ThreadEventCodec.createEventReader(magic, is));
        }
        throw new IOException("Unknown magic [" + new String(magic) + "]");
    }

    private static StackTraceReader newReaderInternal(String ... files) throws IOException {
        final ArrayList<String> fileList = new ArrayList<String>(Arrays.asList(files));
        return new ChainedStackTraceReader(){

            @Override
            protected StackTraceReader next() {
                while (!fileList.isEmpty()) {
                    String file = (String)fileList.remove(0);
                    File f = new File(file);
                    if (!f.isFile()) continue;
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        return StackTraceCodec.newReaderInternal(fis);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    static int readVarInt(DataInput dis) throws IOException {
        byte b = dis.readByte();
        if ((b & 0x80) == 0) {
            return 0x7F & b;
        }
        int v = 0x7F & b;
        b = dis.readByte();
        v |= (0x7F & b) << 7;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7F & b) << 14;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        return v |= (0xFF & b) << 21;
    }

    static long readVarLong(DataInput dis) throws IOException {
        byte b = dis.readByte();
        if ((b & 0x80) == 0) {
            return 0x7F & b;
        }
        long v = 0x7F & b;
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 7;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 14;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 21;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 28;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 35;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 42;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 49;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        return v |= (0xFFL & (long)b) << 56;
    }

    static long readTimestamp(DataInput dis) throws IOException {
        return 1391255854894L + StackTraceCodec.readVarLong(dis);
    }

    static void writeVarInt(DataOutput dos, int v) throws IOException {
        if (v < 0) {
            throw new IllegalArgumentException("Out of bounds: " + v);
        }
        int val = v;
        if ((val & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF00) == 0) {
            dos.write(val);
            return;
        }
        throw new IllegalArgumentException("Out of bounds: " + v);
    }

    static void writeVarLong(DataOutput dos, long v) throws IOException {
        long val = v;
        if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF00L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        throw new IllegalArgumentException("Out of bounds: " + v);
    }

    static void writeTimestamp(DataOutput dos, long epoch) throws IOException {
        StackTraceCodec.writeVarLong(dos, epoch - 1391255854894L);
    }

    public static abstract class ChainedStackTraceReader
    implements StackTraceReader {
        private StackTraceReader current;

        protected abstract StackTraceReader next();

        @Override
        public boolean isLoaded() {
            if (this.current == null) {
                this.current = this.next();
            }
            return this.current != null && this.current.isLoaded();
        }

        @Override
        public long getThreadId() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getThreadId();
        }

        @Override
        public String getThreadName() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getThreadName();
        }

        @Override
        public long getTimestamp() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getTimestamp();
        }

        @Override
        public Thread.State getThreadState() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getThreadState();
        }

        @Override
        public CounterCollection getCounters() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getCounters();
        }

        @Override
        public StackTraceElement[] getTrace() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getTrace();
        }

        @Override
        public StackFrameList getStackTrace() {
            if (this.current == null) {
                new NoSuchElementException();
            }
            return this.current.getStackTrace();
        }

        @Override
        public boolean loadNext() throws IOException {
            if (this.current == null) {
                this.current = this.next();
                if (this.current == null) {
                    return false;
                }
            }
            if (this.current.loadNext()) {
                return true;
            }
            this.current = null;
            return this.loadNext();
        }
    }
}

