/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;

public class AS400UnsignedBin1
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private static final int SIZE = 1;
    private static final short MIN_VALUE = 0;
    private static final short MAX_VALUE = 255;
    private static final short DEFAULT_VALUE = 0;

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return 1;
    }

    @Override
    public Object getDefaultValue() {
        return (short)0;
    }

    @Override
    public int getInstanceType() {
        return 15;
    }

    @Override
    public Class getJavaType() {
        return Short.class;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        short shortValue = (Short)javaValue;
        return this.toBytes(shortValue);
    }

    public byte[] toBytes(short shortValue) {
        byte[] as400Value = new byte[1];
        this.toBytes(shortValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    public int toBytes(short shortValue, byte[] as400Value) {
        return this.toBytes(shortValue, as400Value, 0);
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        short shortValue = (Short)javaValue;
        return this.toBytes(shortValue, as400Value, offset);
    }

    public int toBytes(short shortValue, byte[] as400Value, int offset) {
        if (shortValue < 0 || shortValue > 255) {
            throw new ExtendedIllegalArgumentException("shortValue (" + String.valueOf(shortValue) + ")", 4);
        }
        as400Value[offset] = (byte)(shortValue & 0xFF);
        return 1;
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toShort(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        return this.toShort(as400Value, offset);
    }

    public short toShort(byte[] as400Value) {
        return this.toShort(as400Value, 0);
    }

    public short toShort(byte[] as400Value, int offset) {
        return (short)(0xFF & as400Value[offset]);
    }
}

