/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.DataArea;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.Serializable;

public class CharacterDataArea
extends DataArea
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2007 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    static final int DEFAULT_LENGTH = 32;
    static final int UNKNOWN_LENGTH = 0;
    private String initialValue_ = " ";

    public CharacterDataArea() {
        this.length_ = 0;
        this.dataAreaType_ = 1;
    }

    public CharacterDataArea(AS400 system, String path) {
        super(system, path);
        this.length_ = 0;
        this.dataAreaType_ = 1;
    }

    public void clear() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.clear();
        this.fireCleared();
    }

    public void create() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.length_ == 0) {
            this.length_ = 32;
        }
        this.impl_.create(this.length_, this.initialValue_, this.textDescription_, this.authority_);
        this.fireCreated();
    }

    public void create(int length, String initialValue, String textDescription, String authority) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        if (length < 1 || length > 2000) {
            throw new ExtendedIllegalArgumentException("length", 4);
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue");
        }
        if (initialValue.length() == 0) {
            throw new ExtendedIllegalArgumentException("initialValue", 1);
        }
        if (textDescription == null) {
            throw new NullPointerException("textDescription");
        }
        if (textDescription.length() > 50) {
            throw new ExtendedIllegalArgumentException("textDescription", 1);
        }
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (authority.length() == 0 || authority.length() > 10) {
            throw new ExtendedIllegalArgumentException("authority", 1);
        }
        this.length_ = length;
        this.initialValue_ = initialValue;
        this.textDescription_ = textDescription;
        this.authority_ = authority;
        this.create();
    }

    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.delete0();
    }

    @Override
    public String getPath() {
        return super.getPath();
    }

    public String read() throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        String val = this.impl_.retrieve(-1, this.length_);
        this.fireRead();
        return val;
    }

    public String read(int type) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        String val = this.impl_.retrieve(-1, this.length_, type);
        this.fireRead();
        return val;
    }

    public String read(int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataLength < 1 || dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataAreaOffset + dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String val = this.impl_.retrieve(dataAreaOffset, dataLength);
        this.fireRead();
        return val;
    }

    public String read(int dataAreaOffset, int dataLength, int type) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.length_ == 0) {
            this.length_ = this.getLength();
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (dataLength < 1 || dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (dataAreaOffset + dataLength > this.length_) {
            throw new ExtendedIllegalArgumentException("dataLength", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        String val = this.impl_.retrieve(dataAreaOffset, dataLength, type);
        this.fireRead();
        return val;
    }

    @Override
    public int read(byte[] dataBuffer, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, InterruptedException, IOException, ObjectDoesNotExistException {
        return super.read(dataBuffer, dataBufferOffset, dataAreaOffset, dataLength);
    }

    @Override
    public void setPath(String path) throws PropertyVetoException {
        super.setPath(path);
    }

    public void write(String data) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (data.length() < 1) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data, 0);
        this.fireWritten();
    }

    public void write(String data, int dataAreaOffset) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        block7: {
            if (data == null) {
                throw new NullPointerException("data");
            }
            if (data.length() < 1) {
                throw new ExtendedIllegalArgumentException("data", 1);
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException iote) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block7;
                    Trace.log(4, "Unexpected exception when retrieving length for character data area.", (Throwable)iote);
                }
            }
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data, dataAreaOffset);
        this.fireWritten();
    }

    public void write(String data, int dataAreaOffset, int type) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        block7: {
            if (data == null) {
                throw new NullPointerException("data");
            }
            if (this.length_ == 0) {
                try {
                    this.length_ = this.getLength();
                }
                catch (IllegalObjectTypeException iote) {
                    if (!Trace.isTraceOn() || !Trace.isTraceWarningOn()) break block7;
                    Trace.log(4, "Unexpected exception when retrieving length for character data area.", (Throwable)iote);
                }
            }
        }
        if (data.length() < 1) {
            throw new ExtendedIllegalArgumentException("data", 1);
        }
        if (dataAreaOffset < 0 || dataAreaOffset >= this.length_) {
            throw new ExtendedIllegalArgumentException("dataAreaOffset", 2);
        }
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        this.impl_.write(data, dataAreaOffset, type);
        this.fireWritten();
    }

    @Override
    public void write(byte[] dataBuffer, int dataBufferOffset, int dataAreaOffset, int dataLength) throws AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        super.write(dataBuffer, dataBufferOffset, dataAreaOffset, dataLength);
    }
}

