/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;

public class DataQueueAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private String authority_ = "*LIBCRTAUT";
    private String description_ = "";
    private int entryLength_ = 1000;
    private boolean FIFO_ = true;
    private boolean forceToAuxiliaryStorage_ = false;
    private int keyLength_ = 0;
    private boolean saveSenderInfo_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        DataQueueAttributes dataQueueAttributes = this;
        synchronized (dataQueueAttributes) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        DataQueueAttributes dataQueueAttributes = this;
        synchronized (dataQueueAttributes) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(listener);
        }
    }

    public String getAuthority() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting authority: " + this.authority_);
        }
        return this.authority_;
    }

    public String getDescription() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting description: " + this.description_);
        }
        return this.description_;
    }

    public int getEntryLength() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting max entry length:", this.entryLength_);
        }
        return this.entryLength_;
    }

    public int getKeyLength() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting key length:", this.keyLength_);
        }
        return this.keyLength_;
    }

    public boolean isFIFO() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if is FIFO:", this.FIFO_);
        }
        return this.FIFO_;
    }

    public boolean isForceToAuxiliaryStorage() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if force to auxiliary storage:", this.forceToAuxiliaryStorage_);
        }
        return this.forceToAuxiliaryStorage_;
    }

    public boolean isSaveSenderInfo() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if save sender information:", this.saveSenderInfo_);
        }
        return this.saveSenderInfo_;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (listener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(listener);
        }
    }

    public void setAuthority(String authority) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting authority: " + authority);
        }
        if (authority == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        if (!((authority = authority.toUpperCase().trim()).equals("*ALL") || authority.equals("*CHANGE") || authority.equals("*EXCLUDE") || authority.equals("*USE") || authority.equals("*LIBCRTAUT"))) {
            Trace.log(2, "Value of parameter 'authority' is not valid: " + authority);
            throw new ExtendedIllegalArgumentException("authority (" + authority + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.authority_ = authority;
        } else {
            String oldValue = this.authority_;
            String newValue = authority;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("authority", oldValue, newValue);
            }
            this.authority_ = authority;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("authority", oldValue, newValue);
            }
        }
    }

    public void setDescription(String description) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting description: " + description);
        }
        if (description == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (description.length() > 50) {
            Trace.log(2, "Length of parameter 'description' is not valid: " + description);
            throw new ExtendedIllegalArgumentException("description (" + description + ")", 1);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.description_ = description;
        } else {
            String oldValue = this.description_;
            String newValue = description;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("description", oldValue, newValue);
            }
            this.description_ = description;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("description", oldValue, newValue);
            }
        }
    }

    public void setEntryLength(int entryLength) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting max entry length:", entryLength);
        }
        if (entryLength < 1 || entryLength > 64512) {
            Trace.log(2, "Value of parameter 'entryLength' is not valid:", entryLength);
            throw new ExtendedIllegalArgumentException("entryLength (" + entryLength + ")", 4);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.entryLength_ = entryLength;
        } else {
            Integer oldValue = this.entryLength_;
            Integer newValue = entryLength;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("entryLength", oldValue, newValue);
            }
            this.entryLength_ = entryLength;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("entryLength", oldValue, newValue);
            }
        }
    }

    public void setFIFO(boolean FIFO) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting FIFO:", FIFO);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.FIFO_ = FIFO;
        } else {
            Boolean oldValue = this.FIFO_;
            Boolean newValue = FIFO;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("FIFO", oldValue, newValue);
            }
            this.FIFO_ = FIFO;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("FIFO", oldValue, newValue);
            }
        }
    }

    public void setForceToAuxiliaryStorage(boolean forceToAuxiliaryStorage) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting force to auxiliary storage:", forceToAuxiliaryStorage);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.forceToAuxiliaryStorage_ = forceToAuxiliaryStorage;
        } else {
            Boolean oldValue = this.forceToAuxiliaryStorage_;
            Boolean newValue = forceToAuxiliaryStorage;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("forceToAuxiliaryStorage", oldValue, newValue);
            }
            this.forceToAuxiliaryStorage_ = forceToAuxiliaryStorage;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("forceToAuxiliaryStorage", oldValue, newValue);
            }
        }
    }

    public void setKeyLength(int keyLength) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting key length:", keyLength);
        }
        if (keyLength < 1 || keyLength > 256) {
            Trace.log(2, "Value of parameter 'keyLength' is not valid:", keyLength);
            throw new ExtendedIllegalArgumentException("keyLength (" + keyLength + ")", 4);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.keyLength_ = keyLength;
        } else {
            Integer oldValue = this.keyLength_;
            Integer newValue = keyLength;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("keyLength", oldValue, newValue);
            }
            this.keyLength_ = keyLength;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("keyLength", oldValue, newValue);
            }
        }
    }

    public void setSaveSenderInfo(boolean saveSenderInfo) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting save sender information:", saveSenderInfo);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.saveSenderInfo_ = saveSenderInfo;
        } else {
            Boolean oldValue = this.saveSenderInfo_;
            Boolean newValue = saveSenderInfo;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("saveSenderInfo", oldValue, newValue);
            }
            this.saveSenderInfo_ = saveSenderInfo;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("saveSenderInfo", oldValue, newValue);
            }
        }
    }
}

