/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;

class IFSReadReq
extends IFSDataStreamReq {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int BASE_OFFSET_OFFSET = 26;
    private static final int RELATIVE_OFFSET_OFFSET = 30;
    private static final int READ_LENGTH_OFFSET = 34;
    private static final int PREREAD_LENGTH_OFFSET = 38;
    private static final int LARGE_BASE_OFFSET_OFFSET = 42;
    private static final int LARGE_RELATIVE_OFFSET_OFFSET = 50;

    IFSReadReq(int fileHandle, long offset, int length, int datastreamLevel) {
        super(20 + IFSReadReq.getTemplateLength(datastreamLevel));
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSReadReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(3);
        this.set32bit(fileHandle, 22);
        if (datastreamLevel < 16) {
            this.set32bit(0, 26);
            this.set32bit((int)offset, 30);
        } else {
            this.set32bit(0, 26);
            this.set32bit(0, 30);
            this.set64bit(0L, 42);
            this.set64bit(offset, 50);
        }
        this.set32bit(length, 34);
        this.set32bit(0, 38);
    }

    private static final int getTemplateLength(int datastreamLevel) {
        return datastreamLevel < 16 ? 22 : 38;
    }
}

