/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util;

import com.ibm.as400.access.AS400JDBCDriver;
import java.lang.reflect.Field;

public class AboutToolbox {
    public static void main(String[] args) {
        String versionInfo = args.length == 1 && args[0].equals("RELEASENAME") ? AboutToolbox.getReleaseName() : AboutToolbox.getVersionDescription();
        System.out.println(versionInfo);
    }

    public static String getReleaseName() {
        StringBuffer sbuf = new StringBuffer(200);
        try {
            Class<?> copyright = Class.forName("com.ibm.as400.access.Copyright");
            Field version = copyright.getDeclaredField("JTOpenName");
            sbuf.append(version.get(null));
        }
        catch (NoSuchFieldException e) {
            sbuf.append("JTOpen X.X ");
        }
        catch (Exception e) {
            sbuf.append("\nUnexpected error occurred: " + e);
        }
        return sbuf.toString();
    }

    public static String getVersionDescription() {
        StringBuffer sbuf = new StringBuffer(200);
        sbuf.append("\nIBM Toolbox for Java:\n");
        try {
            Class<?> copyright = Class.forName("com.ibm.as400.access.Copyright");
            Field version = copyright.getDeclaredField("version");
            sbuf.append(version.get(null));
            try {
                Class<?> driver = Class.forName("com.ibm.as400.access.AS400JDBCDriver");
                Field majorVersion = driver.getDeclaredField("JDBC_MAJOR_VERSION_");
                Field minorVersion = driver.getDeclaredField("JDBC_MINOR_VERSION_");
                sbuf.append("\nSupports JDBC version " + majorVersion.getInt(null) + "." + minorVersion.getInt(null));
            }
            catch (NoSuchFieldException driver) {
                // empty catch block
            }
            try {
                AS400JDBCDriver d = new AS400JDBCDriver();
                int driverMajor = d.getMajorVersion();
                int driverMinor = d.getMinorVersion();
                sbuf.append("\nToolbox driver version " + driverMajor + "." + driverMinor);
            }
            catch (Throwable throwable) {}
        }
        catch (NoSuchFieldException e) {
            sbuf.append("\nYour version of IBM Toolbox for Java is either:");
            sbuf.append("\n  - Modification 0,");
            sbuf.append("\n  - Modification 1, or");
            sbuf.append("\n  - Modification 2 without PTF SF57202\n");
            sbuf.append("\nIn order for \"AboutToolbox\" to more precisely determine your level of the Toolbox, you need to have at least Toolbox Modification 2 with PTF SF57202 or later.");
        }
        catch (Exception e) {
            sbuf.append("\nUnexpected error occurred: " + e);
        }
        return sbuf.toString();
    }
}

