/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.AS400DetailsModel;
import com.ibm.as400.vaccess.DoubleClickAdapter;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListSelectionEventSupport;
import com.ibm.as400.vaccess.PopupMenuAdapter;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SerializationListener;
import com.ibm.as400.vaccess.VActionContext;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingCursorAdapter;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AS400DetailsPane
extends JComponent
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    boolean allowActions_ = true;
    boolean confirm_ = true;
    transient JTable table_ = null;
    AS400DetailsModel model_ = new AS400DetailsModel();
    private transient VActionContext actionContext_;
    private transient DoubleClickAdapter doubleClickAdapter_;
    private transient PopupMenuAdapter popupMenuAdapter_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient ListSelectionEventSupport listSelectionEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;

    public AS400DetailsPane() {
        this.initializeTransient();
        this.setLayout(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.table_);
        this.add("Center", scrollPane);
    }

    public AS400DetailsPane(VNode root) {
        this();
        if (root == null) {
            throw new NullPointerException("root");
        }
        try {
            this.model_.setRoot(root);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.addListSelectionListener(listener);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        super.addVetoableChangeListener(listener);
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public VActionContext getActionContext() {
        return this.actionContext_;
    }

    public boolean getAllowActions() {
        return this.allowActions_;
    }

    public TableColumnModel getColumnModel() {
        return this.table_.getColumnModel();
    }

    public boolean getConfirm() {
        return this.confirm_;
    }

    public TableModel getModel() {
        return this.model_;
    }

    public VNode getRoot() {
        return this.model_.getRoot();
    }

    public boolean getRowSelectionAllowed() {
        return this.table_.getRowSelectionAllowed();
    }

    public VObject getSelectedObject() {
        VObject selectedObject = null;
        int[] selectedRows = this.table_.getSelectedRows();
        if (selectedRows.length > 0) {
            selectedObject = this.model_.getObjectAt(selectedRows[0]);
        }
        return selectedObject;
    }

    public VObject[] getSelectedObjects() {
        int[] selectedRows = this.table_.getSelectedRows();
        VObject[] selectedObjects = new VObject[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedObjects[i] = this.model_.getObjectAt(selectedRows[i]);
        }
        return selectedObjects;
    }

    public ListSelectionModel getSelectionModel() {
        return this.table_.getSelectionModel();
    }

    private void initializeTransient() {
        this.addFocusListener(new SerializationListener(this));
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listSelectionEventSupport_ = new ListSelectionEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.table_ = new JTable(this.model_);
        this.table_.setAutoCreateColumnsFromModel(false);
        this.table_.setAutoResizeMode(0);
        this.table_.setColumnSelectionAllowed(false);
        this.table_.setRowSelectionAllowed(true);
        this.table_.setShowGrid(false);
        this.model_.addErrorListener(this.errorEventSupport_);
        this.model_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.model_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.table_.getSelectionModel().addListSelectionListener(this.listSelectionEventSupport_);
        this.actionContext_ = new VActionContext_();
        this.model_.addPropertyChangeListener(new ColumnAdapter_());
        this.model_.addWorkingListener(new WorkingCursorAdapter(this.table_));
        VPane_ pane = new VPane_();
        this.doubleClickAdapter_ = new DoubleClickAdapter(pane, this.actionContext_);
        this.popupMenuAdapter_ = new PopupMenuAdapter(pane, this.actionContext_);
        if (this.allowActions_) {
            this.table_.addMouseListener(this.popupMenuAdapter_);
            this.table_.addMouseListener(this.doubleClickAdapter_);
        }
    }

    public boolean isSelected(VObject object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        int[] selectedRows = this.table_.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            if (!this.model_.getObjectAt(selectedRows[i]).equals(object)) continue;
            return true;
        }
        return false;
    }

    public void load() {
        this.table_.clearSelection();
        this.model_.load();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listSelectionEventSupport_.removeListSelectionListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        super.removeVetoableChangeListener(listener);
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void setAllowActions(boolean allowActions) {
        if (this.allowActions_ != allowActions) {
            this.allowActions_ = allowActions;
            if (this.allowActions_) {
                this.table_.addMouseListener(this.popupMenuAdapter_);
                this.table_.addMouseListener(this.doubleClickAdapter_);
            } else {
                this.table_.removeMouseListener(this.popupMenuAdapter_);
                this.table_.removeMouseListener(this.doubleClickAdapter_);
            }
        }
    }

    public void setConfirm(boolean confirm) {
        this.confirm_ = confirm;
    }

    public void setRoot(VNode root) throws PropertyVetoException {
        if (root == null) {
            throw new NullPointerException("root");
        }
        this.table_.clearSelection();
        this.model_.setRoot(root);
    }

    public void setRowSelectionAllowed(boolean selectable) {
        this.table_.setRowSelectionAllowed(selectable);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new NullPointerException("selectionModel");
        }
        ListSelectionModel oldSelectionModel = this.table_.getSelectionModel();
        if (oldSelectionModel != null) {
            oldSelectionModel.removeListSelectionListener(this.listSelectionEventSupport_);
        }
        this.table_.setSelectionModel(selectionModel);
        if (selectionModel != null) {
            selectionModel.addListSelectionListener(this.listSelectionEventSupport_);
        }
    }

    void sizeColumns() {
        int fontSize = 0;
        if (this.table_.getFont() != null) {
            fontSize = this.table_.getFontMetrics(this.table_.getFont()).charWidth('M');
        }
        if (fontSize > 0) {
            TableColumnModel columnModel = this.table_.getColumnModel();
            int columnCount = columnModel.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                TableColumn column = columnModel.getColumn(i);
                if (!(column instanceof VTableColumn)) continue;
                VTableColumn vcolumn = (VTableColumn)column;
                column.setPreferredWidth(vcolumn.getPreferredCharWidth() * fontSize + 10);
            }
        }
    }

    public void sort(Object[] propertyIdentifiers, boolean[] orders) {
        if (propertyIdentifiers == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (orders == null) {
            throw new NullPointerException("orders");
        }
        this.model_.sort(propertyIdentifiers, orders);
    }

    private class VPane_
    implements VPane,
    Serializable {
        private VPane_() {
        }

        @Override
        public VNode getRoot() {
            return AS400DetailsPane.this.getRoot();
        }

        @Override
        public VObject getObjectAt(Point point) {
            VObject object = null;
            int row = AS400DetailsPane.this.table_.rowAtPoint(point);
            if (row != -1) {
                object = AS400DetailsPane.this.model_.getObjectAt(row);
            }
            return object;
        }

        @Override
        public void setRoot(VNode root) throws PropertyVetoException {
            AS400DetailsPane.this.setRoot(root);
        }
    }

    private class VActionContext_
    implements VActionContext,
    Serializable {
        private VActionContext_() {
        }

        @Override
        public boolean getConfirm() {
            return AS400DetailsPane.this.confirm_;
        }

        @Override
        public Frame getFrame() {
            return VUtilities.getFrame(AS400DetailsPane.this);
        }

        @Override
        public CellEditor startEditing(VObject object, Object propertyIdentifier) {
            if (object == null) {
                throw new NullPointerException("object");
            }
            if (propertyIdentifier == null) {
                throw new NullPointerException("propertyIdentifier");
            }
            if (!AS400DetailsPane.this.allowActions_) {
                return null;
            }
            int rowIndex = AS400DetailsPane.this.model_.getRoot().getDetailsIndex(object);
            if (rowIndex < 0) {
                return null;
            }
            TableColumn column = null;
            try {
                column = AS400DetailsPane.this.table_.getColumn(propertyIdentifier);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            int columnIndex = column.getModelIndex();
            AS400DetailsPane.this.table_.editCellAt(rowIndex, columnIndex);
            return column.getCellEditor();
        }
    }

    private class ColumnAdapter_
    implements PropertyChangeListener {
        private ColumnAdapter_() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName() == "root") {
                TableColumnModel columnModel = AS400DetailsPane.this.table_.getColumnModel();
                Vector<TableColumn> oldColumns = new Vector<TableColumn>();
                Enumeration<TableColumn> e = columnModel.getColumns();
                while (e.hasMoreElements()) {
                    oldColumns.addElement(e.nextElement());
                }
                e = oldColumns.elements();
                while (e.hasMoreElements()) {
                    TableColumn column = e.nextElement();
                    columnModel.removeColumn(column);
                }
                TableColumnModel columnModel2 = AS400DetailsPane.this.model_.getRoot().getDetailsColumnModel();
                if (columnModel2 != null) {
                    Enumeration<TableColumn> e2 = columnModel2.getColumns();
                    while (e2.hasMoreElements()) {
                        TableColumn column = e2.nextElement();
                        columnModel.addColumn(column);
                    }
                }
                AS400DetailsPane.this.sizeColumns();
            }
        }
    }
}

