/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.ConvTableWriter;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSTextFileInputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.vaccess.DocumentEventSupport;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.FileEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.UndoableEditEventSupport;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;

public class IFSTextFileDocument
implements StyledDocument,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private IFSFile file_ = null;
    private transient StyledDocument document_;
    transient boolean modified_;
    private transient DocumentEventSupport documentEventSupport_;
    private transient DocumentListener documentListener_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient FileEventSupport fileEventSupport_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient UndoableEditEventSupport undoableEditEventSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public IFSTextFileDocument() {
        this.file_ = new IFSFile();
        this.initializeTransient();
    }

    public IFSTextFileDocument(IFSFile file) {
        this.file_ = file;
        this.initializeTransient();
    }

    public IFSTextFileDocument(AS400 system, String path) {
        this.file_ = new IFSFile(system, path);
        this.initializeTransient();
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.documentEventSupport_.addDocumentListener(listener);
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addFileListener(FileListener listener) {
        this.fileEventSupport_.addFileListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    @Override
    public synchronized Style addStyle(String name, Style parent) {
        return this.document_.addStyle(name, parent);
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditEventSupport_.addUndoableEditListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    @Override
    public synchronized Position createPosition(int offset) throws BadLocationException {
        return this.document_.createPosition(offset);
    }

    @Override
    public synchronized Color getBackground(AttributeSet attributes) {
        try {
            return this.document_.getBackground(attributes);
        }
        catch (Error e) {
            return null;
        }
    }

    @Override
    public synchronized Element getCharacterElement(int offset) {
        return this.document_.getCharacterElement(offset);
    }

    @Override
    public synchronized Element getDefaultRootElement() {
        return this.document_.getDefaultRootElement();
    }

    @Override
    public synchronized Position getEndPosition() {
        return this.document_.getEndPosition();
    }

    @Override
    public synchronized Font getFont(AttributeSet attributes) {
        return this.document_.getFont(attributes);
    }

    @Override
    public synchronized Color getForeground(AttributeSet attributes) {
        return this.document_.getForeground(attributes);
    }

    @Override
    public synchronized int getLength() {
        return this.document_.getLength();
    }

    @Override
    public synchronized Style getLogicalStyle(int offset) {
        return this.document_.getLogicalStyle(offset);
    }

    @Override
    public synchronized Element getParagraphElement(int offset) {
        return this.document_.getParagraphElement(offset);
    }

    public String getPath() {
        return this.file_.getPath();
    }

    @Override
    public synchronized Object getProperty(Object key) {
        return this.document_.getProperty(key);
    }

    @Override
    public synchronized Element[] getRootElements() {
        return this.document_.getRootElements();
    }

    @Override
    public synchronized Position getStartPosition() {
        return this.document_.getStartPosition();
    }

    @Override
    public synchronized Style getStyle(String name) {
        return this.document_.getStyle(name);
    }

    public AS400 getSystem() {
        return this.file_.getSystem();
    }

    @Override
    public synchronized String getText(int offset, int length) throws BadLocationException {
        return this.document_.getText(offset, length);
    }

    @Override
    public synchronized void getText(int offset, int length, Segment text) throws BadLocationException {
        this.document_.getText(offset, length, text);
    }

    @Override
    public synchronized void insertString(int offset, String text, AttributeSet attributes) throws BadLocationException {
        this.document_.insertString(offset, text, attributes);
    }

    private void initializeTransient() {
        this.document_ = new DefaultStyledDocument();
        this.modified_ = false;
        this.documentEventSupport_ = new DocumentEventSupport(this);
        this.documentListener_ = new DocumentListener_();
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.fileEventSupport_ = new FileEventSupport(this);
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.undoableEditEventSupport_ = new UndoableEditEventSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.document_.addDocumentListener(this.documentEventSupport_);
        this.document_.addDocumentListener(this.documentListener_);
        this.document_.addUndoableEditListener(this.undoableEditEventSupport_);
        this.file_.addFileListener(this.fileEventSupport_);
    }

    public boolean isModified() {
        return this.modified_;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        try {
            this.document_.remove(0, this.document_.getLength());
            IFSTextFileInputStream input = new IFSTextFileInputStream(this.file_.getSystem(), this.file_, -1);
            input.addFileListener(this.fileEventSupport_);
            ConvTableReader reader = new ConvTableReader((InputStream)input, this.file_.getCCSID());
            char[] charArray = new char[512];
            int count = 0;
            int position = 0;
            while ((count = reader.read(charArray, 0, 512)) > 0) {
                this.document_.insertString(position, new String(charArray, 0, count), null);
                position += count;
            }
            reader.close();
            input.close();
            input.removeFileListener(this.fileEventSupport_);
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        this.modified_ = false;
        this.addDocumentListener(this.documentListener_);
        this.workingEventSupport_.fireStopWorking();
    }

    @Override
    public synchronized void putProperty(Object key, Object value) {
        this.document_.putProperty(key, value);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    @Override
    public synchronized void remove(int offset, int length) throws BadLocationException {
        this.document_.remove(offset, length);
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.documentEventSupport_.removeDocumentListener(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removeFileListener(FileListener listener) {
        this.fileEventSupport_.removeFileListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    @Override
    public synchronized void removeStyle(String name) {
        this.document_.removeStyle(name);
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener listener) {
        this.undoableEditEventSupport_.removeUndoableEditListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    @Override
    public void render(Runnable runnable) {
        this.document_.render(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save() {
        this.workingEventSupport_.fireStartWorking();
        IFSFileOutputStream output = null;
        ConvTableWriter writer = null;
        try {
            output = new IFSTextFileOutputStream(this.file_.getSystem(), this.file_, -1, false);
            output.addFileListener(this.fileEventSupport_);
            writer = new ConvTableWriter((OutputStream)output, this.file_.getCCSID());
            writer.write(this.document_.getText(0, this.document_.getLength()));
        }
        catch (Exception e) {
            this.errorEventSupport_.fireError(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.errorEventSupport_.fireError(e);
                }
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception e) {
                    this.errorEventSupport_.fireError(e);
                }
                finally {
                    output.removeFileListener(this.fileEventSupport_);
                }
            }
        }
        this.modified_ = false;
        this.addDocumentListener(this.documentListener_);
        this.workingEventSupport_.fireStopWorking();
    }

    @Override
    public synchronized void setCharacterAttributes(int offset, int length, AttributeSet attributes, boolean replace) {
        this.document_.setCharacterAttributes(offset, length, attributes, replace);
    }

    @Override
    public synchronized void setLogicalStyle(int offset, Style style) {
        this.document_.setLogicalStyle(offset, style);
    }

    @Override
    public synchronized void setParagraphAttributes(int offset, int length, AttributeSet attributes, boolean replace) {
        this.document_.setParagraphAttributes(offset, length, attributes, replace);
    }

    public void setPath(String path) throws PropertyVetoException {
        String oldValue = this.file_.getPath();
        String newValue = path;
        this.vetoableChangeSupport_.fireVetoableChange("path", oldValue, newValue);
        this.file_.removeFileListener(this.fileEventSupport_);
        AS400 system = this.file_.getSystem();
        this.file_ = new IFSFile();
        this.file_.setPath(path);
        if (system != null) {
            this.file_.setSystem(system);
        }
        this.file_.addFileListener(this.fileEventSupport_);
        this.propertyChangeSupport_.firePropertyChange("path", oldValue, newValue);
    }

    public void setSystem(AS400 system) throws PropertyVetoException {
        AS400 oldValue = this.file_.getSystem();
        AS400 newValue = system;
        this.vetoableChangeSupport_.fireVetoableChange("system", oldValue, newValue);
        this.file_.removeFileListener(this.fileEventSupport_);
        String path = this.file_.getPath();
        this.file_ = new IFSFile();
        this.file_.setSystem(system);
        if (path != null) {
            this.file_.setPath(path);
        }
        this.file_.addFileListener(this.fileEventSupport_);
        this.propertyChangeSupport_.firePropertyChange("system", oldValue, newValue);
    }

    public String toString() {
        return this.file_.getName();
    }

    private class DocumentListener_
    implements DocumentListener {
        private DocumentListener_() {
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            IFSTextFileDocument.this.modified_ = true;
            IFSTextFileDocument.this.removeDocumentListener(this);
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            IFSTextFileDocument.this.modified_ = true;
            IFSTextFileDocument.this.removeDocumentListener(this);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            IFSTextFileDocument.this.modified_ = true;
            IFSTextFileDocument.this.removeDocumentListener(this);
        }
    }
}

