/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.SQLConnection;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class SQLResultSetTableModel
extends AbstractTableModel
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private boolean cacheAll_ = false;
    private SQLConnection sqlConnection_ = null;
    private String query_ = null;
    private ResultSet explicitResultSet_ = null;
    private transient Vector cachedRows_;
    private transient int cachedRowCount_;
    private transient int columnCount_;
    private transient boolean error_;
    private transient int firstCachedRow_;
    private transient Object internalMonitor_;
    private transient int lastCachedRow_;
    private transient ResultSet resultSet_;
    private transient ResultSetMetaData resultSetMetaData_;
    private transient int rowCount_;
    private transient boolean rowCountComplete_;
    private transient boolean scrollable_;
    private transient Statement statement_;
    private transient boolean updatable_;
    private transient JTable table_;
    private static final int CACHE_SIZE_ = 500;
    private static final int READ_INCREMENT_ = 50;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient ErrorEventSupport errorEventSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public SQLResultSetTableModel() {
        this.initializeTransient();
    }

    public SQLResultSetTableModel(SQLConnection connection, String query) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        if (query == null) {
            throw new NullPointerException("query");
        }
        this.sqlConnection_ = connection;
        this.query_ = query;
        this.initializeTransient();
    }

    public SQLResultSetTableModel(ResultSet resultSet, boolean cacheAll) {
        if (resultSet == null) {
            throw new NullPointerException("resultSet");
        }
        this.explicitResultSet_ = resultSet;
        this.cacheAll_ = cacheAll;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener listener) {
        this.errorEventSupport_.addErrorListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.addWorkingListener(listener);
    }

    public void clearWarnings() {
        try {
            if (this.resultSet_ != null) {
                this.resultSet_.clearWarnings();
            }
            if (this.statement_ != null) {
                this.statement_.clearWarnings();
            }
        }
        catch (SQLException e) {
            this.markError(e);
        }
    }

    public void close() {
        try {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
                this.resultSet_ = null;
            }
        }
        catch (SQLException e) {
            this.markError(e);
        }
        try {
            if (this.statement_ != null) {
                this.statement_.close();
                this.statement_ = null;
            }
        }
        catch (SQLException e) {
            this.markError(e);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        Object object = this.internalMonitor_;
        synchronized (object) {
            Trace.log(1, "SQLResultSetTableModel.getColumnCount() = " + this.columnCount_);
            return this.columnCount_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getColumnID(int columnIndex) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (columnIndex < 0 || columnIndex >= this.columnCount_) {
                return null;
            }
            if (this.resultSet_ == null) {
                return null;
            }
            try {
                return this.resultSetMetaData_.getColumnName(columnIndex + 1);
            }
            catch (SQLException e) {
                this.markError(e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getColumnName(int columnIndex) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (columnIndex < 0 || columnIndex >= this.columnCount_) {
                return null;
            }
            if (this.resultSet_ == null) {
                return null;
            }
            try {
                String col = this.resultSetMetaData_.getColumnLabel(columnIndex + 1);
                int colLength = col.length();
                if (colLength > 20) {
                    if (colLength > 40) {
                        String space1 = col.substring(19, 20).equals(" ") ? " " : "";
                        String space2 = col.substring(39, 40).equals(" ") ? " " : "";
                        col = col.substring(0, 20).trim() + space1 + col.substring(20, 40).trim() + space2 + col.substring(40).trim();
                    } else {
                        String space1 = col.substring(19, 20).equals(" ") ? " " : "";
                        col = col.substring(0, 20).trim() + space1 + col.substring(20).trim();
                    }
                }
                return col;
            }
            catch (SQLException e) {
                this.markError(e);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnType(int columnIndex) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (columnIndex < 0 || columnIndex >= this.columnCount_) {
                return 0;
            }
            if (this.resultSet_ == null) {
                return 0;
            }
            try {
                return this.resultSetMetaData_.getColumnType(columnIndex + 1);
            }
            catch (SQLException e) {
                this.markError(e);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getColumnWidth(int columnIndex) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (columnIndex < 0 || columnIndex >= this.columnCount_) {
                return 0;
            }
            if (this.resultSet_ == null) {
                return 0;
            }
            try {
                return Math.min(this.resultSetMetaData_.getColumnDisplaySize(columnIndex + 1), 50);
            }
            catch (SQLException e) {
                this.markError(e);
                return 0;
            }
        }
    }

    public SQLConnection getConnection() {
        return this.sqlConnection_;
    }

    public String getQuery() {
        return this.query_ == null ? "" : this.query_;
    }

    public ResultSet getResultSet() {
        return this.explicitResultSet_;
    }

    @Override
    public int getRowCount() {
        if (this.resultSet_ == null) {
            return 0;
        }
        int reportedRowCount = this.rowCount_;
        if (!this.rowCountComplete_) {
            reportedRowCount += 2;
        }
        Trace.log(1, "SQLResultSetTableModel.getRowCount() = " + reportedRowCount + "(actually " + this.rowCount_ + ")");
        return reportedRowCount;
    }

    private Object getSingleValue(int columnIndex) throws SQLException {
        int type = this.resultSetMetaData_.getColumnType(columnIndex);
        if (type == -2 || type == -3 || type == -4) {
            return this.resultSet_.getBytes(columnIndex);
        }
        String s = this.resultSet_.getString(columnIndex);
        if (this.checkDataMappingWarning(this.resultSet_, columnIndex)) {
            s = "++++++++++++++";
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int newRowCount;
        int oldRowCount;
        Object[] row = null;
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (columnIndex < 0 || columnIndex >= this.columnCount_) {
                return null;
            }
            if (rowIndex < 0) {
                return null;
            }
            if (this.rowCountComplete_ && rowIndex >= this.rowCount_) {
                return null;
            }
            if (this.resultSet_ == null) {
                return null;
            }
            oldRowCount = this.rowCount_;
            if (rowIndex >= this.firstCachedRow_ && rowIndex <= this.lastCachedRow_) {
                row = (Object[])this.cachedRows_.elementAt(rowIndex - this.firstCachedRow_);
            } else if (rowIndex < this.firstCachedRow_ && !this.error_) {
                this.workingEventSupport_.fireStartWorking();
                for (int i = this.firstCachedRow_ - 1; i >= rowIndex; --i) {
                    try {
                        row = new Object[this.columnCount_];
                        ResultSet resultSet = this.resultSet_;
                        synchronized (resultSet) {
                            if (i == this.resultSet_.getRow()) {
                                this.resultSet_.next();
                            } else {
                                this.resultSet_.absolute(i + 1);
                            }
                            for (int j = 0; j < this.columnCount_; ++j) {
                                row[j] = this.getSingleValue(j + 1);
                            }
                        }
                        this.cachedRows_.insertElementAt(row, 0);
                        --this.firstCachedRow_;
                        if (++this.cachedRowCount_ <= 500) continue;
                        this.cachedRows_.removeElementAt(--this.cachedRowCount_);
                        --this.lastCachedRow_;
                        continue;
                    }
                    catch (SQLException e) {
                        this.markError(e);
                    }
                }
                this.workingEventSupport_.fireStopWorking();
            } else if (rowIndex > this.lastCachedRow_ && !this.error_) {
                int endPoint = rowIndex;
                if (!this.rowCountComplete_) {
                    endPoint = rowIndex + 50;
                }
                this.workingEventSupport_.fireStartWorking();
                boolean valid = true;
                for (int i = this.lastCachedRow_ + 1; i <= endPoint && valid; ++i) {
                    try {
                        ResultSet resultSet = this.resultSet_;
                        synchronized (resultSet) {
                            valid = i == this.resultSet_.getRow() || !this.scrollable_ ? this.resultSet_.next() : this.resultSet_.absolute(i + 1);
                            if (valid) {
                                Object[] tempRow = new Object[this.columnCount_];
                                for (int j = 0; j < this.columnCount_; ++j) {
                                    tempRow[j] = this.getSingleValue(j + 1);
                                }
                                if (i == rowIndex) {
                                    row = tempRow;
                                }
                                this.cachedRows_.insertElementAt(tempRow, this.cachedRowCount_++);
                                ++this.lastCachedRow_;
                                if (this.scrollable_ && this.cachedRowCount_ > 500) {
                                    this.cachedRows_.removeElementAt(0);
                                    --this.cachedRowCount_;
                                    ++this.firstCachedRow_;
                                }
                                if (!this.rowCountComplete_ && i >= this.rowCount_) {
                                    this.rowCount_ = i;
                                }
                            } else if (!this.rowCountComplete_) {
                                this.rowCountComplete_ = true;
                                this.rowCount_ = i;
                            }
                            continue;
                        }
                    }
                    catch (SQLException e) {
                        this.markError(e);
                    }
                }
                this.workingEventSupport_.fireStopWorking();
            }
            newRowCount = this.rowCount_;
        }
        if (oldRowCount != newRowCount) {
            int selectedRow = -1;
            if (this.table_ != null) {
                selectedRow = this.table_.getSelectedRow();
            }
            int selectedColumn = -1;
            if (this.table_ != null) {
                selectedColumn = this.table_.getSelectedColumn();
            }
            this.fireTableRowsInserted(oldRowCount, this.getRowCount());
            int afterSelectedRow = -1;
            if (this.table_ != null) {
                afterSelectedRow = this.table_.getSelectedRow();
            }
            if (selectedRow >= 0 && selectedColumn >= 0 && afterSelectedRow != selectedRow) {
                this.table_.changeSelection(selectedRow, selectedColumn, false, false);
            }
        }
        if (row == null) {
            return null;
        }
        return row[columnIndex];
    }

    public SQLWarning getWarnings() {
        SQLWarning warnings = null;
        try {
            if (this.resultSet_ != null) {
                warnings = this.resultSet_.getWarnings();
            }
            if (this.statement_ != null) {
                if (warnings == null) {
                    warnings = this.statement_.getWarnings();
                } else {
                    warnings.setNextWarning(this.statement_.getWarnings());
                }
            }
        }
        catch (SQLException e) {
            this.markError(e);
        }
        return warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeCommon() {
        Object object = this.internalMonitor_;
        synchronized (object) {
            this.cachedRows_ = new Vector(500);
            this.cachedRowCount_ = 0;
            this.columnCount_ = 0;
            this.error_ = false;
            this.firstCachedRow_ = 0;
            this.lastCachedRow_ = -1;
            this.rowCount_ = 0;
            this.rowCountComplete_ = false;
        }
    }

    private void initializeTransient() {
        this.internalMonitor_ = new Object();
        this.initializeCommon();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
    }

    boolean isUpdatable() {
        return this.updatable_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (columnIndex < 0 || columnIndex >= this.columnCount_) {
                return false;
            }
            if (rowIndex < 0) {
                return false;
            }
            if (this.rowCountComplete_ && rowIndex >= this.rowCount_) {
                return false;
            }
            return this.resultSet_ != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Trace.log(1, "SQLResultSetTableModel.load()");
        this.workingEventSupport_.fireStartWorking();
        if (this.explicitResultSet_ == null) {
            if (this.sqlConnection_ == null) {
                throw new IllegalStateException("connection");
            }
            if (this.query_ == null) {
                throw new IllegalStateException("query");
            }
        }
        Object object = this.internalMonitor_;
        synchronized (object) {
            this.initializeCommon();
            try {
                if (this.explicitResultSet_ == null) {
                    if (this.statement_ == null) {
                        Connection connection = this.sqlConnection_.getConnection();
                        this.statement_ = connection.createStatement(1005, 1008);
                    }
                    this.resultSet_ = this.statement_.executeQuery(this.query_);
                } else {
                    this.resultSet_ = this.explicitResultSet_;
                }
                this.scrollable_ = this.resultSet_.getType() != 1003;
                this.updatable_ = this.resultSet_.getConcurrency() == 1008;
                this.resultSetMetaData_ = this.resultSet_.getMetaData();
                this.columnCount_ = this.resultSetMetaData_.getColumnCount();
                if (Trace.isTraceOn()) {
                    Trace.log(1, "SQLResultSetTableModel-scrollable? " + this.scrollable_);
                    Trace.log(1, "SQLResultSetTableModel-updatable? " + this.updatable_);
                }
            }
            catch (SQLException e) {
                this.markError(e);
                this.rowCountComplete_ = true;
            }
            if (this.cacheAll_) {
                try {
                    while (this.resultSet_.next()) {
                        Object[] tempRow = new Object[this.columnCount_];
                        for (int j = 0; j < this.columnCount_; ++j) {
                            tempRow[j] = this.getSingleValue(j + 1);
                        }
                        this.cachedRows_.addElement(tempRow);
                    }
                }
                catch (SQLException e) {
                    this.markError(e);
                }
                this.rowCount_ = this.lastCachedRow_ = this.cachedRows_.size();
                this.rowCountComplete_ = true;
            } else {
                this.getValueAt(0, 0);
            }
        }
        this.fireTableStructureChanged();
        this.workingEventSupport_.fireStopWorking();
    }

    private void markError(Exception e) {
        if (Trace.isTraceOn()) {
            Trace.log(2, "Error gathering SQLResultSetTableModel data", (Throwable)e);
        }
        if (!this.error_) {
            this.error_ = true;
            this.errorEventSupport_.fireError(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener listener) {
        this.errorEventSupport_.removeErrorListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingEventSupport_.removeWorkingListener(listener);
    }

    public void setConnection(SQLConnection connection) throws PropertyVetoException {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        SQLConnection oldValue = this.sqlConnection_;
        this.vetoableChangeSupport_.fireVetoableChange("connection", oldValue, connection);
        this.sqlConnection_ = connection;
        this.statement_ = null;
        this.propertyChangeSupport_.firePropertyChange("connection", oldValue, connection);
    }

    public void setQuery(String query) throws PropertyVetoException {
        if (query == null) {
            throw new NullPointerException("query");
        }
        String oldValue = this.query_;
        this.vetoableChangeSupport_.fireVetoableChange("query", oldValue, query);
        this.query_ = query;
        this.propertyChangeSupport_.firePropertyChange("query", oldValue, query);
    }

    public void setResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            throw new NullPointerException("resultSet");
        }
        ResultSet oldValue = this.explicitResultSet_;
        this.explicitResultSet_ = resultSet;
        this.propertyChangeSupport_.firePropertyChange("resultSet", oldValue, resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        Object object = this.internalMonitor_;
        synchronized (object) {
            if (columnIndex < 0 || columnIndex >= this.columnCount_) {
                return;
            }
            if (rowIndex < 0) {
                return;
            }
            if (this.rowCountComplete_ && rowIndex >= this.rowCount_) {
                return;
            }
            if (this.resultSet_ == null) {
                return;
            }
            if (!this.updatable_) {
                return;
            }
            if (this.scrollable_) {
                try {
                    ResultSet resultSet = this.resultSet_;
                    synchronized (resultSet) {
                        this.resultSet_.absolute(rowIndex + 1);
                        this.resultSet_.updateObject(columnIndex + 1, value);
                        this.resultSet_.updateRow();
                    }
                    ((Object[])this.cachedRows_.elementAt((int)(rowIndex - this.firstCachedRow_)))[columnIndex] = value;
                }
                catch (SQLException e) {
                    this.errorEventSupport_.fireError(e);
                }
            }
        }
    }

    private boolean checkDataMappingWarning(ResultSet rs, int columnIndex) throws SQLException {
        boolean dataMapping = false;
        SQLWarning w = rs.getWarnings();
        if (w != null) {
            do {
                if (!w.getSQLState().equals("01004") || ((DataTruncation)w).getDataSize() != -1 || ((DataTruncation)w).getTransferSize() != -1 || ((DataTruncation)w).getIndex() != columnIndex) continue;
                dataMapping = true;
            } while ((w = w.getNextWarning()) != null);
        }
        return dataMapping;
    }

    public void setTable(JTable table) {
        this.table_ = table;
    }
}

