/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.BetaApi;
import com.google.auto.value.AutoValue;
import com.google.bigtable.v2.Value;
import com.google.cloud.bigtable.data.v2.models.AutoValue_Value_IntValue;
import com.google.cloud.bigtable.data.v2.models.AutoValue_Value_RawTimestamp;
import com.google.cloud.bigtable.data.v2.models.AutoValue_Value_RawValue;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import javax.annotation.Nonnull;

@BetaApi
public abstract class Value
implements Serializable {
    private Value() {
    }

    public static Value rawValue(@Nonnull ByteString value) {
        return RawValue.create(value);
    }

    public static Value rawTimestamp(long timestamp) {
        return RawTimestamp.create(timestamp);
    }

    public static Value intValue(long value) {
        return IntValue.create(value);
    }

    com.google.bigtable.v2.Value toProto() {
        Value.Builder builder = com.google.bigtable.v2.Value.newBuilder();
        this.buildTo(builder);
        return builder.build();
    }

    abstract void buildTo(Value.Builder var1);

    public abstract ValueType getValueType();

    public static Value fromProto(com.google.bigtable.v2.Value source) {
        switch (source.getKindCase()) {
            case INT_VALUE: {
                return IntValue.create(source.getIntValue());
            }
            case RAW_VALUE: {
                return RawValue.create(source.getRawValue());
            }
            case RAW_TIMESTAMP_MICROS: {
                return RawTimestamp.create(source.getRawTimestampMicros());
            }
        }
        throw new UnsupportedOperationException();
    }

    @AutoValue
    public static abstract class RawValue
    extends Value {
        public static RawValue create(@Nonnull ByteString value) {
            return new AutoValue_Value_RawValue(value);
        }

        @Nonnull
        public abstract ByteString getValue();

        @Override
        public ValueType getValueType() {
            return ValueType.RawValue;
        }

        @Override
        void buildTo(Value.Builder builder) {
            builder.setRawValue(this.getValue());
        }
    }

    @AutoValue
    public static abstract class RawTimestamp
    extends Value {
        public static RawTimestamp create(long value) {
            return new AutoValue_Value_RawTimestamp(value);
        }

        public abstract long getValue();

        @Override
        public ValueType getValueType() {
            return ValueType.RawTimestamp;
        }

        @Override
        void buildTo(Value.Builder builder) {
            builder.setRawTimestampMicros(this.getValue());
        }
    }

    @AutoValue
    public static abstract class IntValue
    extends Value {
        public static IntValue create(long value) {
            return new AutoValue_Value_IntValue(value);
        }

        public abstract long getValue();

        @Override
        public ValueType getValueType() {
            return ValueType.Int64;
        }

        @Override
        void buildTo(Value.Builder builder) {
            builder.setIntValue(this.getValue());
        }
    }

    public static enum ValueType {
        Int64,
        RawTimestamp,
        RawValue;

    }
}

