/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.metadata.serializer.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import lombok.Generated;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.encryption.ITwoWayPasswordEncoder;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.BaseMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataSerializer;

public class MultiMetadataProvider
implements IHopMetadataProvider {
    private ITwoWayPasswordEncoder twoWayPasswordEncoder;
    private final IVariables variables;
    private List<IHopMetadataProvider> providers;

    public MultiMetadataProvider(ITwoWayPasswordEncoder twoWayPasswordEncoder, List<IHopMetadataProvider> providers, IVariables variables) {
        this.twoWayPasswordEncoder = twoWayPasswordEncoder;
        this.providers = providers;
        this.variables = variables;
    }

    public MultiMetadataProvider(IVariables variables, IHopMetadataProvider ... metadataProviders) {
        this.providers = new ArrayList<IHopMetadataProvider>();
        this.variables = variables;
        for (IHopMetadataProvider metadataProvider : metadataProviders) {
            this.providers.add(metadataProvider);
            if (metadataProvider.getTwoWayPasswordEncoder() == null) continue;
            this.twoWayPasswordEncoder = metadataProvider.getTwoWayPasswordEncoder();
        }
        if (this.twoWayPasswordEncoder == null) {
            this.twoWayPasswordEncoder = Encr.getEncoder();
        }
    }

    private String calculateDescription() {
        StringBuilder descr = new StringBuilder();
        descr.append("Multi Metadata Provider with " + this.providers.size() + " providers");
        for (int i = 0; i < this.providers.size(); ++i) {
            IHopMetadataProvider provider = this.providers.get(i);
            if (i == 0) {
                descr.append(": ");
            } else {
                descr.append(", ");
            }
            descr.append(provider.getDescription());
        }
        return descr.toString();
    }

    @Override
    public <T extends IHopMetadata> IHopMetadataSerializer<T> getSerializer(Class<T> managedClass) throws HopException {
        if (managedClass == null) {
            throw new HopException("You need to specify the class to serialize");
        }
        HopMetadata hopMetadata = managedClass.getAnnotation(HopMetadata.class);
        if (hopMetadata == null) {
            throw new HopException("To serialize class " + managedClass.getClass().getName() + " it needs to have annotation " + HopMetadata.class.getName());
        }
        String description = TranslateUtil.translate(hopMetadata.name(), managedClass);
        return new MultiMetadataSerializer<T>(this, managedClass, this.variables, description);
    }

    @Override
    public <T extends IHopMetadata> List<Class<T>> getMetadataClasses() {
        HashSet set = new HashSet();
        for (IHopMetadataProvider provider : this.providers) {
            set.addAll(provider.getMetadataClasses());
        }
        return new ArrayList<Class<T>>(set);
    }

    @Override
    public <T extends IHopMetadata> Class<T> getMetadataClassForKey(String key) throws HopException {
        if (this.providers.isEmpty()) {
            return new BaseMetadataProvider(this.variables, null).getMetadataClassForKey(key);
        }
        return this.providers.get(0).getMetadataClassForKey(key);
    }

    public IHopMetadataProvider findProvider(String providerDescription) {
        ListIterator<IHopMetadataProvider> listIterator = this.providers.listIterator(this.providers.size());
        while (listIterator.hasPrevious()) {
            IHopMetadataProvider provider = listIterator.previous();
            if (!provider.getDescription().equals(providerDescription)) continue;
            return provider;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return this.calculateDescription();
    }

    public void setDescription(String description) {
        throw new RuntimeException("The description of the multi metadata provider can't be changed. It's derived from the list of providers it contains.");
    }

    @Override
    @Generated
    public ITwoWayPasswordEncoder getTwoWayPasswordEncoder() {
        return this.twoWayPasswordEncoder;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public List<IHopMetadataProvider> getProviders() {
        return this.providers;
    }

    @Generated
    public void setTwoWayPasswordEncoder(ITwoWayPasswordEncoder twoWayPasswordEncoder) {
        this.twoWayPasswordEncoder = twoWayPasswordEncoder;
    }

    @Generated
    public void setProviders(List<IHopMetadataProvider> providers) {
        this.providers = providers;
    }
}

