/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl.expr;

import io.github.spannm.jackcess.expr.EvalException;
import io.github.spannm.jackcess.expr.LocaleContext;
import io.github.spannm.jackcess.expr.Value;
import io.github.spannm.jackcess.impl.expr.NumberFormatter;
import java.math.BigDecimal;
import java.time.LocalDateTime;

public abstract class BaseValue
implements Value {
    @Override
    public boolean isNull() {
        return this.getType() == Value.Type.NULL;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        throw this.invalidConversion(Value.Type.LONG);
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        throw this.invalidConversion(Value.Type.STRING);
    }

    @Override
    public LocalDateTime getAsLocalDateTime(LocaleContext ctx) {
        return (LocalDateTime)this.getAsDateTimeValue(ctx).get();
    }

    @Override
    public Value getAsDateTimeValue(LocaleContext ctx) {
        throw this.invalidConversion(Value.Type.DATE_TIME);
    }

    @Override
    public Integer getAsLongInt(LocaleContext ctx) {
        throw this.invalidConversion(Value.Type.LONG);
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        throw this.invalidConversion(Value.Type.DOUBLE);
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        throw this.invalidConversion(Value.Type.BIG_DEC);
    }

    protected EvalException invalidConversion(Value.Type newType) {
        return new EvalException(this + " cannot be converted to " + newType);
    }

    protected Integer roundToLongInt(LocaleContext ctx) {
        return this.getAsBigDecimal(ctx).setScale(0, NumberFormatter.ROUND_MODE).intValueExact();
    }

    public String toString() {
        return "Value[" + this.getType() + "] '" + this.get() + "'";
    }
}

