/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess.impl.expr;

import io.github.spannm.jackcess.expr.LocaleContext;
import io.github.spannm.jackcess.expr.Value;
import io.github.spannm.jackcess.impl.expr.BaseNumericValue;
import java.math.BigDecimal;

public class DoubleValue
extends BaseNumericValue {
    private final Double val;

    public DoubleValue(Double _val) {
        this.val = _val;
    }

    @Override
    public Value.Type getType() {
        return Value.Type.DOUBLE;
    }

    @Override
    public Object get() {
        return this.val;
    }

    @Override
    protected Number getNumber() {
        return this.val;
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return this.val != 0.0;
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        return this.val;
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return BigDecimal.valueOf(this.val);
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return ctx.getNumericConfig().format(this.val);
    }
}

