/*
 * Decompiled with CFR 0.152.
 */
package waffle.windows.auth.impl;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import waffle.windows.auth.IWindowsAccount;
import waffle.windows.auth.IWindowsIdentity;
import waffle.windows.auth.IWindowsImpersonationContext;
import waffle.windows.auth.impl.WindowsAccountImpl;
import waffle.windows.auth.impl.WindowsIdentityImpersonationContextImpl;

public class WindowsIdentityImpl
implements IWindowsIdentity {
    private WinNT.HANDLE windowsIdentity;
    private Advapi32Util.Account[] userGroups;
    private Advapi32Util.Account windowsAccount;

    public WindowsIdentityImpl(WinNT.HANDLE newWindowsIdentity) {
        this.windowsIdentity = newWindowsIdentity;
    }

    private Advapi32Util.Account getWindowsAccount() {
        if (this.windowsAccount == null) {
            this.windowsAccount = Advapi32Util.getTokenAccount((WinNT.HANDLE)this.windowsIdentity);
        }
        return this.windowsAccount;
    }

    private Advapi32Util.Account[] getUserGroups() {
        if (this.userGroups == null) {
            this.userGroups = Advapi32Util.getTokenGroups((WinNT.HANDLE)this.windowsIdentity);
        }
        return (Advapi32Util.Account[])this.userGroups.clone();
    }

    @Override
    public String getFqn() {
        return this.getWindowsAccount().fqn;
    }

    @Override
    public IWindowsAccount[] getGroups() {
        Advapi32Util.Account[] groups = this.getUserGroups();
        ArrayList<WindowsAccountImpl> result = new ArrayList<WindowsAccountImpl>(groups.length);
        for (Advapi32Util.Account userGroup : groups) {
            WindowsAccountImpl account = new WindowsAccountImpl(userGroup);
            result.add(account);
        }
        return result.toArray(new IWindowsAccount[0]);
    }

    @Override
    public byte[] getSid() {
        return this.getWindowsAccount().sid;
    }

    @Override
    public String getSidString() {
        return this.getWindowsAccount().sidString;
    }

    @Override
    public void dispose() {
        if (this.windowsIdentity != null) {
            Kernel32.INSTANCE.CloseHandle(this.windowsIdentity);
        }
    }

    @Override
    public IWindowsImpersonationContext impersonate() {
        return new WindowsIdentityImpersonationContextImpl(this.windowsIdentity);
    }

    @Override
    public boolean isGuest() {
        for (Advapi32Util.Account userGroup : this.getUserGroups()) {
            if (Advapi32Util.isWellKnownSid((byte[])userGroup.sid, (int)28)) {
                return true;
            }
            if (Advapi32Util.isWellKnownSid((byte[])userGroup.sid, (int)43)) {
                return true;
            }
            if (!Advapi32Util.isWellKnownSid((byte[])userGroup.sid, (int)39)) continue;
            return true;
        }
        return Advapi32Util.isWellKnownSid((byte[])this.getSid(), (int)13);
    }
}

