/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.direct;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.beam.runners.core.SplittableParDoViaKeyedWorkItems;
import org.apache.beam.runners.direct.DirectGroupByKey;
import org.apache.beam.runners.direct.ParDoMultiOverrideFactory;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class KeyedPValueTrackingVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>> PRODUCES_KEYED_OUTPUTS = ImmutableSet.of(SplittableParDoViaKeyedWorkItems.GBKIntoKeyedWorkItems.class, DirectGroupByKey.DirectGroupByKeyOnly.class, DirectGroupByKey.DirectGroupAlsoByWindow.class);
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PValue> keyedValues = new HashSet<PValue>();
    private @UnknownKeyFor @NonNull @Initialized boolean finalized;

    public static @UnknownKeyFor @NonNull @Initialized KeyedPValueTrackingVisitor create() {
        return new KeyedPValueTrackingVisitor();
    }

    private KeyedPValueTrackingVisitor() {
    }

    @Override
    public  @UnknownKeyFor @NonNull @Initialized Pipeline.PipelineVisitor.CompositeBehavior enterCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0, (String)"Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", (Object)KeyedPValueTrackingVisitor.class.getSimpleName(), (Object)node);
        return Pipeline.PipelineVisitor.CompositeBehavior.ENTER_TRANSFORM;
    }

    @Override
    public void leaveCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0, (String)"Attempted to use a %s that has already been finalized on a pipeline (visiting node %s)", (Object)KeyedPValueTrackingVisitor.class.getSimpleName(), (Object)node);
        if (node.isRootNode()) {
            this.finalized = true;
        } else if (PRODUCES_KEYED_OUTPUTS.contains(node.getTransform().getClass())) {
            Map<TupleTag<?>, PCollection<?>> outputs = node.getOutputs();
            for (PValue pValue : outputs.values()) {
                this.keyedValues.add(pValue);
            }
        }
    }

    @Override
    public void visitValue(@UnknownKeyFor @NonNull @Initialized PValue value,  @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node producer) {
        boolean inputsAreKeyed = true;
        for (PValue pValue : producer.getInputs().values()) {
            inputsAreKeyed = inputsAreKeyed && this.keyedValues.contains(pValue);
        }
        if (PRODUCES_KEYED_OUTPUTS.contains(producer.getTransform().getClass()) || KeyedPValueTrackingVisitor.isKeyPreserving(producer.getTransform()) && inputsAreKeyed) {
            this.keyedValues.add(value);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PValue> getKeyedPValues() {
        Preconditions.checkState((boolean)this.finalized, (Object)"can't call getKeyedPValues before a Pipeline has been completely traversed");
        return this.keyedValues;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isKeyPreserving(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
        if (transform instanceof ParDo.MultiOutput) {
            ParDo.MultiOutput parDo = (ParDo.MultiOutput)transform;
            return parDo.getFn() instanceof ParDoMultiOverrideFactory.ToKeyedWorkItem;
        }
        return false;
    }
}

