/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.coders.CoderProviderRegistrar;
import org.apache.beam.sdk.coders.CoderProviders;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.FloatCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.SetCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.coders.VoidCoder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadableFileCoder;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.MetadataCoder;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.fs.ResourceIdCoder;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TimestampedValue;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSetMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.SetMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoderRegistry {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CoderRegistry.class);
    private static final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized CoderProvider> REGISTERED_CODER_FACTORIES;
    private @UnknownKeyFor @NonNull @Initialized ArrayDeque<@UnknownKeyFor @NonNull @Initialized CoderProvider> coderProviders = new ArrayDeque<CoderProvider>(REGISTERED_CODER_FACTORIES);

    public static @UnknownKeyFor @NonNull @Initialized CoderRegistry createDefault() {
        return new CoderRegistry();
    }

    private CoderRegistry() {
    }

    public void registerCoderProvider(@UnknownKeyFor @NonNull @Initialized CoderProvider coderProvider) {
        this.coderProviders.addFirst(coderProvider);
    }

    public void registerCoderForClass(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> clazz, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        this.registerCoderForType(TypeDescriptor.of(clazz), coder);
    }

    public void registerCoderForType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        this.registerCoderProvider(CoderProviders.forCoder(type, coder));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        return this.getCoder(TypeDescriptor.of(clazz));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getCoder(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        return this.getCoderFromTypeDescriptor(type, (SetMultimap<Type, Coder<?>>)HashMultimap.create());
    }

    @Deprecated
    @Internal
    public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getCoder(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<OutputT> typeDescriptor, @UnknownKeyFor @NonNull @Initialized TypeDescriptor<InputT> inputTypeDescriptor, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        Preconditions.checkArgument((typeDescriptor != null ? 1 : 0) != 0);
        Preconditions.checkArgument((inputTypeDescriptor != null ? 1 : 0) != 0);
        Preconditions.checkArgument((inputCoder != null ? 1 : 0) != 0);
        return this.getCoderFromTypeDescriptor(typeDescriptor, this.getTypeToCoderBindings(inputTypeDescriptor.getType(), inputCoder));
    }

    @Deprecated
    @Internal
    public <InputT, OutputT> @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getOutputCoder(@UnknownKeyFor @NonNull @Initialized SerializableFunction<InputT, OutputT> fn, @UnknownKeyFor @NonNull @Initialized Coder<InputT> inputCoder) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        ParameterizedType fnType = (ParameterizedType)TypeDescriptor.of(fn.getClass()).getSupertype(SerializableFunction.class).getType();
        return this.getCoder((Class)fn.getClass(), (Class)SerializableFunction.class, (Map<Type, ? extends Coder<?>>)ImmutableMap.of((Object)fnType.getActualTypeArguments()[0], inputCoder), SerializableFunction.class.getTypeParameters()[1]);
    }

    @Deprecated
    @Internal
    public <T, OutputT> @UnknownKeyFor @NonNull @Initialized Coder<OutputT> getCoder(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends T> subClass, @UnknownKeyFor @NonNull @Initialized Class<T> baseClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Type, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> knownCoders, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeVariable<@UnknownKeyFor @KeyForBottom @NonNull @Initialized @NonNull @Initialized ?> param) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        Map<Type, Coder<?>> inferredCoders = this.getDefaultCoders(subClass, baseClass, knownCoders);
        Coder<?> paramCoderOrNull = inferredCoders.get(param);
        if (paramCoderOrNull != null) {
            return paramCoderOrNull;
        }
        throw new CannotProvideCoderException("Cannot infer coder for type parameter " + param);
    }

    private <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Type, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getDefaultCoders(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends T> subClass, @UnknownKeyFor @NonNull @Initialized Class<T> baseClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Type, @KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> knownCoders) {
        TypeVariable<Class<T>>[] typeParams = baseClass.getTypeParameters();
        Coder[] knownCodersArray = new Coder[typeParams.length];
        for (int i = 0; i < typeParams.length; ++i) {
            knownCodersArray[i] = knownCoders.get(typeParams[i]);
        }
        Coder<?>[] resultArray = this.getDefaultCoders(subClass, baseClass, knownCodersArray);
        HashMap result = new HashMap();
        for (int i = 0; i < typeParams.length; ++i) {
            if (resultArray[i] == null) continue;
            result.put(typeParams[i], resultArray[i]);
        }
        return result;
    }

    private <T> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] getDefaultCoders(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends T> subClass, @UnknownKeyFor @NonNull @Initialized Class<T> baseClass, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable @UnknownKeyFor @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> @UnknownKeyFor @NonNull @Initialized [] knownCoders) {
        Type type = TypeDescriptor.of(subClass).getSupertype(baseClass).getType();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException(type + " is not a ParameterizedType");
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArgs = parameterizedType.getActualTypeArguments();
        if (knownCoders == null) {
            knownCoders = new Coder[typeArgs.length];
        } else if (typeArgs.length != knownCoders.length) {
            throw new IllegalArgumentException(String.format("Class %s has %d parameters, but %d coders are requested.", baseClass.getCanonicalName(), typeArgs.length, knownCoders.length));
        }
        HashMultimap context = HashMultimap.create();
        for (int i = 0; i < knownCoders.length; ++i) {
            if (knownCoders[i] == null) continue;
            try {
                CoderRegistry.verifyCompatible(knownCoders[i], typeArgs[i]);
            }
            catch (IncompatibleCoderException exn) {
                throw new IllegalArgumentException(String.format("Provided coders for type arguments of %s contain incompatibilities: Cannot encode elements of type %s with coder %s", baseClass, typeArgs[i], knownCoders[i]), exn);
            }
            context.putAll(this.getTypeToCoderBindings(typeArgs[i], knownCoders[i]));
        }
        Coder[] result = new Coder[typeArgs.length];
        for (int i = 0; i < knownCoders.length; ++i) {
            if (knownCoders[i] != null) {
                result[i] = knownCoders[i];
                continue;
            }
            try {
                result[i] = this.getCoderFromTypeDescriptor(TypeDescriptor.of(typeArgs[i]), (SetMultimap<Type, Coder<?>>)context);
                continue;
            }
            catch (CannotProvideCoderException exc) {
                result[i] = null;
            }
        }
        return result;
    }

    @VisibleForTesting
    static <T, CoderT extends Coder<T>, CandidateT> void verifyCompatible(CoderT coder, @UnknownKeyFor @NonNull @Initialized Type candidateType) throws @UnknownKeyFor @NonNull @Initialized IncompatibleCoderException {
        Class<?> coderClass = coder.getClass();
        TypeDescriptor<?> coderDescriptor = TypeDescriptor.of(coderClass);
        TypeDescriptor codedDescriptor = CoderUtils.getCodedType(coderDescriptor);
        Class codedClass = codedDescriptor.getRawType();
        Type codedType = codedDescriptor.getType();
        TypeDescriptor<?> candidateDescriptor = TypeDescriptor.of(candidateType);
        Class<?> candidateClass = candidateDescriptor.getRawType();
        if (candidateType instanceof TypeVariable) {
            return;
        }
        if (!codedClass.isAssignableFrom(candidateClass)) {
            throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s because the coded type %s is not assignable from %s", candidateType, coder, codedClass, candidateType), coder, candidateType);
        }
        TypeDescriptor<?> candidateOkDescriptor = candidateDescriptor;
        if (codedType instanceof ParameterizedType && !CoderRegistry.isNullOrEmpty(coder.getCoderArguments())) {
            List<Coder<?>> typeArgumentCoders;
            ParameterizedType parameterizedSupertype = (ParameterizedType)candidateOkDescriptor.getSupertype(codedClass).getType();
            Type[] typeArguments = parameterizedSupertype.getActualTypeArguments();
            if (typeArguments.length < (typeArgumentCoders = coder.getCoderArguments()).size()) {
                throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s: the generic supertype %s has %s type parameters, which is less than the number of coder arguments %s has (%s).", candidateOkDescriptor, coder, parameterizedSupertype, typeArguments.length, coder, typeArgumentCoders.size()), coder, candidateOkDescriptor.getType());
            }
            for (int i = 0; i < typeArgumentCoders.size(); ++i) {
                try {
                    Coder<?> typeArgumentCoder = typeArgumentCoders.get(i);
                    CoderRegistry.verifyCompatible(typeArgumentCoder, candidateDescriptor.resolveType(typeArguments[i]).getType());
                    continue;
                }
                catch (IncompatibleCoderException exn) {
                    throw new IncompatibleCoderException(String.format("Cannot encode elements of type %s with coder %s because some component coder is incompatible", candidateType, coder), coder, candidateType, exn);
                }
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isNullOrEmpty(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> c) {
        return c == null || c.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> @UnknownKeyFor @NonNull @Initialized Coder<T> getCoderFromTypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SetMultimap<@UnknownKeyFor @NonNull @Initialized Type, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeCoderBindings) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        Coder<?> coder;
        Type type = typeDescriptor.getType();
        if (typeDescriptor.equals(TypeDescriptors.rows())) {
            throw new CannotProvideCoderException("Cannot provide a coder for a Beam Row. Please provide a schema instead using PCollection.setRowSchema.");
        }
        if (typeCoderBindings.containsKey((Object)type)) {
            Set coders = typeCoderBindings.get((Object)type);
            if (coders.size() != 1) throw new CannotProvideCoderException(String.format("Cannot provide a coder for type variable %s because the actual type is over specified by multiple incompatible coders %s.", type, coders), CannotProvideCoderException.ReasonCode.OVER_SPECIFIED);
            coder = (Coder<?>)Iterables.getOnlyElement((Iterable)coders);
        } else if (type instanceof Class) {
            coder = this.getCoderFromFactories(typeDescriptor, Collections.emptyList());
        } else if (type instanceof ParameterizedType) {
            coder = this.getCoderFromParameterizedType((ParameterizedType)type, typeCoderBindings);
        } else if (type instanceof TypeVariable) {
            coder = this.getCoderFromFactories(typeDescriptor, Collections.emptyList());
        } else {
            if (!(type instanceof WildcardType)) throw new RuntimeException("Internal error: unexpected kind of Type: " + type);
            throw new CannotProvideCoderException(String.format("Cannot provide a coder for wildcard type %s.", type), CannotProvideCoderException.ReasonCode.UNKNOWN);
        }
        LOG.debug("Coder for {}: {}", typeDescriptor, coder);
        return coder;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCoderFromParameterizedType(@UnknownKeyFor @NonNull @Initialized ParameterizedType type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SetMultimap<@UnknownKeyFor @NonNull @Initialized Type, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeCoderBindings) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        ArrayList typeArgumentCoders = new ArrayList();
        for (Type typeArgument : type.getActualTypeArguments()) {
            try {
                Coder<?> typeArgumentCoder = this.getCoderFromTypeDescriptor(TypeDescriptor.of(typeArgument), typeCoderBindings);
                typeArgumentCoders.add(typeArgumentCoder);
            }
            catch (CannotProvideCoderException exc) {
                throw new CannotProvideCoderException(String.format("Cannot provide coder for parameterized type %s: %s", type, exc.getMessage()), exc);
            }
        }
        return this.getCoderFromFactories(TypeDescriptor.of(type), typeArgumentCoders);
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCoderFromFactories(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> typeDescriptor, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> typeArgumentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        ArrayList<CannotProvideCoderException> suppressedExceptions = new ArrayList<CannotProvideCoderException>();
        for (CoderProvider coderProvider : this.coderProviders) {
            try {
                return coderProvider.coderFor(typeDescriptor, typeArgumentCoders);
            }
            catch (CannotProvideCoderException e) {
                suppressedExceptions.add(e);
            }
        }
        StringBuilder messageBuilder = new StringBuilder().append("Unable to provide a Coder for ").append(typeDescriptor).append(".\n").append("  Building a Coder using a registered CoderProvider failed.\n").append("  See suppressed exceptions for detailed failures.");
        CannotProvideCoderException exceptionOnFailure = new CannotProvideCoderException(messageBuilder.toString());
        for (CannotProvideCoderException suppressedException : suppressedExceptions) {
            exceptionOnFailure.addSuppressed(suppressedException);
        }
        throw exceptionOnFailure;
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SetMultimap<@UnknownKeyFor @NonNull @Initialized Type, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getTypeToCoderBindings(@UnknownKeyFor @NonNull @Initialized Type type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        Preconditions.checkArgument((coder != null ? 1 : 0) != 0);
        if (type instanceof TypeVariable || type instanceof Class) {
            return ImmutableSetMultimap.of((Object)type, coder);
        }
        if (type instanceof ParameterizedType) {
            return this.getTypeToCoderBindings((ParameterizedType)type, coder);
        }
        return ImmutableSetMultimap.of();
    }

    private /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SetMultimap<@UnknownKeyFor @NonNull @Initialized Type, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getTypeToCoderBindings(@UnknownKeyFor @NonNull @Initialized ParameterizedType type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        List<Type> typeArguments = Arrays.asList(type.getActualTypeArguments());
        List<Coder<?>> coderArguments = coder.getCoderArguments();
        if (coderArguments == null || typeArguments.size() != coderArguments.size()) {
            return ImmutableSetMultimap.of();
        }
        HashMultimap typeToCoder = HashMultimap.create();
        typeToCoder.put((Object)type, coder);
        for (int i = 0; i < typeArguments.size(); ++i) {
            Type typeArgument = typeArguments.get(i);
            Coder<?> coderArgument = coderArguments.get(i);
            if (coderArgument == null) continue;
            typeToCoder.putAll(this.getTypeToCoderBindings(typeArgument, coderArgument));
        }
        return ImmutableSetMultimap.builder().putAll((Multimap)typeToCoder).build();
    }

    static {
        ArrayList<CoderProvider> codersToRegister = new ArrayList<CoderProvider>();
        codersToRegister.add(new CommonTypes());
        TreeSet registrars = Sets.newTreeSet((Comparator)ReflectHelpers.ObjectsClassComparator.INSTANCE);
        registrars.addAll(Lists.newArrayList(ServiceLoader.load(CoderProviderRegistrar.class, ReflectHelpers.findClassLoader())));
        codersToRegister.addAll(new DefaultCoder.DefaultCoderProviderRegistrar().getCoderProviders());
        for (CoderProviderRegistrar registrar : registrars) {
            codersToRegister.addAll(registrar.getCoderProviders());
        }
        codersToRegister.add(SerializableCoder.getCoderProvider());
        REGISTERED_CODER_FACTORIES = ImmutableList.copyOf(codersToRegister);
    }

    @VisibleForTesting
    static class IncompatibleCoderException
    extends RuntimeException {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder;
        private @UnknownKeyFor @NonNull @Initialized Type type;

        IncompatibleCoderException(@UnknownKeyFor @NonNull @Initialized String message, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized Type type) {
            super(message);
            this.coder = coder;
            this.type = type;
        }

        IncompatibleCoderException(@UnknownKeyFor @NonNull @Initialized String message, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder, @UnknownKeyFor @NonNull @Initialized Type type, @UnknownKeyFor @NonNull @Initialized Throwable cause) {
            super(message, cause);
            this.coder = coder;
            this.type = type;
        }

        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getCoder() {
            return this.coder;
        }

        public @UnknownKeyFor @NonNull @Initialized Type getType() {
            return this.type;
        }
    }

    private static class CommonTypes
    extends CoderProvider {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized CoderProvider> commonTypesToCoderProviders;

        private CommonTypes() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put(Boolean.class, (Object)CoderProviders.fromStaticMethods(Boolean.class, BooleanCoder.class));
            builder.put(Byte.class, (Object)CoderProviders.fromStaticMethods(Byte.class, ByteCoder.class));
            builder.put(BitSet.class, (Object)CoderProviders.fromStaticMethods(BitSet.class, BitSetCoder.class));
            builder.put(Float.class, (Object)CoderProviders.fromStaticMethods(Float.class, FloatCoder.class));
            builder.put(Double.class, (Object)CoderProviders.fromStaticMethods(Double.class, DoubleCoder.class));
            builder.put(Instant.class, (Object)CoderProviders.fromStaticMethods(Instant.class, InstantCoder.class));
            builder.put(Integer.class, (Object)CoderProviders.fromStaticMethods(Integer.class, VarIntCoder.class));
            builder.put(Iterable.class, (Object)CoderProviders.fromStaticMethods(Iterable.class, IterableCoder.class));
            builder.put(KV.class, (Object)CoderProviders.fromStaticMethods(KV.class, KvCoder.class));
            builder.put(List.class, (Object)CoderProviders.fromStaticMethods(List.class, ListCoder.class));
            builder.put(Long.class, (Object)CoderProviders.fromStaticMethods(Long.class, VarLongCoder.class));
            builder.put(Map.class, (Object)CoderProviders.fromStaticMethods(Map.class, MapCoder.class));
            builder.put(MatchResult.Metadata.class, (Object)CoderProviders.fromStaticMethods(MatchResult.Metadata.class, MetadataCoder.class));
            builder.put(ResourceId.class, (Object)CoderProviders.fromStaticMethods(ResourceId.class, ResourceIdCoder.class));
            builder.put(FileIO.ReadableFile.class, (Object)CoderProviders.fromStaticMethods(FileIO.ReadableFile.class, ReadableFileCoder.class));
            builder.put(Set.class, (Object)CoderProviders.fromStaticMethods(Set.class, SetCoder.class));
            builder.put(String.class, (Object)CoderProviders.fromStaticMethods(String.class, StringUtf8Coder.class));
            builder.put(TimestampedValue.class, (Object)CoderProviders.fromStaticMethods(TimestampedValue.class, TimestampedValue.TimestampedValueCoder.class));
            builder.put(Void.class, (Object)CoderProviders.fromStaticMethods(Void.class, VoidCoder.class));
            builder.put(byte[].class, (Object)CoderProviders.fromStaticMethods(byte[].class, ByteArrayCoder.class));
            builder.put(IntervalWindow.class, (Object)CoderProviders.forCoder(TypeDescriptor.of(IntervalWindow.class), IntervalWindow.getCoder()));
            this.commonTypesToCoderProviders = builder.build();
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            CoderProvider factory = this.commonTypesToCoderProviders.get(typeDescriptor.getRawType());
            if (factory == null) {
                throw new CannotProvideCoderException(String.format("%s is not one of the common types.", typeDescriptor));
            }
            return factory.coderFor(typeDescriptor, componentCoders);
        }
    }
}

