/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util.construction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.util.construction.ExternalTranslationOptions;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformUpgrader;
import org.apache.beam.sdk.util.construction.graph.PipelineValidator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ArrayListMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ListMultimap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PipelineTranslation {
    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline toProto(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
        return PipelineTranslation.toProto(pipeline, SdkComponents.create(pipeline.getOptions()));
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline toProto(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized boolean useDeprecatedViewTransforms) {
        return PipelineTranslation.toProto(pipeline, SdkComponents.create(pipeline.getOptions()), useDeprecatedViewTransforms);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline toProto(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SdkComponents components) {
        return PipelineTranslation.toProto(pipeline, components, false);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline toProto(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized SdkComponents components, @UnknownKeyFor @NonNull @Initialized boolean useDeprecatedViewTransforms) {
        return PipelineTranslation.toProto(pipeline, components, useDeprecatedViewTransforms, true);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline toProto(final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline, final @UnknownKeyFor @NonNull @Initialized SdkComponents components, @UnknownKeyFor @NonNull @Initialized boolean useDeprecatedViewTransforms, @UnknownKeyFor @NonNull @Initialized boolean upgradeTransforms) {
        List<String> urnsToOverride;
        final ArrayList rootIds = new ArrayList();
        pipeline.traverseTopologically(new Pipeline.PipelineVisitor.Defaults(){
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized ListMultimap< @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node, @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?>> children = ArrayListMultimap.create();

            @Override
            public void leaveCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                if (node.isRootNode()) {
                    for (AppliedPTransform pipelineRoot : this.children.get((Object)node)) {
                        rootIds.add(components.getExistingPTransformId(pipelineRoot));
                    }
                } else {
                    this.children.put((Object)node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                    try {
                        components.registerPTransform(node.toAppliedPTransform(pipeline), this.children.get((Object)node));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            @Override
            public void visitPrimitiveTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                this.children.put((Object)node.getEnclosingNode(), node.toAppliedPTransform(pipeline));
                try {
                    components.registerPTransform(node.toAppliedPTransform(pipeline), Collections.emptyList());
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        RunnerApi.Pipeline res = RunnerApi.Pipeline.newBuilder().setComponents(components.toComponents()).addAllRequirements(components.requirements()).addAllRootTransformIds(rootIds).build();
        if (!useDeprecatedViewTransforms) {
            res = PipelineTranslation.elideDeprecatedViews(res);
        }
        if ((urnsToOverride = pipeline.getOptions().as(ExternalTranslationOptions.class).getTransformsToOverride()).size() > 0 && upgradeTransforms) {
            try (TransformUpgrader upgrader = TransformUpgrader.of();){
                res = upgrader.upgradeTransformsViaTransformService(res, urnsToOverride, pipeline.getOptions());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not override the transforms with URNs " + urnsToOverride, e);
            }
        }
        PipelineValidator.validate(res);
        return res;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline elideDeprecatedViews(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized RunnerApi.Pipeline pipeline) {
        HashSet viewTransforms = new HashSet();
        HashMap viewOutputsToInputs = new HashMap();
        pipeline.getComponents().getTransformsMap().forEach((transformId, transform) -> {
            if (transform.getSpec().getUrn().equals("beam:transform:create_view:v1")) {
                viewTransforms.add(transformId);
                viewOutputsToInputs.put((String)Iterables.getOnlyElement(transform.getOutputsMap().values()), (String)Iterables.getOnlyElement(transform.getInputsMap().values()));
            }
        });
        HashMap newTransforms = new HashMap();
        pipeline.getComponents().getTransformsMap().forEach((transformId, transform) -> {
            RunnerApi.PTransform.Builder transformBuilder = transform.toBuilder();
            transform.getInputsMap().forEach((key, value) -> {
                if (viewOutputsToInputs.containsKey(value)) {
                    transformBuilder.putInputs(key, (String)viewOutputsToInputs.get(value));
                }
            });
            transform.getOutputsMap().forEach((key, value) -> {
                if (viewOutputsToInputs.containsKey(value)) {
                    transformBuilder.putOutputs(key, (String)viewOutputsToInputs.get(value));
                }
            });
            transformBuilder.clearSubtransforms();
            transformBuilder.addAllSubtransforms((Iterable)transform.getSubtransformsList().stream().filter(id -> !viewTransforms.contains(id)).collect(Collectors.toList()));
            newTransforms.put(transformId, transformBuilder.build());
        });
        RunnerApi.Pipeline.Builder newPipeline = pipeline.toBuilder();
        newPipeline.getComponentsBuilder().putAllTransforms(newTransforms);
        viewTransforms.forEach(arg_0 -> ((RunnerApi.Components.Builder)newPipeline.getComponentsBuilder()).removeTransforms(arg_0));
        viewOutputsToInputs.keySet().forEach(arg_0 -> ((RunnerApi.Components.Builder)newPipeline.getComponentsBuilder()).removePcollections(arg_0));
        newPipeline.clearRootTransformIds();
        newPipeline.addAllRootTransformIds((Iterable)pipeline.getRootTransformIdsList().stream().filter(id -> !viewTransforms.contains(id)).collect(Collectors.toList()));
        return newPipeline.build();
    }
}

