/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.synthetic;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.synthetic.BundleSplitter;
import org.apache.beam.sdk.io.synthetic.SyntheticRecordsCheckpoint;
import org.apache.beam.sdk.io.synthetic.SyntheticSourceOptions;
import org.apache.beam.sdk.io.synthetic.SyntheticWatermark;
import org.apache.beam.sdk.io.synthetic.delay.ReaderDelay;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.KV;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticUnboundedSource
extends UnboundedSource<KV<byte[], byte[]>, SyntheticRecordsCheckpoint> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 0L;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SyntheticUnboundedSource.class);
    private final @UnknownKeyFor @NonNull @Initialized SyntheticSourceOptions sourceOptions;
    private final @UnknownKeyFor @NonNull @Initialized BundleSplitter bundleSplitter;
    private final @UnknownKeyFor @NonNull @Initialized long startOffset;
    private final @UnknownKeyFor @NonNull @Initialized long endOffset;

    public SyntheticUnboundedSource(@UnknownKeyFor @NonNull @Initialized SyntheticSourceOptions sourceOptions) {
        this(0L, sourceOptions.numRecords, sourceOptions);
    }

    private SyntheticUnboundedSource(@UnknownKeyFor @NonNull @Initialized long startOffset, @UnknownKeyFor @NonNull @Initialized long endOffset, @UnknownKeyFor @NonNull @Initialized SyntheticSourceOptions sourceOptions) {
        this.sourceOptions = sourceOptions;
        this.bundleSplitter = new BundleSplitter(sourceOptions);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> getOutputCoder() {
        return KvCoder.of((Coder)ByteArrayCoder.of(), (Coder)ByteArrayCoder.of());
    }

    public void validate() {
        super.validate();
        this.sourceOptions.validate();
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized SyntheticRecordsCheckpoint> getCheckpointMarkCoder() {
        return SyntheticRecordsCheckpoint.CODER;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized UnboundedSource.UnboundedReader<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []>> createReader(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @Nullable @UnknownKeyFor @Initialized SyntheticRecordsCheckpoint checkpoint) {
        if (checkpoint == null) {
            return new SyntheticUnboundedReader(this, this.startOffset);
        }
        return new SyntheticUnboundedReader(this, checkpoint.getCurrentCheckMarkPosition());
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SyntheticUnboundedSource> split(@UnknownKeyFor @NonNull @Initialized int desiredNumSplits, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        int desiredNumBundles = this.sourceOptions.forceNumInitialBundles != null ? this.sourceOptions.forceNumInitialBundles : desiredNumSplits;
        List<SyntheticUnboundedSource> splits = this.bundleSplitter.getBundleSizes(desiredNumBundles, this.startOffset, this.endOffset).stream().map(offsetRange -> new SyntheticUnboundedSource(offsetRange.getFrom(), offsetRange.getTo(), this.sourceOptions)).collect(Collectors.toList());
        LOG.info("Split into {} bundles: {}", (Object)splits.size(), splits);
        return splits;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "SyntheticUnboundedSource{startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + '}';
    }

    private class SyntheticUnboundedReader
    extends UnboundedSource.UnboundedReader<KV<byte[], byte[]>> {
        private final @UnknownKeyFor @NonNull @Initialized SyntheticUnboundedSource source;
        private @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> currentKVPair = null;
        private @UnknownKeyFor @NonNull @Initialized long currentOffset;
        private @UnknownKeyFor @NonNull @Initialized Instant processingTime;
        private @UnknownKeyFor @NonNull @Initialized Instant eventTime;
        private @UnknownKeyFor @NonNull @Initialized SyntheticWatermark syntheticWatermark;
        private @UnknownKeyFor @NonNull @Initialized ReaderDelay delay;
        private @UnknownKeyFor @NonNull @Initialized long startOffset;

        public SyntheticUnboundedReader(@UnknownKeyFor @NonNull @Initialized SyntheticUnboundedSource source, long startOffset) {
            this.delay = new ReaderDelay(SyntheticUnboundedSource.this.sourceOptions);
            this.source = source;
            this.currentOffset = 0L;
            this.startOffset = startOffset;
            this.syntheticWatermark = new SyntheticWatermark(SyntheticUnboundedSource.this.sourceOptions, source.endOffset);
        }

        public @UnknownKeyFor @NonNull @Initialized SyntheticUnboundedSource getCurrentSource() {
            return this.source;
        }

        public @UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> getCurrent() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.currentKVPair == null) {
                throw new NoSuchElementException("Current record is unavailable because either the reader is at the beginning of the input and start() or advance() wasn't called, or the last start() or advance() returned false.");
            }
            return this.currentKVPair;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getCurrentTimestamp() throws @UnknownKeyFor @NonNull @Initialized NoSuchElementException {
            if (this.eventTime == null) {
                throw new NoSuchElementException("Current timestamp is unavailable because either the reader is at the beginning of the input and start() or advance() wasn't called, or the last start() or advance() returned false.");
            }
            return this.eventTime;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean start() {
            this.currentOffset = this.startOffset;
            this.delay.delayStart(this.currentOffset);
            return this.advance();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean advance() {
            ++this.currentOffset;
            this.processingTime = new Instant();
            this.eventTime = this.processingTime.minus((ReadableDuration)SyntheticUnboundedSource.this.sourceOptions.nextProcessingTimeDelay(this.currentOffset));
            SyntheticSourceOptions.Record record = this.getCurrentSource().sourceOptions.genRecord(this.currentOffset);
            this.currentKVPair = record.kv;
            this.delay.delayRecord(record);
            return this.currentOffset < this.source.endOffset;
        }

        public @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return this.syntheticWatermark.calculateNew(this.currentOffset, this.processingTime);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark getCheckpointMark() {
            return new SyntheticRecordsCheckpoint(this.currentOffset);
        }

        public void close() {
        }
    }
}

