/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agent.tool;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolExecutionRequestUtil;
import dev.langchain4j.agent.tool.ToolExecutor;
import dev.langchain4j.agent.tool.ToolMemoryId;
import dev.langchain4j.internal.Json;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultToolExecutor
implements ToolExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultToolExecutor.class);
    private final Object object;
    private final Method method;

    public DefaultToolExecutor(Object object, Method method) {
        this.object = Objects.requireNonNull(object, "object");
        this.method = Objects.requireNonNull(method, "method");
    }

    @Override
    public String execute(ToolExecutionRequest toolExecutionRequest, Object memoryId) {
        log.debug("About to execute {} for memoryId {}", (Object)toolExecutionRequest, memoryId);
        Object[] arguments = DefaultToolExecutor.prepareArguments(this.method, ToolExecutionRequestUtil.argumentsAsMap((String)toolExecutionRequest.arguments()), memoryId);
        try {
            String result = this.execute(arguments);
            log.debug("Tool execution result: {}", (Object)result);
            return result;
        }
        catch (IllegalAccessException e) {
            try {
                this.method.setAccessible(true);
                String result = this.execute(arguments);
                log.debug("Tool execution result: {}", (Object)result);
                return result;
            }
            catch (IllegalAccessException e2) {
                throw new RuntimeException(e2);
            }
            catch (InvocationTargetException e2) {
                Throwable cause = e2.getCause();
                log.error("Error while executing tool", cause);
                return cause.getMessage();
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            log.error("Error while executing tool", cause);
            return cause.getMessage();
        }
    }

    private String execute(Object[] arguments) throws IllegalAccessException, InvocationTargetException {
        Object result = this.method.invoke(this.object, arguments);
        Class<?> returnType = this.method.getReturnType();
        if (returnType == Void.TYPE) {
            return "Success";
        }
        if (returnType == String.class) {
            return (String)result;
        }
        return Json.toJson((Object)result);
    }

    static Object[] prepareArguments(Method method, Map<String, Object> argumentsMap, Object memoryId) {
        Parameter[] parameters = method.getParameters();
        Object[] arguments = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].isAnnotationPresent(ToolMemoryId.class)) {
                arguments[i] = memoryId;
                continue;
            }
            String parameterName = parameters[i].getName();
            if (!argumentsMap.containsKey(parameterName)) continue;
            Object argument = argumentsMap.get(parameterName);
            Class<?> parameterType = parameters[i].getType();
            arguments[i] = DefaultToolExecutor.coerceArgument(argument, parameterName, parameterType);
        }
        return arguments;
    }

    static Object coerceArgument(Object argument, String parameterName, Class<?> parameterType) {
        if (parameterType == String.class) {
            return argument.toString();
        }
        if (parameterType.isEnum()) {
            try {
                Class<?> enumClass = parameterType;
                return Enum.valueOf(enumClass, Objects.requireNonNull(argument.toString()));
            }
            catch (Error | Exception e) {
                throw new IllegalArgumentException(String.format("Argument \"%s\" is not a valid enum value for %s: <%s>", parameterName, parameterType.getName(), argument), e);
            }
        }
        if (parameterType == Boolean.class || parameterType == Boolean.TYPE) {
            if (argument instanceof Boolean) {
                return argument;
            }
            throw new IllegalArgumentException(String.format("Argument \"%s\" is not convertable to %s, got %s: <%s>", parameterName, parameterType.getName(), argument.getClass().getName(), argument));
        }
        if (parameterType == Double.class || parameterType == Double.TYPE) {
            return DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterType);
        }
        if (parameterType == Float.class || parameterType == Float.TYPE) {
            double doubleValue = DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterType);
            DefaultToolExecutor.checkBounds(doubleValue, parameterName, parameterType, -1.4E-45f, 3.4028234663852886E38);
            return Float.valueOf((float)doubleValue);
        }
        if (parameterType == BigDecimal.class) {
            return BigDecimal.valueOf(DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterType));
        }
        if (parameterType == Integer.class || parameterType == Integer.TYPE) {
            return (int)DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterType, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
        if (parameterType == Long.class || parameterType == Long.TYPE) {
            return DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterType, Long.MIN_VALUE, Long.MAX_VALUE);
        }
        if (parameterType == Short.class || parameterType == Short.TYPE) {
            return (short)DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterType, -32768L, 32767L);
        }
        if (parameterType == Byte.class || parameterType == Byte.TYPE) {
            return (byte)DefaultToolExecutor.getBoundedLongValue(argument, parameterName, parameterType, -128L, 127L);
        }
        if (parameterType == BigInteger.class) {
            return BigDecimal.valueOf(DefaultToolExecutor.getNonFractionalDoubleValue(argument, parameterName, parameterType)).toBigInteger();
        }
        return argument;
    }

    private static double getDoubleValue(Object argument, String parameterName, Class<?> parameterType) {
        if (!(argument instanceof Number)) {
            throw new IllegalArgumentException(String.format("Argument \"%s\" is not convertable to %s, got %s: <%s>", parameterName, parameterType.getName(), argument.getClass().getName(), argument));
        }
        return ((Number)argument).doubleValue();
    }

    private static double getNonFractionalDoubleValue(Object argument, String parameterName, Class<?> parameterType) {
        double doubleValue = DefaultToolExecutor.getDoubleValue(argument, parameterName, parameterType);
        if (!DefaultToolExecutor.hasNoFractionalPart(doubleValue)) {
            throw new IllegalArgumentException(String.format("Argument \"%s\" has non-integer value for %s: <%s>", parameterName, parameterType.getName(), argument));
        }
        return doubleValue;
    }

    private static void checkBounds(double doubleValue, String parameterName, Class<?> parameterType, double minValue, double maxValue) {
        if (doubleValue < minValue || doubleValue > maxValue) {
            throw new IllegalArgumentException(String.format("Argument \"%s\" is out of range for %s: <%s>", parameterName, parameterType.getName(), doubleValue));
        }
    }

    private static long getBoundedLongValue(Object argument, String parameterName, Class<?> parameterType, long minValue, long maxValue) {
        double doubleValue = DefaultToolExecutor.getNonFractionalDoubleValue(argument, parameterName, parameterType);
        DefaultToolExecutor.checkBounds(doubleValue, parameterName, parameterType, minValue, maxValue);
        return (long)doubleValue;
    }

    static boolean hasNoFractionalPart(Double doubleValue) {
        return doubleValue.equals(Math.floor(doubleValue));
    }
}

