/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.exception.IllegalConfigurationException;
import dev.langchain4j.internal.Json;
import dev.langchain4j.model.output.BigDecimalOutputParser;
import dev.langchain4j.model.output.BigIntegerOutputParser;
import dev.langchain4j.model.output.BooleanOutputParser;
import dev.langchain4j.model.output.ByteOutputParser;
import dev.langchain4j.model.output.DateOutputParser;
import dev.langchain4j.model.output.DoubleOutputParser;
import dev.langchain4j.model.output.EnumOutputParser;
import dev.langchain4j.model.output.FloatOutputParser;
import dev.langchain4j.model.output.IntOutputParser;
import dev.langchain4j.model.output.LocalDateOutputParser;
import dev.langchain4j.model.output.LocalDateTimeOutputParser;
import dev.langchain4j.model.output.LocalTimeOutputParser;
import dev.langchain4j.model.output.LongOutputParser;
import dev.langchain4j.model.output.OutputParser;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.ShortOutputParser;
import dev.langchain4j.model.output.structured.Description;
import dev.langchain4j.service.TokenStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ServiceOutputParser {
    private static final Map<Class<?>, OutputParser<?>> OUTPUT_PARSERS = new HashMap();

    public static Object parse(Response<AiMessage> response, Class<?> returnType) {
        if (returnType == Response.class) {
            return response;
        }
        AiMessage aiMessage = (AiMessage)response.content();
        if (returnType == AiMessage.class) {
            return aiMessage;
        }
        String text = aiMessage.text();
        if (returnType == String.class) {
            return text;
        }
        OutputParser<?> outputParser = OUTPUT_PARSERS.get(returnType);
        if (outputParser != null) {
            return outputParser.parse(text);
        }
        if (returnType == List.class) {
            return Arrays.asList(text.split("\n"));
        }
        if (returnType == Set.class) {
            return new HashSet<String>(Arrays.asList(text.split("\n")));
        }
        return Json.fromJson((String)text, returnType);
    }

    public static String outputFormatInstructions(Class<?> returnType) {
        if (returnType == String.class || returnType == AiMessage.class || returnType == TokenStream.class || returnType == Response.class) {
            return "";
        }
        if (returnType == Void.TYPE) {
            throw IllegalConfigurationException.illegalConfiguration("Return type of method '%s' cannot be void");
        }
        if (returnType.isEnum()) {
            String formatInstructions = new EnumOutputParser(returnType.asSubclass(Enum.class)).formatInstructions();
            return "\nYou must answer strictly in the following format: " + formatInstructions;
        }
        OutputParser<?> outputParser = OUTPUT_PARSERS.get(returnType);
        if (outputParser != null) {
            String formatInstructions = outputParser.formatInstructions();
            return "\nYou must answer strictly in the following format: " + formatInstructions;
        }
        if (returnType == List.class || returnType == Set.class) {
            return "\nYou must put every item on a separate line.";
        }
        return "\nYou must answer strictly in the following JSON format: " + ServiceOutputParser.jsonStructure(returnType, new HashSet());
    }

    private static String jsonStructure(Class<?> structured, Set<Class<?>> visited) {
        StringBuilder jsonSchema = new StringBuilder();
        jsonSchema.append("{\n");
        for (Field field : structured.getDeclaredFields()) {
            String name = field.getName();
            if (name.equals("__$hits$__") || Modifier.isStatic(field.getModifiers())) continue;
            jsonSchema.append(String.format("\"%s\": (%s),\n", name, ServiceOutputParser.descriptionFor(field, visited)));
        }
        jsonSchema.append("}");
        return jsonSchema.toString();
    }

    private static String descriptionFor(Field field, Set<Class<?>> visited) {
        Description fieldDescription = field.getAnnotation(Description.class);
        if (fieldDescription == null) {
            return "type: " + ServiceOutputParser.typeOf(field, visited);
        }
        return String.join((CharSequence)" ", fieldDescription.value()) + "; type: " + ServiceOutputParser.typeOf(field, visited);
    }

    private static String typeOf(Field field, Set<Class<?>> visited) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (parameterizedType.getRawType().equals(List.class) || parameterizedType.getRawType().equals(Set.class)) {
                return String.format("array of %s", ServiceOutputParser.simpleNameOrJsonStructure((Class)typeArguments[0], visited));
            }
        } else {
            if (field.getType().isArray()) {
                return String.format("array of %s", ServiceOutputParser.simpleNameOrJsonStructure(field.getType().getComponentType(), visited));
            }
            if (((Class)type).isEnum()) {
                return "enum, must be one of " + Arrays.toString(((Class)type).getEnumConstants());
            }
        }
        return ServiceOutputParser.simpleNameOrJsonStructure(field.getType(), visited);
    }

    private static String simpleNameOrJsonStructure(Class<?> structured, Set<Class<?>> visited) {
        String simpleTypeName = ServiceOutputParser.simpleTypeName(structured);
        if (structured.getPackage() == null || structured.getPackage().getName().startsWith("java.") || visited.contains(structured)) {
            return simpleTypeName;
        }
        visited.add(structured);
        return simpleTypeName + ": " + ServiceOutputParser.jsonStructure(structured, visited);
    }

    private static String simpleTypeName(Type type) {
        switch (type.getTypeName()) {
            case "java.lang.String": {
                return "string";
            }
            case "java.lang.Integer": 
            case "int": {
                return "integer";
            }
            case "java.lang.Boolean": 
            case "boolean": {
                return "boolean";
            }
            case "java.lang.Float": 
            case "float": {
                return "float";
            }
            case "java.lang.Double": 
            case "double": {
                return "double";
            }
            case "java.util.Date": 
            case "java.time.LocalDate": {
                return "date string (2023-12-31)";
            }
            case "java.time.LocalTime": {
                return "time string (23:59:59)";
            }
            case "java.time.LocalDateTime": {
                return "date-time string (2023-12-31T23:59:59)";
            }
        }
        return type.getTypeName();
    }

    static {
        OUTPUT_PARSERS.put(Boolean.TYPE, new BooleanOutputParser());
        OUTPUT_PARSERS.put(Boolean.class, new BooleanOutputParser());
        OUTPUT_PARSERS.put(Byte.TYPE, new ByteOutputParser());
        OUTPUT_PARSERS.put(Byte.class, new ByteOutputParser());
        OUTPUT_PARSERS.put(Short.TYPE, new ShortOutputParser());
        OUTPUT_PARSERS.put(Short.class, new ShortOutputParser());
        OUTPUT_PARSERS.put(Integer.TYPE, new IntOutputParser());
        OUTPUT_PARSERS.put(Integer.class, new IntOutputParser());
        OUTPUT_PARSERS.put(Long.TYPE, new LongOutputParser());
        OUTPUT_PARSERS.put(Long.class, new LongOutputParser());
        OUTPUT_PARSERS.put(BigInteger.class, new BigIntegerOutputParser());
        OUTPUT_PARSERS.put(Float.TYPE, new FloatOutputParser());
        OUTPUT_PARSERS.put(Float.class, new FloatOutputParser());
        OUTPUT_PARSERS.put(Double.TYPE, new DoubleOutputParser());
        OUTPUT_PARSERS.put(Double.class, new DoubleOutputParser());
        OUTPUT_PARSERS.put(BigDecimal.class, new BigDecimalOutputParser());
        OUTPUT_PARSERS.put(Date.class, new DateOutputParser());
        OUTPUT_PARSERS.put(LocalDate.class, new LocalDateOutputParser());
        OUTPUT_PARSERS.put(LocalTime.class, new LocalTimeOutputParser());
        OUTPUT_PARSERS.put(LocalDateTime.class, new LocalDateTimeOutputParser());
    }
}

