/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.internal.BoltServerAddress;

public class ResolvedBoltServerAddress
extends BoltServerAddress {
    private static final String HOST_ADDRESSES_FORMAT = "%s%s:%d";
    private static final int MAX_HOST_ADDRESSES_IN_STRING_VALUE = 5;
    private static final String HOST_ADDRESS_DELIMITER = ",";
    private static final String HOST_ADDRESSES_PREFIX = "(";
    private static final String HOST_ADDRESSES_SUFFIX = ")";
    private static final String TRIMMED_HOST_ADDRESSES_SUFFIX = ",...)";
    private final Set<InetAddress> resolvedAddresses;
    private final String stringValue;

    public ResolvedBoltServerAddress(String host, int port, InetAddress[] resolvedAddressesArr) {
        super(host, port);
        Objects.requireNonNull(resolvedAddressesArr, "resolvedAddressesArr");
        if (resolvedAddressesArr.length == 0) {
            throw new IllegalArgumentException("The resolvedAddressesArr must not be empty, check your DomainNameResolver is compliant with the interface contract");
        }
        this.resolvedAddresses = Collections.unmodifiableSet(new LinkedHashSet<InetAddress>(Arrays.asList(resolvedAddressesArr)));
        this.stringValue = this.createStringRepresentation();
    }

    @Override
    public Stream<BoltServerAddress> unicastStream() {
        return this.resolvedAddresses.stream().map(address -> new BoltServerAddress(this.host, address.getHostAddress(), this.port));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResolvedBoltServerAddress that = (ResolvedBoltServerAddress)o;
        return this.resolvedAddresses.equals(that.resolvedAddresses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resolvedAddresses);
    }

    @Override
    public String toString() {
        return this.stringValue;
    }

    private String createStringRepresentation() {
        String hostAddresses = this.resolvedAddresses.stream().limit(5L).map(InetAddress::getHostAddress).collect(Collectors.joining(HOST_ADDRESS_DELIMITER, HOST_ADDRESSES_PREFIX, this.resolvedAddresses.size() > 5 ? TRIMMED_HOST_ADDRESSES_SUFFIX : HOST_ADDRESSES_SUFFIX));
        return String.format(HOST_ADDRESSES_FORMAT, this.host, hostAddresses, this.port);
    }
}

