/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.beam.runners.spark.structuredstreaming.metrics.BeamMetricSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSortedMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Ordering;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class WithMetricsSupport
extends MetricRegistry {
    private final @UnknownKeyFor @NonNull @Initialized MetricRegistry internalMetricRegistry;

    private WithMetricsSupport(@UnknownKeyFor @NonNull @Initialized MetricRegistry internalMetricRegistry) {
        this.internalMetricRegistry = internalMetricRegistry;
    }

    public static @UnknownKeyFor @NonNull @Initialized WithMetricsSupport forRegistry(@UnknownKeyFor @NonNull @Initialized MetricRegistry metricRegistry) {
        return new WithMetricsSupport(metricRegistry);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Timer> getTimers(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getTimers(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Meter> getMeters(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getMeters(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Histogram> getHistograms(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getHistograms(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Counter> getCounters(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        return this.internalMetricRegistry.getCounters(filter);
    }

    public @UnknownKeyFor @NonNull @Initialized SortedMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Gauge> getGauges(@UnknownKeyFor @NonNull @Initialized MetricFilter filter) {
        ImmutableSortedMap.Builder builder = new ImmutableSortedMap.Builder((Comparator)Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER));
        SortedMap gauges = this.internalMetricRegistry.getGauges((n, m) -> filter.matches(n, m) || m instanceof BeamMetricSet);
        for (Map.Entry entry : gauges.entrySet()) {
            Gauge gauge = (Gauge)entry.getValue();
            if (gauge instanceof BeamMetricSet) {
                builder.putAll(((BeamMetricSet)gauge).getValue((String)entry.getKey(), filter));
                continue;
            }
            builder.put((Object)((String)entry.getKey()), (Object)gauge);
        }
        return builder.build();
    }
}

