/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ProducerSpEL {
    private static @Nullable @UnknownKeyFor @Initialized TransactionsImplementation transactionsImplementation;
    static final @UnknownKeyFor @NonNull @Initialized String ENABLE_IDEMPOTENCE_CONFIG = "enable.idempotence";
    static final @UnknownKeyFor @NonNull @Initialized String TRANSACTIONAL_ID_CONFIG = "transactional.id";

    ProducerSpEL() {
    }

    static @UnknownKeyFor @NonNull @Initialized boolean supportsTransactions() {
        return transactionsImplementation != null;
    }

    private static @UnknownKeyFor @NonNull @Initialized TransactionsImplementation getTransactionsImplementation() {
        return (TransactionsImplementation)Preconditions.checkStateNotNull((Object)transactionsImplementation, (Object)"This version of Kafka client library does not support transactions. Please used version 0.11 or later.");
    }

    static void initTransactions(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.getTransactionsImplementation().initTransactions(producer);
    }

    static void beginTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.getTransactionsImplementation().beginTransaction(producer);
    }

    static void commitTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.getTransactionsImplementation().commitTransaction(producer);
    }

    static void abortTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
        ProducerSpEL.getTransactionsImplementation().abortTransaction(producer);
    }

    static void sendOffsetsToTransaction(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TopicPartition, @UnknownKeyFor @NonNull @Initialized OffsetAndMetadata> offsets, @Nullable @UnknownKeyFor @Initialized String consumerGroupId) {
        ProducerSpEL.getTransactionsImplementation().sendOffsetsToTransaction(producer, offsets, consumerGroupId);
    }

    static {
        try {
            transactionsImplementation = new TransactionsImplementation();
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            transactionsImplementation = null;
        }
    }

    static class UnrecoverableProducerException
    extends ApiException {
        UnrecoverableProducerException(@UnknownKeyFor @NonNull @Initialized ApiException cause) {
            super((Throwable)cause);
        }
    }

    private static class TransactionsImplementation {
        private @UnknownKeyFor @NonNull @Initialized Method initTransactionsMethod = Producer.class.getMethod("initTransactions", new Class[0]);
        private @UnknownKeyFor @NonNull @Initialized Method beginTransactionMethod = Producer.class.getMethod("beginTransaction", new Class[0]);
        private @UnknownKeyFor @NonNull @Initialized Method commitTransactionMethod = Producer.class.getMethod("commitTransaction", new Class[0]);
        private @UnknownKeyFor @NonNull @Initialized Method abortTransactionMethod = Producer.class.getMethod("abortTransaction", new Class[0]);
        private @UnknownKeyFor @NonNull @Initialized Method sendOffsetsToTransactionMethod = Producer.class.getMethod("sendOffsetsToTransaction", Map.class, String.class);
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producerFencedExceptionClass = Class.forName("org.apache.kafka.common.errors.ProducerFencedException");
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> outOfOrderSequenceExceptionClass = Class.forName("org.apache.kafka.common.errors.OutOfOrderSequenceException");

        private TransactionsImplementation() throws @UnknownKeyFor @NonNull @Initialized NoSuchMethodException, @UnknownKeyFor @NonNull @Initialized ClassNotFoundException {
        }

        private void initTransactions(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
            this.invoke(this.initTransactionsMethod, producer, new Object[0]);
        }

        private void beginTransaction(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
            this.invoke(this.beginTransactionMethod, producer, new Object[0]);
        }

        private void commitTransaction(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
            this.invoke(this.commitTransactionMethod, producer, new Object[0]);
        }

        private void abortTransaction(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer) {
            this.invoke(this.abortTransactionMethod, producer, new Object[0]);
        }

        private void sendOffsetsToTransaction(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Producer<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> producer, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TopicPartition, @UnknownKeyFor @NonNull @Initialized OffsetAndMetadata> offsets, @Nullable @UnknownKeyFor @Initialized String consumerGroupId) {
            this.invoke(this.sendOffsetsToTransactionMethod, producer, offsets, consumerGroupId);
        }

        private void invoke(@UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized Object obj, Object ... args) {
            try {
                Object object = method.invoke(obj, args);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (ApiException e) {
                Class<?> eClass = ((Object)((Object)e)).getClass();
                if (this.producerFencedExceptionClass.isAssignableFrom(eClass) || this.outOfOrderSequenceExceptionClass.isAssignableFrom(eClass) || AuthorizationException.class.isAssignableFrom(eClass)) {
                    throw new UnrecoverableProducerException(e);
                }
                throw e;
            }
        }
    }
}

