/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.RowFilter;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class RowStringInterpolator
implements Serializable {
    private final @UnknownKeyFor @NonNull @Initialized String template;
    private final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> fieldsToReplace;
    public static final @UnknownKeyFor @NonNull @Initialized String WINDOW = "$WINDOW";
    public static final @UnknownKeyFor @NonNull @Initialized String PANE_INDEX = "$PANE_INDEX";
    public static final @UnknownKeyFor @NonNull @Initialized String YYYY = "$YYYY";
    public static final @UnknownKeyFor @NonNull @Initialized String MM = "$MM";
    public static final @UnknownKeyFor @NonNull @Initialized String DD = "$DD";
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> WINDOWING_METADATA = Sets.newHashSet((Object[])new String[]{"$WINDOW", "$PANE_INDEX", "$YYYY", "$MM", "$DD"});
    private static final @UnknownKeyFor @NonNull @Initialized Pattern TEMPLATE_PATTERN = Pattern.compile("\\{(.+?)}");

    public RowStringInterpolator(@UnknownKeyFor @NonNull @Initialized String template, @UnknownKeyFor @NonNull @Initialized Schema rowSchema) {
        this.template = template;
        Matcher m = TEMPLATE_PATTERN.matcher(template);
        this.fieldsToReplace = new HashSet<String>();
        while (m.find()) {
            this.fieldsToReplace.add(Preconditions.checkStateNotNull(m.group(1)));
        }
        List<String> rowFields = this.fieldsToReplace.stream().filter(f -> !WINDOWING_METADATA.contains(f)).collect(Collectors.toList());
        RowFilter.validateSchemaContainsFields(rowSchema, rowFields, "string interpolation");
    }

    public @UnknownKeyFor @NonNull @Initialized String interpolate(@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<@UnknownKeyFor @NonNull @Initialized Row> element) {
        String interpolated = this.template;
        for (String field : this.fieldsToReplace) {
            Object val;
            Instant timestamp = element.getTimestamp();
            switch (field) {
                case "$WINDOW": {
                    val = element.getWindow().toString();
                    break;
                }
                case "$PANE_INDEX": {
                    val = element.getPane().getIndex();
                    break;
                }
                case "$YYYY": {
                    val = timestamp.getChronology().year().get(timestamp.getMillis());
                    break;
                }
                case "$MM": {
                    val = timestamp.getChronology().monthOfYear().get(timestamp.getMillis());
                    break;
                }
                case "$DD": {
                    val = timestamp.getChronology().dayOfMonth().get(timestamp.getMillis());
                    break;
                }
                default: {
                    val = MoreObjects.firstNonNull((Object)this.getValue(element.getValue(), field), (Object)"");
                }
            }
            interpolated = interpolated.replace("{" + field + "}", String.valueOf(val));
        }
        return interpolated;
    }

    private @Nullable @UnknownKeyFor @Initialized Object getValue(@Nullable @UnknownKeyFor @Initialized Row row, @UnknownKeyFor @NonNull @Initialized String fieldPath) {
        if (row == null) {
            return null;
        }
        int dotIndex = fieldPath.indexOf(46);
        String field = dotIndex == -1 ? fieldPath : fieldPath.substring(0, dotIndex);
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)row.getSchema().hasField(field), (String)"Invalid row does not contain field '%s'.", (Object)field);
        if (dotIndex == -1) {
            return row.getValue(field);
        }
        return this.getValue(row.getRow(field), fieldPath.substring(dotIndex + 1));
    }
}

