/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.RowWithStorage;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.joda.time.base.AbstractInstant;

class RowUtils {
    RowUtils() {
    }

    static class CapturingRowCases
    implements RowCases {
        private final @UnknownKeyFor @NonNull @Initialized Schema topSchema;
        private final @UnknownKeyFor @NonNull @Initialized FieldOverrides fieldOverrides;

        CapturingRowCases(@UnknownKeyFor @NonNull @Initialized Schema topSchema, @UnknownKeyFor @NonNull @Initialized FieldOverrides fieldOverrides) {
            this.topSchema = topSchema;
            this.fieldOverrides = fieldOverrides;
        }

        private @Nullable @UnknownKeyFor @Initialized FieldOverride override(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition) {
            if (!rowPosition.qualifiers.isEmpty()) {
                return null;
            }
            return this.fieldOverrides.getOverride(rowPosition.descriptor);
        }

        private <T> T overrideOrReturn(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, T value) {
            FieldOverride fieldOverride = this.override(rowPosition);
            return (T)(fieldOverride != null ? fieldOverride.getOverrideValue() : value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row processRow(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Row value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            FieldOverride override = this.override(rowPosition);
            Row retValue = value;
            if (override != null) {
                retValue = (Row)override.getOverrideValue();
            } else if (this.fieldOverrides.hasOverrideBelow(rowPosition.descriptor)) {
                ArrayList values = Lists.newArrayListWithCapacity((int)schema.getFieldCount());
                for (int i = 0; i < schema.getFieldCount(); ++i) {
                    FieldAccessDescriptor nestedDescriptor = FieldAccessDescriptor.withFieldIds(rowPosition.descriptor, i).resolve(this.topSchema);
                    Object fieldValue = value != null ? value.getValue(i) : null;
                    values.add(matcher.match(this, schema.getField(i).getType(), new RowPosition(nestedDescriptor), fieldValue));
                }
                retValue = new RowWithStorage(schema, values);
            }
            return retValue;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> processArray(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Schema.FieldType collectionElementType, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> values, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            Collection<Object> retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, (Collection)override.getOverrideValue(), matcher);
            } else if (values != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, values, matcher);
            }
            return retValue;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> processIterable(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Schema.FieldType collectionElementType, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> values, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            Collection<Object> retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, (Iterable)override.getOverrideValue(), matcher);
            } else if (values != null) {
                retValue = this.captureIterable(rowPosition, collectionElementType, values, matcher);
            }
            return retValue;
        }

        private @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> captureIterable(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Schema.FieldType collectionElementType, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> values, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            if (values == null) {
                return null;
            }
            ArrayList captured = Lists.newArrayListWithCapacity((int)Iterables.size(values));
            RowPosition elementPosition = rowPosition.withArrayQualifier();
            for (Object listValue : values) {
                if (listValue == null) {
                    if (!collectionElementType.getNullable().booleanValue()) {
                        throw new IllegalArgumentException(String.format("%s is not nullable in Array field %s", collectionElementType, rowPosition.descriptor));
                    }
                    captured.add(null);
                    continue;
                }
                Object capturedElement = matcher.match(this, collectionElementType, elementPosition, listValue);
                captured.add(capturedElement);
            }
            return captured;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> processMap(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Schema.FieldType keyType, @UnknownKeyFor @NonNull @Initialized Schema.FieldType valueType, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> valueMap, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            HashMap retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                valueMap = (Map)override.getOverrideValue();
            }
            if (valueMap != null) {
                RowPosition elementPosition = rowPosition.withMapQualifier();
                retValue = Maps.newHashMapWithExpectedSize((int)valueMap.size());
                for (Map.Entry kv : valueMap.entrySet()) {
                    if (kv.getValue() == null) {
                        if (!valueType.getNullable().booleanValue()) {
                            throw new IllegalArgumentException(String.format("%s is not nullable in Map field %s", valueType, rowPosition.descriptor));
                        }
                        retValue.put(matcher.match(this, keyType, elementPosition, kv.getKey()), null);
                        continue;
                    }
                    retValue.put(matcher.match(this, keyType, elementPosition, kv.getKey()), matcher.match(this, valueType, elementPosition, kv.getValue()));
                }
            }
            return retValue;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Object processLogicalType(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Schema.LogicalType logicalType, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            Object retValue = null;
            FieldOverride override = this.override(rowPosition);
            if (override != null) {
                if (override.getOverrideValue() == null) {
                    return null;
                }
                retValue = logicalType.toInputType(logicalType.toBaseType(override.getOverrideValue()));
            } else if (value != null) {
                retValue = logicalType.toInputType(logicalType.toBaseType(value));
            }
            return retValue;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Instant processDateTime(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized AbstractInstant value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            AbstractInstant instantValue = this.overrideOrReturn(rowPosition, value);
            return instantValue != null ? instantValue.toInstant() : null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Byte processByte(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Byte value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Short processInt16(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Short value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Integer processInt32(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Integer value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Long processInt64(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Long value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized BigDecimal processDecimal(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized BigDecimal value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Float processFloat(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Float value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Double processDouble(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Double value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized String processString(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized String value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Boolean processBoolean(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Boolean value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            return this.overrideOrReturn(rowPosition, value);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] processBytes(@UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] value, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher matcher) {
            byte[] retValue = this.overrideOrReturn(rowPosition, value);
            return retValue instanceof ByteBuffer ? ((ByteBuffer)retValue).array() : retValue;
        }
    }

    static class FieldOverrides {
        private @UnknownKeyFor @NonNull @Initialized FieldAccessNode topNode;
        private @UnknownKeyFor @NonNull @Initialized Schema rootSchema;

        FieldOverrides(@UnknownKeyFor @NonNull @Initialized Schema rootSchema) {
            this.topNode = new FieldAccessNode(rootSchema);
            this.rootSchema = rootSchema;
        }

        FieldOverrides(@UnknownKeyFor @NonNull @Initialized Schema rootSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> overrides) {
            this.topNode = new FieldAccessNode(rootSchema, overrides);
            this.rootSchema = rootSchema;
        }

        @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
            return this.topNode.isEmpty();
        }

        void addOverride(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized FieldOverride fieldOverride) {
            this.topNode.addOverride(fieldAccessDescriptor, fieldOverride, this.rootSchema);
        }

        void setOverrides(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> values) {
            ArrayList overrides = Lists.newArrayListWithExpectedSize((int)values.size());
            for (Object value : values) {
                overrides.add(new FieldOverride(value));
            }
            this.topNode.setOverrides(overrides);
        }

        @Nullable @UnknownKeyFor @Initialized FieldOverride getOverride(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
            return this.topNode.getOverride(fieldAccessDescriptor);
        }

        @UnknownKeyFor @NonNull @Initialized boolean hasOverrideBelow(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
            return this.topNode.hasOverrideBelow(fieldAccessDescriptor);
        }

        private static class FieldAccessNode {
            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldOverride> fieldOverrides;
            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAccessNode> nestedAccess;

            FieldAccessNode(@UnknownKeyFor @NonNull @Initialized Schema schema) {
                this.fieldOverrides = Lists.newArrayListWithExpectedSize((int)schema.getFieldCount());
                this.nestedAccess = Lists.newArrayList();
            }

            FieldAccessNode(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Object> overrides) {
                this.fieldOverrides = Lists.newArrayListWithExpectedSize((int)schema.getFieldCount());
                for (Object value : overrides) {
                    this.fieldOverrides.add(new FieldOverride(value));
                }
                this.nestedAccess = Lists.newArrayList();
            }

            @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
                return this.fieldOverrides.isEmpty() && this.nestedAccess.isEmpty();
            }

            void addOverride(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor, @UnknownKeyFor @NonNull @Initialized FieldOverride fieldOverride, @UnknownKeyFor @NonNull @Initialized Schema currentSchema) {
                if (!fieldAccessDescriptor.getFieldsAccessed().isEmpty()) {
                    FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(fieldAccessDescriptor.getFieldsAccessed());
                    int aheadPosition = fieldDescriptor.getFieldId() - this.fieldOverrides.size() + 1;
                    if (aheadPosition > 0) {
                        this.fieldOverrides.addAll(Collections.nCopies(aheadPosition, null));
                    }
                    this.fieldOverrides.set(fieldDescriptor.getFieldId(), fieldOverride);
                } else if (!fieldAccessDescriptor.getNestedFieldsAccessed().isEmpty()) {
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(fieldAccessDescriptor.getNestedFieldsAccessed().entrySet());
                    int aheadPosition = ((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId() - this.nestedAccess.size() + 1;
                    if (aheadPosition > 0) {
                        this.nestedAccess.addAll(Collections.nCopies(aheadPosition, null));
                    }
                    Schema nestedSchema = currentSchema.getField(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId()).getType().getRowSchema();
                    FieldAccessNode node = this.nestedAccess.get(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId());
                    if (node == null) {
                        node = new FieldAccessNode(nestedSchema);
                        this.nestedAccess.set(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId(), node);
                    }
                    node.addOverride((FieldAccessDescriptor)entry.getValue(), fieldOverride, nestedSchema);
                }
            }

            void setOverrides(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldOverride> overrides) {
                this.fieldOverrides = overrides;
            }

            @Nullable @UnknownKeyFor @Initialized FieldOverride getOverride(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
                FieldAccessNode node;
                Map.Entry entry;
                FieldOverride override = null;
                if (!fieldAccessDescriptor.getFieldsAccessed().isEmpty()) {
                    FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(fieldAccessDescriptor.getFieldsAccessed());
                    if (fieldDescriptor.getFieldId() < this.fieldOverrides.size()) {
                        override = this.fieldOverrides.get(fieldDescriptor.getFieldId());
                    }
                } else if (!fieldAccessDescriptor.getNestedFieldsAccessed().isEmpty() && ((FieldAccessDescriptor.FieldDescriptor)(entry = (Map.Entry)Iterables.getOnlyElement(fieldAccessDescriptor.getNestedFieldsAccessed().entrySet())).getKey()).getFieldId() < this.nestedAccess.size() && (node = this.nestedAccess.get(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId())) != null) {
                    override = node.getOverride((FieldAccessDescriptor)entry.getValue());
                }
                return override;
            }

            @UnknownKeyFor @NonNull @Initialized boolean hasOverrideBelow(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccessDescriptor) {
                if (!fieldAccessDescriptor.getFieldsAccessed().isEmpty()) {
                    FieldAccessDescriptor.FieldDescriptor fieldDescriptor = (FieldAccessDescriptor.FieldDescriptor)Iterables.getOnlyElement(fieldAccessDescriptor.getFieldsAccessed());
                    return fieldDescriptor.getFieldId() < this.nestedAccess.size() && this.nestedAccess.get(fieldDescriptor.getFieldId()) != null;
                }
                if (!fieldAccessDescriptor.getNestedFieldsAccessed().isEmpty()) {
                    FieldAccessNode node;
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(fieldAccessDescriptor.getNestedFieldsAccessed().entrySet());
                    if (((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId() < this.nestedAccess.size() && (node = this.nestedAccess.get(((FieldAccessDescriptor.FieldDescriptor)entry.getKey()).getFieldId())) != null) {
                        return node.hasOverrideBelow((FieldAccessDescriptor)entry.getValue());
                    }
                } else {
                    return true;
                }
                return false;
            }
        }
    }

    static class FieldOverride {
        final @UnknownKeyFor @NonNull @Initialized Object overrideValue;

        FieldOverride(@UnknownKeyFor @NonNull @Initialized Object overrideValue) {
            this.overrideValue = overrideValue;
        }

        @UnknownKeyFor @NonNull @Initialized Object getOverrideValue() {
            return this.overrideValue;
        }
    }

    static class RowFieldMatcher {
        RowFieldMatcher() {
        }

        public @UnknownKeyFor @NonNull @Initialized Object match(@UnknownKeyFor @NonNull @Initialized RowCases cases, @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized RowPosition rowPosition, @UnknownKeyFor @NonNull @Initialized Object value) {
            Object processedValue = null;
            switch (fieldType.getTypeName()) {
                case ARRAY: {
                    processedValue = cases.processArray(rowPosition, fieldType.getCollectionElementType(), (Collection)value, this);
                    break;
                }
                case ITERABLE: {
                    processedValue = cases.processIterable(rowPosition, fieldType.getCollectionElementType(), (Iterable)value, this);
                    break;
                }
                case MAP: {
                    processedValue = cases.processMap(rowPosition, fieldType.getMapKeyType(), fieldType.getMapValueType(), (Map)value, this);
                    break;
                }
                case ROW: {
                    processedValue = cases.processRow(rowPosition, fieldType.getRowSchema(), (Row)value, this);
                    break;
                }
                case LOGICAL_TYPE: {
                    Schema.LogicalType<?, ?> logicalType = fieldType.getLogicalType();
                    processedValue = cases.processLogicalType(rowPosition, logicalType, value, this);
                    break;
                }
                case DATETIME: {
                    processedValue = cases.processDateTime(rowPosition, (AbstractInstant)value, this);
                    break;
                }
                case BYTE: {
                    processedValue = cases.processByte(rowPosition, (Byte)value, this);
                    break;
                }
                case BYTES: {
                    processedValue = cases.processBytes(rowPosition, (byte[])(value instanceof ByteBuffer ? (Object)((ByteBuffer)value).array() : value), this);
                    break;
                }
                case INT16: {
                    processedValue = cases.processInt16(rowPosition, (Short)value, this);
                    break;
                }
                case INT32: {
                    processedValue = cases.processInt32(rowPosition, (Integer)value, this);
                    break;
                }
                case INT64: {
                    processedValue = cases.processInt64(rowPosition, (Long)value, this);
                    break;
                }
                case DECIMAL: {
                    processedValue = cases.processDecimal(rowPosition, (BigDecimal)value, this);
                    break;
                }
                case FLOAT: {
                    processedValue = cases.processFloat(rowPosition, (Float)value, this);
                    break;
                }
                case DOUBLE: {
                    processedValue = cases.processDouble(rowPosition, (Double)value, this);
                    break;
                }
                case STRING: {
                    processedValue = cases.processString(rowPosition, (String)value, this);
                    break;
                }
                case BOOLEAN: {
                    processedValue = cases.processBoolean(rowPosition, (Boolean)value, this);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Not a primitive type for field name %s: %s", rowPosition.descriptor, fieldType));
                }
            }
            if (processedValue == null && !fieldType.getNullable().booleanValue()) {
                throw new IllegalArgumentException(String.format("%s is not nullable in  field %s", fieldType, rowPosition.descriptor));
            }
            return processedValue;
        }
    }

    static interface RowCases {
        public @UnknownKeyFor @NonNull @Initialized Row processRow(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Schema var2, @UnknownKeyFor @NonNull @Initialized Row var3, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var4);

        public @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> processArray(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Schema.FieldType var2, @UnknownKeyFor @NonNull @Initialized Collection<@UnknownKeyFor @NonNull @Initialized Object> var3, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var4);

        public @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> processIterable(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Schema.FieldType var2, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Object> var3, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var4);

        public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> processMap(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Schema.FieldType var2, @UnknownKeyFor @NonNull @Initialized Schema.FieldType var3, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object> var4, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var5);

        public @UnknownKeyFor @NonNull @Initialized Object processLogicalType(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Schema.LogicalType var2, @UnknownKeyFor @NonNull @Initialized Object var3, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var4);

        public @UnknownKeyFor @NonNull @Initialized Instant processDateTime(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized AbstractInstant var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized Byte processByte(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Byte var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized Short processInt16(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Short var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized Integer processInt32(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Integer var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized Long processInt64(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Long var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized BigDecimal processDecimal(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized BigDecimal var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized Float processFloat(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Float var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized Double processDouble(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Double var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized String processString(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized String var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized Boolean processBoolean(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized Boolean var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);

        public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] processBytes(@UnknownKeyFor @NonNull @Initialized RowPosition var1, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] var2, @UnknownKeyFor @NonNull @Initialized RowFieldMatcher var3);
    }

    static class RowPosition {
        @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor descriptor;
        @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers;

        RowPosition(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor descriptor) {
            this(descriptor, Collections.emptyList());
        }

        RowPosition(@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor descriptor, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers) {
            this.descriptor = descriptor;
            this.qualifiers = qualifiers;
        }

        @UnknownKeyFor @NonNull @Initialized RowPosition withArrayQualifier() {
            ArrayList newQualifiers = Lists.newArrayListWithCapacity((int)(this.qualifiers.size() + 1));
            newQualifiers.addAll(this.qualifiers);
            newQualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.ListQualifier.ALL));
            return new RowPosition(this.descriptor, newQualifiers);
        }

        @UnknownKeyFor @NonNull @Initialized RowPosition withMapQualifier() {
            ArrayList newQualifiers = Lists.newArrayListWithCapacity((int)(this.qualifiers.size() + 1));
            newQualifiers.addAll(this.qualifiers);
            newQualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.MapQualifier.ALL));
            return new RowPosition(this.descriptor, newQualifiers);
        }
    }
}

