/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.streaming.runtime.streamrecord.RecordAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class RecordAttributesBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RecordAttributesBuilder.class);
    private final List<RecordAttributes> lastRecordAttributesOfInputs;
    @Nullable
    private Boolean isBacklog = null;

    public RecordAttributesBuilder(List<RecordAttributes> lastRecordAttributesOfInputs) {
        this.lastRecordAttributesOfInputs = lastRecordAttributesOfInputs;
    }

    public RecordAttributesBuilder setBacklog(boolean isBacklog) {
        this.isBacklog = isBacklog;
        return this;
    }

    public RecordAttributes build() {
        if (this.isBacklog == null) {
            boolean defaultBacklog = this.getDefaultBacklog();
            LOG.debug("backlog is not set, set to {} from the last record attributes {}.", (Object)defaultBacklog, this.lastRecordAttributesOfInputs);
            this.isBacklog = defaultBacklog;
        }
        return new RecordAttributes(this.isBacklog);
    }

    private boolean getDefaultBacklog() {
        for (RecordAttributes lastAttributes : this.lastRecordAttributesOfInputs) {
            if (!lastAttributes.isBacklog()) continue;
            return true;
        }
        return false;
    }
}

