/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.retryable;

import java.io.Serializable;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class RetryPredicates {
    public static final EmptyResultPredicate EMPTY_RESULT_PREDICATE = new EmptyResultPredicate();
    public static final HasExceptionPredicate HAS_EXCEPTION_PREDICATE = new HasExceptionPredicate();

    public static ExceptionTypePredicate createExceptionTypePredicate(@Nonnull Class<? extends Throwable> exceptionClass) {
        return new ExceptionTypePredicate(exceptionClass);
    }

    private static final class ExceptionTypePredicate
    implements Predicate<Throwable>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<? extends Throwable> exceptionClass;

        public ExceptionTypePredicate(@Nonnull Class<? extends Throwable> exceptionClass) {
            this.exceptionClass = exceptionClass;
        }

        @Override
        public boolean test(@Nonnull Throwable throwable) {
            return this.exceptionClass.isAssignableFrom(throwable.getClass());
        }
    }

    private static final class HasExceptionPredicate
    implements Predicate<Throwable>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private HasExceptionPredicate() {
        }

        @Override
        public boolean test(Throwable throwable) {
            return null != throwable;
        }
    }

    private static final class EmptyResultPredicate<T>
    implements Predicate<Collection<T>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EmptyResultPredicate() {
        }

        @Override
        public boolean test(Collection<T> ts) {
            return null == ts || ts.isEmpty();
        }
    }
}

