/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import com.trilead.ssh2.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.util.Utils;

public class SessionResult {
    private String stdOut;
    private String stdErr;
    private boolean stdErrorType;

    public SessionResult(Session session) throws HopException {
        this.readStd(session);
    }

    private void setStdErr(String value) {
        this.stdErr = value;
        if (!Utils.isEmpty((CharSequence)this.getStdErr())) {
            this.setStdTypeErr(true);
        }
    }

    public String getStdErr() {
        return this.stdErr;
    }

    public String getStd() {
        return this.getStdOut() + this.getStdErr();
    }

    private void setStdOut(String value) {
        this.stdOut = value;
    }

    public String getStdOut() {
        return this.stdOut;
    }

    private void setStdTypeErr(boolean value) {
        this.stdErrorType = value;
    }

    public boolean isStdTypeErr() {
        return this.stdErrorType;
    }

    private void readStd(Session session) throws HopException {
        InputStream isOut = null;
        InputStream isErr = null;
        try {
            isOut = session.getStdout();
            isErr = session.getStderr();
            this.setStdOut(this.readInputStream(isOut));
            this.setStdErr(this.readInputStream(isErr));
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            try {
                if (isOut != null) {
                    isOut.close();
                }
                if (isErr != null) {
                    isErr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private String readInputStream(InputStream std) throws HopException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(std));
            String line = "";
            StringBuilder stringStdout = new StringBuilder();
            line = br.readLine();
            if (line != null) {
                stringStdout.append(line);
            }
            while ((line = br.readLine()) != null) {
                stringStdout.append("\n" + line);
            }
            String string = stringStdout.toString();
            return string;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

