/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WebResult {
    private static final Class<?> PKG = WebResult.class;
    public static final String XML_TAG = "webresult";
    public static final String STRING_OK = "OK";
    public static final String STRING_ERROR = "ERROR";
    public static final WebResult OK = new WebResult("OK");
    private String result;
    private String message;
    private String id;

    public WebResult(String result) {
        this(result, null, null);
    }

    public WebResult(String result, String message) {
        this(result, message, null);
    }

    public WebResult(String result, String message, String id) {
        this.result = result;
        this.message = message;
        this.id = id;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder();
        xml.append("<webresult>").append(Const.CR);
        xml.append("  ").append(XmlHandler.addTagValue((String)"result", (String)this.result));
        xml.append("  ").append(XmlHandler.addTagValue((String)"message", (String)this.message));
        xml.append("  ").append(XmlHandler.addTagValue((String)"id", (String)this.id));
        xml.append("</webresult>").append(Const.CR);
        return xml.toString();
    }

    public String toString() {
        return this.getXml();
    }

    public WebResult(Node webResultNode) {
        this.result = XmlHandler.getTagValue((Node)webResultNode, (String)"result");
        this.message = XmlHandler.getTagValue((Node)webResultNode, (String)"message");
        this.id = XmlHandler.getTagValue((Node)webResultNode, (String)"id");
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public static WebResult fromXmlString(String xml) throws HopXmlException {
        try {
            Document doc = XmlHandler.loadXmlString((String)xml);
            Node node = XmlHandler.getSubNode((Node)doc, (String)XML_TAG);
            return new WebResult(node);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WebResult.Error.UnableCreateResult", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

