/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.perspective;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopConfigException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.logging.util.LoggingCore;
import org.apache.hop.neo4j.perspective.HistoryResult;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.pipeline.HopGuiPipelineGraph;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;

@HopPerspectivePlugin(id="HopNeo4jPerspective", name="Neo4j", description="Neo4j Perspective", image="neo4j_logo.svg", documentationUrl="/hop-gui/perspective-neo4j.html")
@GuiPlugin
public class HopNeo4jPerspective
implements IHopPerspective {
    public static final Class<?> PKG = HopNeo4jPerspective.class;
    public static final String ID_PERSPECTIVE_TOOLBAR_ITEM = "9000-perspective-neo4j";
    public static final String CONST_SUBJECT_NAME = "subjectName";
    public static final String CONST_SUBJECT_TYPE = "subjectType";
    public static final String CONST_SUBJECT_ID = "subjectId";
    public static final String CONST_SPACES = "--------------------------------------------";
    private HopGui hopGui;
    private Composite parent;
    private Composite composite;
    private Combo wExecutions;
    private CTabFolder tabFolder;
    private TableView wResults;
    private Text wLogging;
    private Tree wTree;
    private Text wCypher;
    private Color errorLineBackground;
    private Combo wAmount;
    private Button wOnlyRoot;
    private Font defaultTabFont;
    private Text wUsedConnection;

    public String getId() {
        return "neo4j";
    }

    public void activate() {
        this.hopGui.setActivePerspective((IHopPerspective)this);
    }

    public void perspectiveActivated() {
        this.wExecutions.setFocus();
        this.refreshResults();
    }

    public IHopFileTypeHandler getActiveFileTypeHandler() {
        return new EmptyHopFileTypeHandler();
    }

    public void setActiveFileTypeHandler(IHopFileTypeHandler activeFileTypeHandler) {
    }

    public List<IHopFileType> getSupportedHopFileTypes() {
        return Collections.emptyList();
    }

    public boolean isActive() {
        return this.hopGui.isActivePerspective((IHopPerspective)this);
    }

    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.parent = parent;
        PropsUi props = PropsUi.getInstance();
        int size = (int)Math.round(16.0 * props.getZoomFactor());
        Image neo4jImage = SwtSvgImageUtil.getImage((Display)hopGui.getDisplay(), (ClassLoader)this.getClass().getClassLoader(), (String)"neo4j_logo.svg", (int)size, (int)size);
        Image lineageImage = SwtSvgImageUtil.getImage((Display)hopGui.getDisplay(), (ClassLoader)this.getClass().getClassLoader(), (String)"lineage.svg", (int)size, (int)size);
        this.errorLineBackground = new Color((Device)hopGui.getDisplay(), 201, 232, 251);
        this.composite = new Composite(parent, 0);
        PropsUi.setLook((Widget)this.composite);
        FormLayout layout = new FormLayout();
        layout.marginLeft = PropsUi.getMargin();
        layout.marginTop = PropsUi.getMargin();
        layout.marginLeft = PropsUi.getMargin();
        layout.marginBottom = PropsUi.getMargin();
        this.composite.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.composite.setLayoutData((Object)formData);
        int margin = (int)((double)PropsUi.getMargin() * props.getZoomFactor());
        Label wlInfo = new Label(this.composite, 16384);
        PropsUi.setLook((Widget)wlInfo);
        wlInfo.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Shell.Title", (String[])new String[0]));
        wlInfo.setFont(GuiResource.getInstance().getFontBold());
        FormData fdInfo = new FormData();
        fdInfo.left = new FormAttachment(0, 0);
        fdInfo.right = new FormAttachment(100, 0);
        fdInfo.top = new FormAttachment(0, 0);
        wlInfo.setLayoutData((Object)fdInfo);
        Label lastControl = wlInfo;
        Label wlSep1 = new Label(this.composite, 258);
        PropsUi.setLook((Widget)wlSep1);
        FormData fdlSep1 = new FormData();
        fdlSep1.left = new FormAttachment(0, 0);
        fdlSep1.right = new FormAttachment(100, 0);
        fdlSep1.top = new FormAttachment((Control)lastControl, margin);
        wlSep1.setLayoutData((Object)fdlSep1);
        lastControl = wlSep1;
        Label wlUsedConnection = new Label(this.composite, 16384);
        PropsUi.setLook((Widget)wlUsedConnection);
        wlUsedConnection.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Neo4J.Logging.Path.Label", (String[])new String[0]));
        FormData fdlLoggingConnection = new FormData();
        fdlLoggingConnection.left = new FormAttachment(0, 0);
        fdlLoggingConnection.top = new FormAttachment((Control)lastControl, margin);
        wlUsedConnection.setLayoutData((Object)fdlLoggingConnection);
        this.wUsedConnection = new Text(this.composite, 2052);
        this.wUsedConnection.setEditable(false);
        PropsUi.setLook((Widget)this.wUsedConnection);
        this.wUsedConnection.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Neo4J.Logging.Path.Label", (String[])new String[0]));
        this.wUsedConnection.setFont(GuiResource.getInstance().getFontBold());
        FormData fdLoggingConnection = new FormData();
        fdLoggingConnection.left = new FormAttachment((Control)wlUsedConnection, margin);
        fdLoggingConnection.right = new FormAttachment(50, 0);
        fdLoggingConnection.top = new FormAttachment((Control)lastControl, margin);
        this.wUsedConnection.setLayoutData((Object)fdLoggingConnection);
        lastControl = this.wUsedConnection;
        Label wlExecutions = new Label(this.composite, 16384);
        PropsUi.setLook((Widget)wlExecutions);
        wlExecutions.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.PipelineActionName.Label", (String[])new String[0]));
        FormData fdlExecutions = new FormData();
        fdlExecutions.left = new FormAttachment(0, 0);
        fdlExecutions.top = new FormAttachment((Control)lastControl, margin);
        wlExecutions.setLayoutData((Object)fdlExecutions);
        lastControl = wlExecutions;
        this.wExecutions = new Combo(this.composite, 2052);
        PropsUi.setLook((Widget)this.wExecutions);
        this.wExecutions.setFont(GuiResource.getInstance().getFontBold());
        FormData fdSearchString = new FormData();
        fdSearchString.left = new FormAttachment(0, 0);
        fdSearchString.top = new FormAttachment((Control)lastControl, margin);
        fdSearchString.right = new FormAttachment(50, 0);
        this.wExecutions.setLayoutData((Object)fdSearchString);
        this.wExecutions.addListener(14, this::search);
        this.wExecutions.addListener(13, this::search);
        Label wlAmount = new Label(this.composite, 16384);
        PropsUi.setLook((Widget)wlAmount);
        wlAmount.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.ShowLast.Label", (String[])new String[0]));
        FormData fdlAmount = new FormData();
        fdlAmount.left = new FormAttachment((Control)this.wExecutions, 2 * margin);
        fdlAmount.top = new FormAttachment((Control)lastControl, margin);
        wlAmount.setLayoutData((Object)fdlAmount);
        this.wAmount = new Combo(this.composite, 2052);
        PropsUi.setLook((Widget)this.wAmount);
        this.wAmount.setItems(new String[]{"50", "100", "250", "500", "1000"});
        this.wAmount.setText("50");
        FormData fdAmount = new FormData();
        fdAmount.left = new FormAttachment((Control)wlAmount, margin);
        fdAmount.top = new FormAttachment((Control)lastControl, margin);
        fdAmount.width = (int)(200.0 * props.getZoomFactor());
        this.wAmount.setLayoutData((Object)fdAmount);
        this.wAmount.addListener(14, this::search);
        this.wAmount.addListener(13, this::search);
        this.wOnlyRoot = new Button(this.composite, 32);
        this.wOnlyRoot.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OnlyRoot.Label", (String[])new String[0]));
        this.wOnlyRoot.setSelection(true);
        PropsUi.setLook((Widget)this.wOnlyRoot);
        FormData fdOnlyRoot = new FormData();
        fdOnlyRoot.left = new FormAttachment((Control)this.wAmount, margin);
        fdOnlyRoot.top = new FormAttachment((Control)lastControl, margin);
        this.wOnlyRoot.setLayoutData((Object)fdOnlyRoot);
        this.wOnlyRoot.addListener(13, this::search);
        lastControl = this.wExecutions;
        Button wbSearch = new Button(this.composite, 8);
        PropsUi.setLook((Widget)wbSearch);
        wbSearch.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Search.Button", (String[])new String[0]));
        FormData fdbSearch = new FormData();
        fdbSearch.left = new FormAttachment(0, 0);
        fdbSearch.top = new FormAttachment((Control)lastControl, margin);
        wbSearch.setLayoutData((Object)fdbSearch);
        wbSearch.addListener(13, this::search);
        lastControl = this.wExecutions;
        Button wbOpen = new Button(this.composite, 8);
        PropsUi.setLook((Widget)wbOpen);
        wbOpen.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Open.Button", (String[])new String[0]));
        FormData fdbOpen = new FormData();
        fdbOpen.left = new FormAttachment(50, 0);
        fdbOpen.bottom = new FormAttachment(100, -margin);
        wbOpen.setLayoutData((Object)fdbOpen);
        wbOpen.addListener(13, this::open);
        SashForm sashForm = new SashForm(this.composite, 512);
        PropsUi.setLook((Widget)sashForm);
        FormData fdSashForm = new FormData();
        fdSashForm.left = new FormAttachment(0, 0);
        fdSashForm.top = new FormAttachment((Control)wbSearch, margin);
        fdSashForm.right = new FormAttachment(100, 0);
        fdSashForm.bottom = new FormAttachment((Control)wbOpen, -margin);
        sashForm.setLayoutData((Object)fdSashForm);
        ColumnInfo[] resultsColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.ID.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Name.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Type.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Read.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Written.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Input.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Output.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Rejected.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Errors.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Date.Name", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Column.Duration.Name", (String[])new String[0]), 1, false, true)};
        this.wResults = new TableView(hopGui.getVariables(), (Composite)sashForm, 2564, resultsColumns, 0, null, props);
        PropsUi.setLook((Widget)this.wResults);
        this.wResults.setReadonly(true);
        FormData fdResults = new FormData();
        fdResults.left = new FormAttachment(0, 0);
        fdResults.right = new FormAttachment(100, 0);
        fdResults.top = new FormAttachment(0, 0);
        fdResults.bottom = new FormAttachment(100, 0);
        this.wResults.setLayoutData((Object)fdResults);
        this.wResults.table.addListener(14, this::open);
        this.wResults.table.addListener(13, this::analyze);
        this.tabFolder = new CTabFolder((Composite)sashForm, 2050);
        PropsUi.setLook((Widget)this.tabFolder, (int)4);
        FormData fdLabel = new FormData();
        fdLabel.left = new FormAttachment(0, 0);
        fdLabel.right = new FormAttachment(100, 0);
        fdLabel.top = new FormAttachment(0, 0);
        fdLabel.bottom = new FormAttachment(100, 0);
        this.tabFolder.setLayoutData((Object)fdLabel);
        CTabItem loggingTab = new CTabItem(this.tabFolder, 0);
        loggingTab.setFont(GuiResource.getInstance().getFontDefault());
        loggingTab.setImage(GuiResource.getInstance().getImageShowLog());
        loggingTab.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Logging.Tab", (String[])new String[0]));
        this.wLogging = new Text((Composite)this.tabFolder, 770);
        PropsUi.setLook((Widget)this.wLogging);
        this.wLogging.setFont(GuiResource.getInstance().getFontFixed());
        loggingTab.setControl((Control)this.wLogging);
        CTabItem lineageTab = new CTabItem(this.tabFolder, 0);
        lineageTab.setFont(GuiResource.getInstance().getFontDefault());
        lineageTab.setImage(lineageImage);
        lineageTab.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.PathError.Tab", (String[])new String[0]));
        this.wTree = new Tree((Composite)this.tabFolder, 2820);
        PropsUi.setLook((Widget)this.wTree);
        this.wTree.setHeaderVisible(true);
        lineageTab.setControl((Control)this.wTree);
        TreeColumn column = new TreeColumn(this.wTree, 16384);
        column.setText("#");
        column.setWidth((int)(50.0 * props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("id");
        column.setWidth((int)(250.0 * props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("Name");
        column.setWidth((int)(300.0 * props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("Type");
        column.setWidth((int)(100.0 * props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("errors");
        column.setWidth((int)(50.0 * props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("date");
        column.setWidth((int)(200.0 * props.getZoomFactor()));
        column = new TreeColumn(this.wTree, 16384);
        column.setText("duration");
        column.setWidth((int)(150.0 * props.getZoomFactor()));
        CTabItem cypherTab = new CTabItem(this.tabFolder, 0);
        cypherTab.setFont(GuiResource.getInstance().getFontDefault());
        cypherTab.setText(BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.Cypher.Tab", (String[])new String[0]));
        cypherTab.setImage(neo4jImage);
        this.wCypher = new Text((Composite)this.tabFolder, 2818);
        PropsUi.setLook((Widget)this.wCypher);
        this.wCypher.setFont(GuiResource.getInstance().getFontFixed());
        cypherTab.setControl((Control)this.wCypher);
        this.tabFolder.setSelection(0);
        sashForm.setWeights(new int[]{30, 70});
        this.defaultTabFont = lineageTab.getFont();
        this.wTree.addListener(14, this::openItem);
    }

    private void analyze(Event event) {
        ILogChannel log = this.hopGui.getLog();
        if (!(event.item instanceof TableItem)) {
            return;
        }
        TableItem item = (TableItem)event.item;
        String id = item.getText(1);
        String name = item.getText(2);
        String type = item.getText(3);
        int errors = Const.toInt((String)item.getText(9), (int)-1);
        try {
            NeoConnection connection = this.findLoggingConnection();
            if (connection == null) {
                return;
            }
            log.logDetailed("Logging workflow information to Neo4j connection : " + connection.getName());
            try (Driver driver = connection.getDriver(log, this.hopGui.getVariables());
                 Session session = connection.getSession(log, driver, this.hopGui.getVariables());){
                this.analyzeLogging(session, id, name, type);
                List<List<HistoryResult>> shortestPaths = this.analyzeErrorLineage(session, id, name, type, errors);
                this.analyzeCypherStatements(connection, session, id, name, type, errors, shortestPaths);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.ErrorAnalyze.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.ErrorAnalyze.Dialog.Message", (String[])new String[0]), e);
        }
    }

    private void analyzeLogging(Session session, String id, String name, String type) {
        HashMap<String, String> loggingParameters = new HashMap<String, String>();
        loggingParameters.put("name", name);
        loggingParameters.put("id", id);
        loggingParameters.put("type", type);
        StringBuilder loggingCypher = new StringBuilder();
        loggingCypher.append("MATCH(e:Execution) ");
        loggingCypher.append("WHERE e.id = $id ");
        loggingCypher.append("AND   e.name = $name ");
        loggingCypher.append("AND   e.type = $type ");
        loggingCypher.append("RETURN e.loggingText ");
        session.readTransaction(tx -> {
            Result result = tx.run(loggingCypher.toString(), loggingParameters);
            while (result.hasNext()) {
                Record record = result.next();
                Value value = record.get(0);
                String loggingText = value.asString();
                this.wLogging.setText(Const.NVL((String)loggingText, (String)"<no logging found>"));
            }
            return null;
        });
    }

    private List<List<HistoryResult>> analyzeErrorLineage(Session session, String id, String name, String type, int errors) {
        ArrayList<List<HistoryResult>> shortestPaths = new ArrayList<List<HistoryResult>>();
        for (TreeItem treeItem : this.wTree.getItems()) {
            treeItem.dispose();
        }
        if (errors > 0) {
            this.tabFolder.getItem(1).setFont(GuiResource.getInstance().getFontBold());
        } else {
            this.tabFolder.getItem(1).setFont(this.defaultTabFont);
        }
        if (errors > 0) {
            HashMap<String, String> errorPathParams = new HashMap<String, String>();
            errorPathParams.put(CONST_SUBJECT_NAME, name);
            errorPathParams.put(CONST_SUBJECT_TYPE, type);
            errorPathParams.put(CONST_SUBJECT_ID, id);
            StringBuilder errorPathCypher = new StringBuilder();
            errorPathCypher.append("MATCH(top:Execution { name : $subjectName, type : $subjectType, id : $subjectId })-[rel:EXECUTES*]-(err:Execution) ");
            errorPathCypher.append("   , p=shortestpath((top)-[:EXECUTES*]-(err)) ");
            errorPathCypher.append("WHERE top.registrationDate IS NOT NULL ");
            errorPathCypher.append("  AND err.errors > 0 ");
            errorPathCypher.append("  AND size((err)-[:EXECUTES]->())=0 ");
            errorPathCypher.append("RETURN p ");
            errorPathCypher.append("ORDER BY size(RELATIONSHIPS(p)) DESC ");
            errorPathCypher.append("LIMIT 10");
            session.readTransaction(tx -> {
                Result pathResult = tx.run(errorPathCypher.toString(), errorPathParams);
                while (pathResult.hasNext()) {
                    Record pathRecord = pathResult.next();
                    Value pathValue = pathRecord.get(0);
                    Path path = pathValue.asPath();
                    ArrayList<HistoryResult> shortestPath = new ArrayList<HistoryResult>();
                    for (Node node : path.nodes()) {
                        HistoryResult pathExecution = new HistoryResult();
                        pathExecution.setId(LoggingCore.getStringValue(node, "id"));
                        pathExecution.setName(LoggingCore.getStringValue(node, "name"));
                        pathExecution.setType(LoggingCore.getStringValue(node, "type"));
                        pathExecution.setCopy(LoggingCore.getStringValue(node, "copy"));
                        pathExecution.setRegistrationDate(LoggingCore.getStringValue(node, "registrationDate"));
                        pathExecution.setWritten(LoggingCore.getLongValue(node, "linesWritten"));
                        pathExecution.setRead(LoggingCore.getLongValue(node, "linesRead"));
                        pathExecution.setInput(LoggingCore.getLongValue(node, "linesInput"));
                        pathExecution.setOutput(LoggingCore.getLongValue(node, "linesOutput"));
                        pathExecution.setRejected(LoggingCore.getLongValue(node, "linesRejected"));
                        pathExecution.setErrors(LoggingCore.getLongValue(node, "errors"));
                        pathExecution.setLoggingText(LoggingCore.getStringValue(node, "loggingText"));
                        pathExecution.setDurationMs(LoggingCore.getLongValue(node, "durationMs"));
                        shortestPath.add(0, pathExecution);
                    }
                    shortestPaths.add(shortestPath);
                }
                String treeName = "Execution History of " + name + "(" + type + ")";
                for (int p = shortestPaths.size() - 1; p >= 0; --p) {
                    List shortestPath = (List)shortestPaths.get(p);
                    TreeItem pathItem = new TreeItem(this.wTree, 0);
                    pathItem.setText(0, Integer.toString(p + 1));
                    for (int e = 0; e < shortestPath.size(); ++e) {
                        HistoryResult exec = (HistoryResult)shortestPath.get(e);
                        TreeItem execItem = new TreeItem(pathItem, 0);
                        int x = 0;
                        execItem.setText(x++, Integer.toString(e + 1));
                        execItem.setText(x++, Const.NVL((String)exec.getId(), (String)""));
                        execItem.setText(x++, Const.NVL((String)exec.getName(), (String)""));
                        execItem.setText(x++, Const.NVL((String)exec.getType(), (String)""));
                        execItem.setText(x++, this.toString(exec.getErrors()));
                        execItem.setText(x++, Const.NVL((String)exec.getRegistrationDate(), (String)"").replace("T", " "));
                        execItem.setText(x++, LoggingCore.getFancyDurationFromMs(exec.getDurationMs()));
                        execItem.setExpanded(true);
                    }
                    if (p != shortestPaths.size() - 1) continue;
                    TreeMemory.getInstance().storeExpanded(treeName, pathItem, true);
                }
                TreeMemory.setExpandedFromMemory((Tree)this.wTree, (String)treeName);
                if (this.wTree.getItemCount() > 0) {
                    TreeItem firstItem = this.wTree.getItem(0);
                    this.wTree.setSelection(firstItem);
                }
                return null;
            });
        }
        return shortestPaths;
    }

    private void analyzeCypherStatements(NeoConnection connection, Session session, String id, String name, String type, int errors, List<List<HistoryResult>> shortestPaths) {
        HistoryResult result = new HistoryResult();
        result.setId(id);
        result.setName(name);
        result.setType(type);
        result.setShortestPaths(shortestPaths);
        IVariables vars = this.hopGui.getVariables();
        StringBuffer cypher = new StringBuffer();
        cypher.append("Below are a few Cypher statements you can run in the Neo4j browser");
        cypher.append(Const.CR);
        String neoServer = vars.resolve(connection.getServer());
        String neoBrowserPort = vars.resolve(connection.getBrowserPort());
        String browserUrl = "http://" + neoServer + ":" + Const.NVL((String)neoBrowserPort, (String)"7474");
        cypher.append("URL of the Neo4j browser: ").append(browserUrl);
        cypher.append(Const.CR);
        cypher.append(Const.CR);
        cypher.append("Execution info cypher: ").append(Const.CR);
        cypher.append(CONST_SPACES).append(Const.CR);
        cypher.append(result.getExecutionInfoCommand());
        cypher.append(Const.CR);
        if (errors > 0) {
            cypher.append("Error path lookup: ").append(Const.CR);
            cypher.append(CONST_SPACES).append(Const.CR);
            String errorCypher = result.getErrorPathCommand();
            cypher.append(errorCypher);
            cypher.append(Const.CR);
            if (!shortestPaths.isEmpty()) {
                cypher.append("Error path with metadata: ").append(Const.CR);
                cypher.append(CONST_SPACES).append(Const.CR);
                String allCypher = result.getErrorPathWithMetadataCommand(0);
                cypher.append(allCypher);
                cypher.append(Const.CR);
            }
        }
        this.wCypher.setText(cypher.toString());
    }

    private String toString(Long lng) {
        if (lng == null) {
            return "";
        }
        return lng.toString();
    }

    private void open(Event event) {
        try {
            TreeItem treeItem;
            String id;
            NeoConnection connection = this.findLoggingConnection();
            if (connection == null) {
                return;
            }
            TreeItem[] treeSelection = this.wTree.getSelection();
            if (treeSelection != null && treeSelection.length > 0 && StringUtils.isNotEmpty((String)(id = (treeItem = treeSelection[0]).getText(1)))) {
                this.openItem(treeItem);
                return;
            }
            TableItem[] resultsSelection = this.wResults.table.getSelection();
            if (resultsSelection == null || resultsSelection.length == 0) {
                return;
            }
            TableItem tableItem = resultsSelection[0];
            String id2 = tableItem.getText(1);
            String name = tableItem.getText(2);
            String type = tableItem.getText(3);
            this.openItem(connection, id2, name, type);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.ErrorOpeningPipeline.Dialog.Header", (String[])new String[0]), "Neo4jPerspectiveDialog.ErrorOpeningPipeline.Dialog.Message", e);
        }
    }

    private void search(Event event) {
        this.refreshResults();
    }

    private NeoConnection findLoggingConnection() throws HopException {
        IVariables variables = this.hopGui.getVariables();
        ILogChannel log = this.hopGui.getLog();
        if (!LoggingCore.isEnabled(variables)) {
            return null;
        }
        String connectionName = variables.getVariable("NEO4J_LOGGING_CONNECTION");
        NeoConnection connection = LoggingCore.getConnection((IHopMetadataProvider)this.hopGui.getMetadataProvider(), variables);
        if (connection == null) {
            log.logBasic("Warning! Unable to find Neo4j connection to log to : " + connectionName);
            return null;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshResults() {
        ILogChannel log = this.hopGui.getLog();
        String searchName = this.wExecutions.getText();
        int amount = Const.toInt((String)this.wAmount.getText(), (int)50);
        boolean onlyRoot = this.wOnlyRoot.getSelection();
        try {
            NeoConnection connection = this.findLoggingConnection();
            if (connection == null) {
                this.wUsedConnection.setText("");
                return;
            }
            this.wUsedConnection.setText(Const.NVL((String)connection.getName(), (String)""));
            log.logDetailed("Logging workflow information to Neo4j connection : " + connection.getName());
            HashMap<String, String> resultsParameters = new HashMap<String, String>();
            StringBuilder resultsCypher = new StringBuilder();
            resultsCypher.append("MATCH(e:Execution) ");
            resultsCypher.append("WHERE e.type in [ 'PIPELINE', 'WORKFLOW' ] ");
            if (StringUtils.isNotEmpty((String)searchName)) {
                resultsCypher.append("AND e.name = $name ");
                resultsParameters.put("name", searchName);
            }
            if (onlyRoot) {
                resultsCypher.append("AND e.root = true ");
            }
            resultsCypher.append("RETURN e.id, e.name, e.type, e.linesRead, e.linesWritten, e.linesInput, e.linesOutput, e.linesRejected, e.errors,  e.executionStart, e.durationMs ");
            resultsCypher.append("ORDER BY e.executionStart desc ");
            resultsCypher.append("LIMIT " + amount);
            this.wResults.clearAll(false);
            try (Driver driver = connection.getDriver(log, this.hopGui.getVariables());
                 Session session = connection.getSession(log, driver, this.hopGui.getVariables());){
                session.readTransaction(tx -> {
                    Result result = tx.run(resultsCypher.toString(), resultsParameters);
                    while (result.hasNext()) {
                        Record record = result.next();
                        TableItem item = new TableItem(this.wResults.table, 0);
                        int pos = 0;
                        Value vId = record.get(pos++);
                        item.setText(pos, Const.NVL((String)vId.asString(), (String)""));
                        Value vName = record.get(pos++);
                        item.setText(pos, Const.NVL((String)vName.asString(), (String)""));
                        Value vType = record.get(pos++);
                        item.setText(pos, Const.NVL((String)vType.asString(), (String)""));
                        Value vLinesRead = record.get(pos++);
                        item.setText(pos, Long.toString(vLinesRead.asLong(0L)));
                        Value vLinesWritten = record.get(pos++);
                        item.setText(pos, Long.toString(vLinesWritten.asLong(0L)));
                        Value vLinesInput = record.get(pos++);
                        item.setText(pos, Long.toString(vLinesInput.asLong(0L)));
                        Value vLinesOutput = record.get(pos++);
                        item.setText(pos, Long.toString(vLinesOutput.asLong(0L)));
                        Value vLinesRejected = record.get(pos++);
                        item.setText(pos, Long.toString(vLinesRejected.asLong(0L)));
                        Value vErrors = record.get(pos++);
                        long errors = vErrors.asLong(0L);
                        item.setText(pos, Long.toString(vErrors.asLong(0L)));
                        Value vExecutionStart = record.get(pos++);
                        item.setText(pos, Const.NVL((String)vExecutionStart.asString(), (String)"").replace("T", " "));
                        Value vDurationMs = record.get(pos++);
                        String durationHMS = LoggingCore.getFancyDurationFromMs(vDurationMs.asLong(0L));
                        item.setText(pos, durationHMS);
                        if (errors == 0L) continue;
                        item.setBackground(this.errorLineBackground);
                    }
                    this.wResults.removeEmptyRows();
                    this.wResults.setRowNums();
                    this.wResults.optWidth(true);
                    return null;
                });
                String execCypher = "match(e:Execution) where e.type in ['PIPELINE', 'WORKFLOW'] return distinct e.name order by e.name";
                session.readTransaction(tx -> {
                    ArrayList<String> list = new ArrayList<String>();
                    Result result = tx.run(execCypher);
                    while (result.hasNext()) {
                        Record record = result.next();
                        Value value = record.get(0);
                        list.add(value.asString());
                    }
                    this.wExecutions.setItems(list.toArray(new String[0]));
                    return null;
                });
            }
            finally {
                this.wExecutions.setText(Const.NVL((String)searchName, (String)""));
            }
        }
        catch (Throwable e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.ErrorSearching.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.ErrorSearching.Dialog.Message", (String[])new String[0]), e);
        }
    }

    private void openItem(Event event) {
        if (event.item == null || !(event.item instanceof TreeItem)) {
            return;
        }
        TreeItem item = (TreeItem)event.item;
        this.openItem(item);
    }

    private void openItem(TreeItem item) {
        try {
            NeoConnection connection = this.findLoggingConnection();
            if (connection == null) {
                return;
            }
            String id = item.getText(1);
            String name = item.getText(2);
            String type = item.getText(3);
            this.openItem(connection, id, name, type);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningItem.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningItem.Dialog.Message", (String[])new String[0]), e);
        }
    }

    private void openItem(NeoConnection connection, String id, String name, String type) throws HopConfigException {
        try (Driver driver = connection.getDriver(this.hopGui.getLog(), this.hopGui.getVariables());
             Session session = connection.getSession(this.hopGui.getLog(), driver, this.hopGui.getVariables());){
            if ("PIPELINE".equals(type)) {
                this.openPipelineOrWorkflow(session, name, type, id, "Pipeline", "EXECUTION_OF_PIPELINE");
            } else if ("WORKFLOW".equals(type)) {
                this.openPipelineOrWorkflow(session, name, type, id, "Workflow", "EXECUTION_OF_WORKFLOW");
            } else if ("TRANSFORM".equals(type)) {
                this.openTransform(session, name, type, id);
            } else if ("ACTION".equals(type)) {
                this.openAction(session, name, type, id);
            }
        }
    }

    private void openTransform(Session session, String name, String type, String id) {
        LogChannel.UI.logDetailed("Open transform : " + id + ", name : " + name + ", type: " + type);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(CONST_SUBJECT_NAME, name);
        params.put(CONST_SUBJECT_TYPE, type);
        params.put(CONST_SUBJECT_ID, id);
        StringBuilder cypher = new StringBuilder();
        cypher.append("MATCH(e:Execution { name : $subjectName, type : $subjectType, id : $subjectId } )");
        cypher.append("-[:EXECUTION_OF_TRANSFORM]->(t:Transform { name : $subjectName } )");
        cypher.append("-[:TRANSFORM_OF_PIPELINE]->(p:Pipeline) ");
        cypher.append("RETURN p.filename, t.name ");
        String[] names = (String[])session.readTransaction(tx -> {
            Result statementResult = tx.run(cypher.toString(), params);
            if (!statementResult.hasNext()) {
                statementResult.consume();
                return null;
            }
            Record record = statementResult.next();
            statementResult.consume();
            String filename = LoggingCore.getStringValue(record, 0);
            String transformName = LoggingCore.getStringValue(record, 1);
            return new String[]{filename, transformName};
        });
        if (names == null) {
            return;
        }
        String filename = names[0];
        String transformName = names[1];
        if (StringUtils.isEmpty((String)filename)) {
            return;
        }
        try {
            this.hopGui.fileDelegate.fileOpen(filename);
            if (StringUtils.isEmpty((String)transformName)) {
                return;
            }
            HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
            IHopFileTypeHandler typeHandler = perspective.getActiveFileTypeHandler();
            if (typeHandler == null || !(typeHandler instanceof HopGuiPipelineGraph)) {
                return;
            }
            HopGuiPipelineGraph graph = (HopGuiPipelineGraph)typeHandler;
            PipelineMeta pipelineMeta = graph.getPipelineMeta();
            TransformMeta transformMeta = pipelineMeta.findTransform(transformName);
            if (transformMeta == null) {
                return;
            }
            pipelineMeta.unselectAll();
            transformMeta.setSelected(true);
            graph.editTransform(pipelineMeta, transformMeta);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningTransform.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningTransform.Dialog.Message", (String[])new String[0]), e);
        }
    }

    private void openAction(Session session, String name, String type, String id) {
        LogChannel.UI.logDetailed("Open action : " + id + ", name : " + name + ", type: " + type);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(CONST_SUBJECT_NAME, name);
        params.put(CONST_SUBJECT_TYPE, type);
        params.put(CONST_SUBJECT_ID, id);
        StringBuilder cypher = new StringBuilder();
        cypher.append("MATCH(e:Execution { name : $subjectName, type : $subjectType, id : $subjectId } )");
        cypher.append("-[:EXECUTION_OF_ACTION]->(a:Action { name : $subjectName } )");
        cypher.append("-[:ACTION_OF_WORKFLOW]->(w:Workflow) ");
        cypher.append("RETURN w.filename, a.name ");
        String[] names = (String[])session.readTransaction(tx -> {
            Result statementResult = tx.run(cypher.toString(), params);
            if (!statementResult.hasNext()) {
                statementResult.consume();
                return null;
            }
            Record record = statementResult.next();
            statementResult.consume();
            return new String[]{LoggingCore.getStringValue(record, 0), LoggingCore.getStringValue(record, 1)};
        });
        if (names == null) {
            return;
        }
        String filename = names[0];
        String actionName = names[1];
        if (StringUtils.isEmpty((String)filename)) {
            return;
        }
        try {
            this.hopGui.fileDelegate.fileOpen(filename);
            if (StringUtils.isNotEmpty((String)actionName)) {
                IHopFileTypeHandler typeHandler = HopGui.getDataOrchestrationPerspective().getActiveFileTypeHandler();
                if (typeHandler == null || !(typeHandler instanceof HopGuiWorkflowGraph)) {
                    return;
                }
                HopGuiWorkflowGraph graph = (HopGuiWorkflowGraph)typeHandler;
                WorkflowMeta workflowMeta = graph.getWorkflowMeta();
                ActionMeta actionMeta = workflowMeta.findAction(actionName);
                if (actionMeta != null) {
                    workflowMeta.unselectAll();
                    actionMeta.setSelected(true);
                    graph.editAction(workflowMeta, actionMeta);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningAction.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningAction.Dialog.Message", (String[])new String[0]), e);
        }
    }

    private void openPipelineOrWorkflow(Session session, String name, String type, String id, String nodeLabel, String relationship) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(CONST_SUBJECT_NAME, name);
        params.put(CONST_SUBJECT_TYPE, type);
        params.put(CONST_SUBJECT_ID, id);
        StringBuilder cypher = new StringBuilder();
        cypher.append("MATCH(ex:Execution { name : $subjectName, type : $subjectType, id : $subjectId }) ");
        cypher.append("MATCH(tr:" + nodeLabel + " { name : $subjectName }) ");
        cypher.append("MATCH(ex)-[:" + relationship + "]->(tr) ");
        cypher.append("RETURN tr.filename ");
        String filename = (String)session.readTransaction(tx -> {
            Result statementResult = tx.run(cypher.toString(), params);
            if (!statementResult.hasNext()) {
                statementResult.consume();
                return null;
            }
            Record record = statementResult.next();
            statementResult.consume();
            return LoggingCore.getStringValue(record, 0);
        });
        if (StringUtils.isNotEmpty((String)filename)) {
            try {
                this.hopGui.fileDelegate.fileOpen(filename);
            }
            catch (Exception e) {
                new ErrorDialog(this.hopGui.getShell(), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningFile.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Neo4jPerspectiveDialog.OpeningFile.Dialog.Message", (String[])new String[]{filename}), e);
            }
        }
    }

    public boolean remove(IHopFileTypeHandler typeHandler) {
        return false;
    }

    public List<TabItemHandler> getItems() {
        return null;
    }

    public void navigateToPreviousFile() {
    }

    public void navigateToNextFile() {
    }

    public boolean hasNavigationPreviousFile() {
        return false;
    }

    public boolean hasNavigationNextFile() {
        return false;
    }

    public HopGui getHopGui() {
        return this.hopGui;
    }

    public void setHopGui(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public Composite getParent() {
        return this.parent;
    }

    public void setParent(Composite parent) {
        this.parent = parent;
    }

    public Composite getControl() {
        return this.composite;
    }

    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    public List<ISearchable> getSearchables() {
        return new ArrayList<ISearchable>();
    }
}

