/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.split;

import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.transforms.split.SplitGraph;
import org.apache.hop.neo4j.transforms.split.SplitGraphData;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="Neo4jSplitGraph", name="i18n::SplitGraphMeta.name", description="i18n::SplitGraphMeta.description", image="neo4j_split.svg", categoryDescription="i18n::SplitGraphMeta.categoryDescription", keywords={"i18n::SplitGraphMeta.keyword"}, documentationUrl="/plugins/transforms/split-graph.html")
public class SplitGraphMeta
extends BaseTransformMeta<SplitGraph, SplitGraphData> {
    @HopMetadataProperty(key="graph_field")
    protected String graphField;
    @HopMetadataProperty(key="type_field")
    protected String typeField;
    @HopMetadataProperty(key="id_field")
    protected String idField;
    @HopMetadataProperty(key="property_set_field")
    protected String propertySetField;

    public void setDefault() {
        this.graphField = "graph";
        this.typeField = "type";
        this.idField = "id";
        this.propertySetField = "propertySet";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextStep, IVariables space, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (StringUtils.isNotEmpty((String)this.typeField)) {
            ValueMetaString typeValueMeta = new ValueMetaString(space.resolve(this.typeField));
            typeValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)typeValueMeta);
        }
        if (StringUtils.isNotEmpty((String)this.idField)) {
            ValueMetaString idValueMeta = new ValueMetaString(space.resolve(this.idField));
            idValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)idValueMeta);
        }
        if (StringUtils.isNotEmpty((String)this.propertySetField)) {
            ValueMetaString propertySetValueMeta = new ValueMetaString(space.resolve(this.propertySetField));
            propertySetValueMeta.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)propertySetValueMeta);
        }
    }

    @Generated
    public String getGraphField() {
        return this.graphField;
    }

    @Generated
    public String getTypeField() {
        return this.typeField;
    }

    @Generated
    public String getIdField() {
        return this.idField;
    }

    @Generated
    public String getPropertySetField() {
        return this.propertySetField;
    }

    @Generated
    public void setGraphField(String graphField) {
        this.graphField = graphField;
    }

    @Generated
    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    @Generated
    public void setIdField(String idField) {
        this.idField = idField;
    }

    @Generated
    public void setPropertySetField(String propertySetField) {
        this.propertySetField = propertySetField;
    }
}

