/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.databaselookup;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.pipeline.transforms.databaselookup.KeyField;
import org.apache.hop.pipeline.transforms.databaselookup.ReturnValue;

public class Lookup {
    @HopMetadataProperty(key="schema", injectionKeyDescription="DatabaseLookupMeta.Injection.SchemaName", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_SCHEMA)
    private String schemaName;
    @HopMetadataProperty(key="table", injectionKeyDescription="DatabaseLookupMeta.Injection.TableName", hopMetadataPropertyType=HopMetadataPropertyType.RDBMS_TABLE)
    private String tableName;
    @HopMetadataProperty(key="key", injectionGroupKey="keys", injectionGroupDescription="DatabaseLookupMeta.Injection.Keys")
    private List<KeyField> keyFields = new ArrayList<KeyField>();
    @HopMetadataProperty(key="value", injectionGroupKey="values", injectionGroupDescription="DatabaseLookupMeta.Injection.Returns")
    private List<ReturnValue> returnValues = new ArrayList<ReturnValue>();
    @HopMetadataProperty(key="orderby", injectionKeyDescription="DatabaseLookupMeta.Injection.OrderBy")
    private String orderByClause;
    @HopMetadataProperty(key="fail_on_multiple", injectionKeyDescription="DatabaseLookupMeta.Injection.FailOnMultiple")
    private boolean failingOnMultipleResults;
    @HopMetadataProperty(key="eat_row_on_failure", injectionKeyDescription="DatabaseLookupMeta.Injection.EatRowOnFailure")
    private boolean eatingRowOnLookupFailure;

    public Lookup() {
    }

    public Lookup clone() {
        return new Lookup(this);
    }

    public Lookup(Lookup l) {
        this();
        this.schemaName = l.schemaName;
        this.tableName = l.tableName;
        this.eatingRowOnLookupFailure = l.eatingRowOnLookupFailure;
        this.failingOnMultipleResults = l.failingOnMultipleResults;
        this.orderByClause = l.orderByClause;
        for (KeyField keyField : l.getKeyFields()) {
            this.keyFields.add(new KeyField(keyField));
        }
        for (ReturnValue returnValue : l.getReturnValues()) {
            this.returnValues.add(new ReturnValue(returnValue));
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<KeyField> getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(List<KeyField> keyFields) {
        this.keyFields = keyFields;
    }

    public List<ReturnValue> getReturnValues() {
        return this.returnValues;
    }

    public void setReturnValues(List<ReturnValue> returnValues) {
        this.returnValues = returnValues;
    }

    public String getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public boolean isFailingOnMultipleResults() {
        return this.failingOnMultipleResults;
    }

    public void setFailingOnMultipleResults(boolean failingOnMultipleResults) {
        this.failingOnMultipleResults = failingOnMultipleResults;
    }

    public boolean isEatingRowOnLookupFailure() {
        return this.eatingRowOnLookupFailure;
    }

    public void setEatingRowOnLookupFailure(boolean eatingRowOnLookupFailure) {
        this.eatingRowOnLookupFailure = eatingRowOnLookupFailure;
    }
}

