/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.monetdb.mcl.MCLException;
import org.monetdb.mcl.io.BufferedMCLReader;
import org.monetdb.mcl.io.BufferedMCLWriter;
import org.monetdb.mcl.io.LineType;
import org.monetdb.mcl.net.MonetUrlParser;
import org.monetdb.mcl.net.SecureSocket;
import org.monetdb.mcl.net.Target;
import org.monetdb.mcl.net.ValidationError;
import org.monetdb.mcl.parser.MCLParseException;

public final class MapiSocket {
    private static final byte[] NUL_BYTES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final String[][] KNOWN_ALGORITHMS = new String[][]{{"SHA512", "SHA-512"}, {"SHA384", "SHA-384"}, {"SHA256", "SHA-256"}, {"SHA1", "SHA-1"}};
    private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();
    private Target target;
    private Socket con = null;
    private BlockInputStream fromMonet;
    private OutputStream toMonet;
    private BufferedMCLReader reader;
    private BufferedMCLWriter writer;
    private int version;
    private boolean supportsClientInfo;
    private boolean followRedirects = true;
    private int ttl = 10;
    private Writer log;
    public static final int BLOCK = 8190;
    private final byte[] blklen = new byte[2];

    public MapiSocket() {
        this.target = new Target();
    }

    public void setDatabase(String string) {
        this.target.setDatabase(string);
    }

    public void setLanguage(String string) {
        this.target.setLanguage(string);
    }

    public void setHash(String string) {
        this.target.setHash(string);
    }

    public void setFollowRedirects(boolean bl) {
        this.followRedirects = bl;
    }

    public void setTTL(int n) {
        this.ttl = n;
    }

    public void setSoTimeout(int n) throws SocketException {
        if (n < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
        this.target.setSoTimeout(n);
        if (this.con != null) {
            this.con.setSoTimeout(n);
        }
    }

    public int getSoTimeout() throws SocketException {
        return this.target.getSoTimeout();
    }

    public void setDebug(boolean bl) {
        this.target.setDebug(bl);
    }

    public List<String> connect(String string, int n, String string2, String string3) throws IOException, SocketException, UnknownHostException, MCLParseException, MCLException {
        this.target.setHost(string);
        this.target.setPort(n);
        this.target.setUser(string2);
        this.target.setPassword(string3);
        return this.connect(this.target, null);
    }

    public List<String> connect(String string, Properties properties) throws URISyntaxException, ValidationError, MCLException, MCLParseException, IOException {
        return this.connect(new Target(string, properties), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> connect(Target target, OptionsCallback optionsCallback) throws MCLException, MCLParseException, IOException {
        Target.Validated validated;
        this.close();
        this.target = target;
        try {
            validated = target.validate();
        }
        catch (ValidationError validationError) {
            throw new MCLException(validationError.getMessage());
        }
        if (validated.connectScan()) {
            return this.scanUnixSockets(optionsCallback);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        do {
            boolean bl = false;
            try {
                boolean bl2 = this.tryConnect(optionsCallback, arrayList);
                bl = true;
                if (bl2) {
                    ArrayList<String> arrayList2 = arrayList;
                    return arrayList2;
                }
            }
            finally {
                if (!bl) {
                    this.close();
                }
            }
        } while (this.followRedirects && n++ < this.ttl);
        throw new MCLException("max redirect count exceeded");
    }

    private List<String> scanUnixSockets(OptionsCallback optionsCallback) throws MCLException, MCLParseException, IOException {
        this.target.setHost("localhost");
        return this.connect(this.target, optionsCallback);
    }

    private boolean tryConnect(OptionsCallback optionsCallback, ArrayList<String> arrayList) throws MCLException, IOException {
        try {
            Target.Validated validated = this.target.validate();
            if (this.con == null) {
                this.connectSocket(validated);
            }
            return this.handshake(validated, optionsCallback, arrayList);
        }
        catch (IOException | MCLException exception) {
            this.close();
            throw exception;
        }
        catch (ValidationError validationError) {
            this.close();
            throw new MCLException(validationError.getMessage());
        }
    }

    private void connectSocket(Target.Validated validated) throws MCLException, IOException {
        String string = validated.connectTcp();
        if (string.isEmpty()) {
            throw new MCLException("Unix domain sockets are not supported, only TCP");
        }
        int n = validated.connectPort();
        Socket socket = null;
        try {
            socket = new Socket(string, n);
            socket.setSoTimeout(validated.getSoTimeout());
            socket.setTcpNoDelay(true);
            socket.setKeepAlive(true);
            socket = this.wrapTLS(socket, validated);
            this.fromMonet = new BlockInputStream(socket.getInputStream());
            this.toMonet = new BlockOutputStream(socket.getOutputStream());
            this.reader = new BufferedMCLReader(this.fromMonet, StandardCharsets.UTF_8);
            this.writer = new BufferedMCLWriter(this.toMonet, StandardCharsets.UTF_8);
            this.writer.registerReader(this.reader);
            this.reader.advance();
            this.con = socket;
            socket = null;
        }
        catch (SSLException sSLException) {
            throw new MCLException("SSL error: " + sSLException.getMessage(), sSLException);
        }
        catch (IOException iOException) {
            throw new MCLException("Could not connect to " + string + ":" + n + ": " + iOException.getMessage(), iOException);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Socket wrapTLS(Socket socket, Target.Validated validated) throws IOException {
        if (validated.getTls()) {
            return SecureSocket.wrap(validated, socket);
        }
        socket.getOutputStream().write(NUL_BYTES);
        return socket;
    }

    private boolean handshake(Target.Validated validated, OptionsCallback optionsCallback, ArrayList<String> arrayList) throws IOException, MCLException {
        String string = this.reader.getLine();
        this.reader.advance();
        if (this.reader.getLineType() != LineType.PROMPT) {
            throw new MCLException("Garbage after server challenge: " + this.reader.getLine());
        }
        String string2 = this.challengeResponse(validated, string, optionsCallback);
        this.writer.writeLine(string2);
        this.reader.advance();
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder();
        while (this.reader.getLineType() != LineType.PROMPT) {
            switch (this.reader.getLineType()) {
                case REDIRECT: {
                    if (string3 != null) break;
                    string3 = this.reader.getLine(1);
                    break;
                }
                case ERROR: {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(this.reader.getLine(7));
                    break;
                }
                case INFO: {
                    arrayList.add(this.reader.getLine(1));
                    break;
                }
            }
            this.reader.advance();
        }
        if (stringBuilder.length() > 0) {
            throw new MCLException(stringBuilder.toString());
        }
        if (string3 == null) {
            return true;
        }
        try {
            MonetUrlParser.parse(this.target, string3);
        }
        catch (URISyntaxException | ValidationError exception) {
            throw new MCLException("While processing redirect " + string3 + ": " + exception.getMessage(), exception);
        }
        if (string3.startsWith("mapi:merovingian://proxy")) {
            this.reader.resetLineType();
            this.reader.advance();
        } else {
            this.close();
        }
        return false;
    }

    private String challengeResponse(Target.Validated validated, String string, OptionsCallback optionsCallback) throws MCLException {
        String string2;
        String string3;
        String[] stringArray = string.split(":");
        if (stringArray.length < 3) {
            throw new MCLException("Invalid challenge: expect at least 3 fields");
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        String string6 = stringArray[2];
        if (!string6.equals("9")) {
            throw new MCLException("Protocol versions other than 9 are note supported: " + string6);
        }
        int n = 9;
        if (stringArray.length < 6) {
            throw new MCLException("Protocol version " + n + " requires at least 6 fields, found " + stringArray.length + ": " + string);
        }
        String string7 = stringArray[3];
        String string8 = stringArray[5];
        String string9 = string3 = stringArray.length > 6 ? stringArray[6] : null;
        if (stringArray.length > 9) {
            this.supportsClientInfo = true;
        }
        String string10 = this.target.getPassword();
        if (string5.equals("merovingian") && !this.target.getLanguage().equals("control")) {
            string2 = "merovingian";
            string10 = "merovingian";
        } else {
            string2 = this.target.getUser();
        }
        String string11 = this.handleOptions(optionsCallback, string3);
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("BIG:");
        stringBuilder.append(string2).append(":");
        this.hashPassword(stringBuilder, string4, string10, string8, validated.getHash(), string7);
        stringBuilder.append(":");
        stringBuilder.append(validated.getLanguage()).append(":");
        stringBuilder.append(validated.getDatabase()).append(":");
        stringBuilder.append("FILETRANS:");
        stringBuilder.append(string11).append(":");
        return stringBuilder.toString();
    }

    private String hashPassword(StringBuilder stringBuilder, String string, String string2, String string3, String string4, String string5) throws MCLException {
        Serializable serializable;
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(string5.split(",")));
        if (!string4.isEmpty()) {
            String[] stringArray = string4.toUpperCase().split("[, ]");
            serializable = new HashSet<String>(Arrays.asList(stringArray));
            hashSet.retainAll((Collection<?>)((Object)serializable));
            if (hashSet.isEmpty()) {
                throw new MCLException("None of the hash algorithms in <" + string4 + "> are supported, server only supports <" + string5 + ">");
            }
        }
        int n = 128;
        serializable = new StringBuilder(n + string.length());
        MessageDigest messageDigest = this.pickBestAlgorithm(Collections.singleton(string3), null);
        this.hexhash((StringBuilder)serializable, messageDigest, string2);
        ((StringBuilder)serializable).append(string);
        stringBuilder.append('{');
        MessageDigest messageDigest2 = this.pickBestAlgorithm(hashSet, stringBuilder);
        stringBuilder.append('}');
        this.hexhash(stringBuilder, messageDigest2, ((StringBuilder)serializable).toString());
        return stringBuilder.toString();
    }

    private MessageDigest pickBestAlgorithm(Set<String> set, StringBuilder stringBuilder) throws MCLException {
        for (String[] stringArray : KNOWN_ALGORITHMS) {
            MessageDigest messageDigest;
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (!set.contains(string)) continue;
            try {
                messageDigest = MessageDigest.getInstance(string2);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            if (stringBuilder != null) {
                stringBuilder.append(string);
            }
            return messageDigest;
        }
        String string = String.join((CharSequence)",", set);
        throw new MCLException("No supported hash algorithm: " + string);
    }

    private void hexhash(StringBuilder stringBuilder, MessageDigest messageDigest, String string) {
        byte[] byArray;
        byte[] byArray2 = string.getBytes(StandardCharsets.UTF_8);
        messageDigest.update(byArray2);
        for (byte by : byArray = messageDigest.digest()) {
            int n = (by & 0xF0) >> 4;
            int n2 = by & 0xF;
            stringBuilder.append(HEXDIGITS[n]);
            stringBuilder.append(HEXDIGITS[n2]);
        }
    }

    private String handleOptions(OptionsCallback optionsCallback, String string) throws MCLException {
        if (optionsCallback == null || string == null || string.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        optionsCallback.setBuffer(stringBuilder);
        for (String string2 : string.split(",")) {
            int n;
            int n2 = string2.indexOf(61);
            if (n2 < 0) {
                throw new MCLException("Invalid options part in server challenge: " + string);
            }
            String string3 = string2.substring(0, n2);
            try {
                n = Integer.parseInt(string2.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new MCLException("Invalid option level in server challenge: " + string2);
            }
            optionsCallback.addOptions(string3, n);
        }
        return stringBuilder.toString();
    }

    public InputStream getInputStream() {
        return this.fromMonet;
    }

    public OutputStream getOutputStream() {
        return this.toMonet;
    }

    public BufferedMCLReader getReader() {
        return this.reader;
    }

    public BufferedMCLWriter getWriter() {
        return this.writer;
    }

    public int getProtocolVersion() {
        return this.version;
    }

    public void debug(String string) throws IOException {
        this.debug(new FileWriter(string));
    }

    public void debug(Writer writer) {
        this.log = writer;
        this.setDebug(true);
    }

    public Writer getLogWriter() {
        return this.log;
    }

    private final void log(String string, String string2, boolean bl) throws IOException {
        this.log.write(string + System.currentTimeMillis() + ": " + string2 + "\n");
        if (bl) {
            this.log.flush();
        }
    }

    public boolean setInsertFakePrompts(boolean bl) {
        return this.fromMonet.setInsertFakePrompts(bl);
    }

    public boolean isDebug() {
        return this.target.isDebug();
    }

    public boolean canClientInfo() {
        return this.supportsClientInfo;
    }

    public synchronized void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.toMonet != null) {
            try {
                this.toMonet.close();
                this.toMonet = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fromMonet != null) {
            try {
                this.fromMonet.close();
                this.fromMonet = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.con != null) {
            try {
                this.con.close();
                this.con = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.isDebug() && this.log != null && this.log instanceof FileWriter) {
            try {
                this.log.close();
                this.log = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public UploadStream uploadStream(int n) {
        return new UploadStream(n);
    }

    public UploadStream uploadStream() {
        return new UploadStream();
    }

    public DownloadStream downloadStream(boolean bl) {
        return new DownloadStream(this.fromMonet.getRaw(), this.toMonet, bl);
    }

    final class BlockInputStream
    extends FilterInputStream {
        private int readPos;
        private int blockLen;
        private boolean wasEndBlock;
        private final byte[] block;
        private boolean insertFakePrompts;

        public BlockInputStream(InputStream inputStream) {
            super(new BufferedInputStream(inputStream));
            this.readPos = 0;
            this.blockLen = 0;
            this.wasEndBlock = false;
            this.block = new byte[8193];
            this.insertFakePrompts = true;
        }

        public boolean setInsertFakePrompts(boolean bl) {
            boolean bl2 = this.insertFakePrompts;
            this.insertFakePrompts = bl;
            return bl2;
        }

        @Override
        public int available() {
            return this.blockLen - this.readPos;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int n) {
            throw new AssertionError((Object)"Not implemented!");
        }

        @Override
        public void reset() {
            throw new AssertionError((Object)"Not implemented!");
        }

        private boolean _read(byte[] byArray, int n) throws IOException {
            int n2 = 0;
            while (n > 0) {
                int n3 = this.in.read(byArray, n2, n);
                if (n3 == -1) {
                    if (n2 > 0) {
                        if (MapiSocket.this.isDebug()) {
                            MapiSocket.this.log("RD ", "the following incomplete block was received:", false);
                            MapiSocket.this.log("RX ", new String(byArray, 0, n2, StandardCharsets.UTF_8), true);
                        }
                        throw new IOException("Read from " + MapiSocket.this.con.getInetAddress().getHostName() + ":" + MapiSocket.this.con.getPort() + ": Incomplete block read from stream");
                    }
                    if (MapiSocket.this.isDebug()) {
                        MapiSocket.this.log("RD ", "server closed the connection (EOF)", true);
                    }
                    return false;
                }
                n -= n3;
                n2 += n3;
            }
            return true;
        }

        private int readBlock() throws IOException {
            if (!this._read(MapiSocket.this.blklen, 2)) {
                return -1;
            }
            this.blockLen = (short)((MapiSocket.this.blklen[0] & 0xFF) >> 1 | (MapiSocket.this.blklen[1] & 0xFF) << 7);
            this.wasEndBlock = (MapiSocket.this.blklen[0] & 1) == 1;
            this.readPos = 0;
            if (MapiSocket.this.isDebug()) {
                if (this.wasEndBlock) {
                    MapiSocket.this.log("RD ", "read final block: " + this.blockLen + " bytes", false);
                } else {
                    MapiSocket.this.log("RD ", "read new block: " + this.blockLen + " bytes", false);
                }
            }
            if (this.blockLen > this.block.length) {
                throw new IOException("Server sent a block larger than BLOCKsize: " + this.blockLen + " > " + this.block.length);
            }
            if (!this._read(this.block, this.blockLen)) {
                return -1;
            }
            if (MapiSocket.this.isDebug()) {
                MapiSocket.this.log("RX ", new String(this.block, 0, this.blockLen, StandardCharsets.UTF_8), true);
            }
            if (this.wasEndBlock && this.insertFakePrompts) {
                if (this.blockLen > 0 && this.block[this.blockLen - 1] != 10) {
                    this.block[this.blockLen++] = 10;
                }
                for (byte by : LineType.PROMPT.bytes()) {
                    this.block[this.blockLen++] = by;
                }
                this.block[this.blockLen++] = 10;
                if (MapiSocket.this.isDebug()) {
                    MapiSocket.this.log("RD ", "inserting prompt", true);
                }
            }
            return this.blockLen;
        }

        @Override
        public int read() throws IOException {
            if (this.available() == 0 && this.readBlock() == -1) {
                return -1;
            }
            if (MapiSocket.this.isDebug()) {
                MapiSocket.this.log("RX ", new String(this.block, this.readPos, 1, StandardCharsets.UTF_8), true);
            }
            return this.block[this.readPos++] & 0xFF;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4;
            for (n3 = 0; n3 < n2; n3 += n4) {
                n4 = this.available();
                if (n4 == 0) {
                    if (n3 != 0) break;
                    if (this.readBlock() == -1) {
                        if (n3 != 0) break;
                        n3 = -1;
                        break;
                    }
                    n4 = this.available();
                }
                if (n2 > n4) {
                    System.arraycopy(this.block, this.readPos, byArray, n, n4);
                    n += n4;
                    n2 -= n4;
                    this.readPos += n4;
                    continue;
                }
                System.arraycopy(this.block, this.readPos, byArray, n, n2);
                this.readPos += n2;
                n3 += n2;
                break;
            }
            return n3;
        }

        @Override
        public long skip(long l) throws IOException {
            long l2 = l;
            while (l2 > 0L) {
                int n = this.available();
                if (l2 > (long)n) {
                    l2 -= (long)n;
                    this.readPos += n;
                    this.readBlock();
                    continue;
                }
                this.readPos += (int)l2;
                break;
            }
            return l;
        }

        Raw getRaw() {
            return new Raw();
        }

        final class Raw {
            Raw() {
            }

            byte[] getBytes() {
                return BlockInputStream.this.block;
            }

            int getLength() {
                return BlockInputStream.this.blockLen;
            }

            int getPosition() {
                return BlockInputStream.this.readPos;
            }

            int consume(int n) {
                int n2 = BlockInputStream.this.readPos;
                BlockInputStream.this.readPos += n;
                return n2;
            }

            int readBlock() throws IOException {
                boolean bl = BlockInputStream.this.setInsertFakePrompts(false);
                try {
                    int n = BlockInputStream.this.readBlock();
                    return n;
                }
                finally {
                    BlockInputStream.this.setInsertFakePrompts(bl);
                }
            }

            boolean wasEndBlock() {
                return BlockInputStream.this.wasEndBlock;
            }
        }
    }

    public static abstract class OptionsCallback {
        private StringBuilder buffer;

        public abstract void addOptions(String var1, int var2);

        protected void contribute(String string, int n) {
            if (this.buffer.length() > 0) {
                this.buffer.append(',');
            }
            this.buffer.append(string);
            this.buffer.append('=');
            this.buffer.append(n);
        }

        void setBuffer(StringBuilder stringBuilder) {
            this.buffer = stringBuilder;
        }
    }

    final class BlockOutputStream
    extends FilterOutputStream {
        private int writePos;
        private int blocksize;
        private final byte[] block;

        public BlockOutputStream(OutputStream outputStream) {
            super(new BufferedOutputStream(outputStream));
            this.writePos = 0;
            this.blocksize = 0;
            this.block = new byte[8190];
        }

        @Override
        public void flush() throws IOException {
            this.writeBlock(true);
            this.out.flush();
            if (MapiSocket.this.isDebug()) {
                MapiSocket.this.log.flush();
            }
        }

        public void writeBlock(boolean bl) throws IOException {
            if (bl) {
                this.blocksize = (short)this.writePos;
                ((MapiSocket)MapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF | 1);
                ((MapiSocket)MapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            } else {
                this.blocksize = 8190;
                ((MapiSocket)MapiSocket.this).blklen[0] = (byte)(this.blocksize << 1 & 0xFF);
                ((MapiSocket)MapiSocket.this).blklen[1] = (byte)(this.blocksize >> 7);
            }
            this.out.write(MapiSocket.this.blklen);
            this.out.write(this.block, 0, this.writePos);
            if (MapiSocket.this.isDebug()) {
                if (bl) {
                    MapiSocket.this.log("TD ", "write final block: " + this.writePos + " bytes", false);
                } else {
                    MapiSocket.this.log("TD ", "write block: " + this.writePos + " bytes", false);
                }
                MapiSocket.this.log("TX ", new String(this.block, 0, this.writePos, StandardCharsets.UTF_8), true);
            }
            this.writePos = 0;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.writePos == 8190) {
                this.writeBlock(false);
            }
            this.block[this.writePos++] = (byte)n;
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            while (n2 > 0) {
                int n3 = 8190 - this.writePos;
                if (n2 > n3) {
                    System.arraycopy(byArray, n, this.block, this.writePos, n3);
                    n += n3;
                    n2 -= n3;
                    this.writePos += n3;
                    this.writeBlock(false);
                    continue;
                }
                System.arraycopy(byArray, n, this.block, this.writePos, n2);
                this.writePos += n2;
                break;
            }
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    public class UploadStream
    extends FilterOutputStream {
        public static final int DEFAULT_CHUNK_SIZE = 0x100000;
        private final int chunkSize;
        private boolean closed;
        private boolean serverCancelled;
        private int chunkLeft;
        private byte[] promptBuffer;
        private Runnable cancellationCallback;

        UploadStream(int n) {
            super(MapiSocket.this.toMonet);
            this.closed = false;
            this.serverCancelled = false;
            this.cancellationCallback = null;
            if (n <= 0) {
                throw new IllegalArgumentException("chunk size must be positive");
            }
            this.chunkSize = n;
            assert (LineType.MORE.bytes().length == LineType.FILETRANSFER.bytes().length);
            int n2 = LineType.MORE.bytes().length;
            this.promptBuffer = new byte[n2 + 1];
            this.chunkLeft = this.chunkSize;
        }

        UploadStream() {
            this(0x100000);
        }

        public void setCancellationCallback(Runnable runnable) {
            this.cancellationCallback = runnable;
        }

        @Override
        public void write(int n) throws IOException {
            if (this.serverCancelled) {
                throw new IOException("Server aborted the upload");
            }
            this.handleChunking();
            this.out.write(n);
            this.wrote(1);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.serverCancelled) {
                throw new IOException("Server aborted the upload");
            }
            while (n2 > 0) {
                this.handleChunking();
                int n3 = Integer.min(n2, this.chunkLeft);
                this.out.write(byArray, n, n3);
                n += n3;
                n2 -= n3;
                this.wrote(n3);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.serverCancelled) {
                this.closeAfterServerCancelled();
            } else {
                this.closeAfterSuccesfulUpload();
            }
        }

        private void closeAfterSuccesfulUpload() throws IOException {
            if (this.chunkLeft != this.chunkSize) {
                this.flushAndReadPrompt();
            }
            this.out.flush();
            LineType lineType = this.readPrompt();
            if (lineType != LineType.FILETRANSFER) {
                throw new IOException("Expected server to acknowledge end of file");
            }
        }

        private void closeAfterServerCancelled() {
        }

        private void wrote(int n) {
            this.chunkLeft -= n;
        }

        private void handleChunking() throws IOException {
            if (this.chunkLeft > 0) {
                return;
            }
            this.flushAndReadPrompt();
        }

        private void flushAndReadPrompt() throws IOException {
            this.out.flush();
            this.chunkLeft = this.chunkSize;
            LineType lineType = this.readPrompt();
            switch (lineType) {
                case MORE: {
                    return;
                }
                case FILETRANSFER: {
                    this.serverCancelled = true;
                    if (this.cancellationCallback != null) {
                        this.cancellationCallback.run();
                    }
                    throw new IOException("Server aborted the upload");
                }
            }
            throw new IOException("Expected MORE/DONE from server, got " + (Object)((Object)lineType));
        }

        private LineType readPrompt() throws IOException {
            int n = MapiSocket.this.fromMonet.read(this.promptBuffer);
            if (n != this.promptBuffer.length || this.promptBuffer[this.promptBuffer.length - 1] != 10) {
                throw new IOException("server return incomplete prompt");
            }
            return LineType.classify(this.promptBuffer);
        }
    }

    public static class DownloadStream
    extends InputStream {
        private final BlockInputStream.Raw rawIn;
        private final OutputStream out;
        private final boolean prependCr;
        private boolean endBlockSeen = false;
        private boolean closed = false;
        private boolean newlinePending = false;

        DownloadStream(BlockInputStream.Raw raw, OutputStream outputStream, boolean bl) {
            this.rawIn = raw;
            this.out = outputStream;
            this.prependCr = bl;
        }

        void nextBlock() throws IOException {
            if (this.endBlockSeen || this.closed) {
                return;
            }
            int n = this.rawIn.readBlock();
            if (n < 0 || this.rawIn.wasEndBlock()) {
                this.endBlockSeen = true;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            while (!this.endBlockSeen) {
                this.nextBlock();
            }
            this.out.write(10);
            this.out.flush();
            super.close();
        }

        @Override
        public int read() throws IOException {
            byte[] byArray = new byte[]{0};
            int n = this.read(byArray, 0, 1);
            if (n == 1) {
                return byArray[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n;
            int n4 = n + n2;
            block0: while (n < n4) {
                int n5 = Integer.min(n4 - n, this.rawIn.getLength() - this.rawIn.getPosition());
                assert (n5 >= 0);
                if (n5 == 0) {
                    if (this.endBlockSeen) break;
                    this.nextBlock();
                    continue;
                }
                if (!this.prependCr) {
                    System.arraycopy(this.rawIn.getBytes(), this.rawIn.getPosition(), byArray, n, n5);
                    n += n5;
                    this.rawIn.consume(n5);
                    continue;
                }
                int n6 = n + n5;
                if (this.newlinePending && n < n6) {
                    byArray[n++] = 10;
                    this.newlinePending = false;
                }
                while (n < n6) {
                    byte by = this.rawIn.getBytes()[this.rawIn.consume(1)];
                    if (by != 10) {
                        byArray[n++] = by;
                        continue;
                    }
                    if (n6 - n >= 2) {
                        byArray[n++] = 13;
                        byArray[n++] = 10;
                        continue;
                    }
                    byArray[n++] = 13;
                    this.newlinePending = true;
                    continue block0;
                }
            }
            if (n < n4 && this.newlinePending) {
                byArray[n++] = 10;
                this.newlinePending = false;
            }
            if (n == n3 && this.endBlockSeen) {
                return -1;
            }
            return n - n3;
        }
    }
}

