/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.array;

import java.util.Iterator;
import org.psjava.ds.array.ArrayIterator;
import org.psjava.ds.array.MutableArray;
import org.psjava.util.EqualityTester;
import org.psjava.util.IterableEqualityTester;
import org.psjava.util.IterableToString;
import org.psjava.util.OrderFreeIterableHash;
import org.psjava.util.StrictEqualityTester;

public class MutableArrayUsingJavaArray {
    public static <T> MutableArray<T> wrap(final T[] a) {
        return new MutableArray<T>(){

            @Override
            public T get(int p) {
                return a[p];
            }

            @Override
            public void set(int p, T v) {
                a[p] = v;
            }

            @Override
            public int size() {
                return a.length;
            }

            @Override
            public boolean isEmpty() {
                return a.length == 0;
            }

            @Override
            public Iterator<T> iterator() {
                return ArrayIterator.create(this);
            }

            public String toString() {
                return IterableToString.toString(this);
            }

            public boolean equals(Object obj) {
                return StrictEqualityTester.areEqual(this, obj, new EqualityTester<MutableArray<T>>(){

                    @Override
                    public boolean areEqual(MutableArray<T> o1, MutableArray<T> o2) {
                        return IterableEqualityTester.areEqual(o1, o2);
                    }
                });
            }

            public int hashCode() {
                return OrderFreeIterableHash.hash(this);
            }
        };
    }

    private MutableArrayUsingJavaArray() {
    }
}

