/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.data_formats;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.data_formats.internal.AbstractBinaryFormatReader;
import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.client.api.query.QuerySettings;
import com.clickhouse.data.ClickHouseColumn;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class NativeFormatReader
extends AbstractBinaryFormatReader {
    private Block currentBlock;
    private int blockRowIndex;

    public NativeFormatReader(InputStream inputStream, QuerySettings settings, BinaryStreamReader.ByteBufferAllocator byteBufferAllocator) {
        super(inputStream, settings, null, byteBufferAllocator);
        try {
            this.readBlock();
        }
        catch (IOException e) {
            throw new ClientException("Failed to read block", e);
        }
    }

    @Override
    public boolean readRecord(Map<String, Object> record) throws IOException {
        if (this.blockRowIndex >= this.currentBlock.getnRows() && !this.readBlock()) {
            return false;
        }
        this.currentBlock.fillRecord(this.blockRowIndex, record);
        ++this.blockRowIndex;
        return true;
    }

    @Override
    protected boolean readRecord(Object[] record) throws IOException {
        if (this.blockRowIndex >= this.currentBlock.getnRows() && !this.readBlock()) {
            return false;
        }
        this.currentBlock.fillRecord(this.blockRowIndex, record);
        ++this.blockRowIndex;
        return true;
    }

    private boolean readBlock() throws IOException {
        int nColumns;
        try {
            nColumns = BinaryStreamReader.readVarInt(this.input);
        }
        catch (EOFException e) {
            this.endReached();
            return false;
        }
        int nRows = BinaryStreamReader.readVarInt(this.input);
        ArrayList<String> names = new ArrayList<String>(nColumns);
        ArrayList<String> types = new ArrayList<String>(nColumns);
        this.currentBlock = new Block(names, types, nRows);
        ArrayList<ClickHouseColumn> columns = new ArrayList<ClickHouseColumn>(nColumns);
        for (int i = 0; i < nColumns; ++i) {
            ClickHouseColumn column = ClickHouseColumn.of(BinaryStreamReader.readString(this.input), BinaryStreamReader.readString(this.input));
            columns.add(column);
            names.add(column.getColumnName());
            types.add(column.getDataType().name());
            ArrayList<Object> values = new ArrayList<Object>(nRows);
            if (column.isArray()) {
                int j;
                int[] sizes = new int[nRows];
                for (j = 0; j < nRows; ++j) {
                    sizes[j] = Math.toIntExact(this.binaryStreamReader.readLongLE());
                }
                for (j = 0; j < nRows; ++j) {
                    values.add(this.binaryStreamReader.readArrayItem(column.getNestedColumns().get(0), sizes[0]));
                }
            } else {
                for (int j = 0; j < nRows; ++j) {
                    Object value = this.binaryStreamReader.readValue(column);
                    values.add(value);
                }
            }
            this.currentBlock.add(values);
        }
        TableSchema schema = new TableSchema(columns);
        this.setSchema(schema);
        this.blockRowIndex = 0;
        return true;
    }

    private static class Block {
        final List<String> names;
        final List<String> types;
        final List<List<Object>> values = new ArrayList<List<Object>>();
        final int nRows;

        Block(List<String> names, List<String> types, int nRows) {
            this.names = names;
            this.types = types;
            this.nRows = nRows;
        }

        public void add(List<Object> values) {
            this.values.add(values);
        }

        public int getnRows() {
            return this.nRows;
        }

        private void fillRecord(int index, Object[] record) {
            for (int i = 0; i < this.names.size(); ++i) {
                record[i] = this.values.get(i).get(index);
            }
        }

        private void fillRecord(int index, Map<String, Object> record) {
            int colIndex = 0;
            for (String name : this.names) {
                record.put(name, this.values.get(colIndex).get(index));
                ++colIndex;
            }
        }
    }
}

