/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.metadata.schema;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.Describable;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public interface RelationMetadata
extends Describable {
    @NonNull
    public CqlIdentifier getKeyspace();

    @NonNull
    public CqlIdentifier getName();

    public Optional<UUID> getId();

    @NonNull
    default public List<ColumnMetadata> getPrimaryKey() {
        return ImmutableList.builder().addAll(this.getPartitionKey()).addAll(this.getClusteringColumns().keySet()).build();
    }

    @NonNull
    public List<ColumnMetadata> getPartitionKey();

    @NonNull
    public Map<ColumnMetadata, ClusteringOrder> getClusteringColumns();

    @NonNull
    public Map<CqlIdentifier, ColumnMetadata> getColumns();

    @NonNull
    default public Optional<ColumnMetadata> getColumn(@NonNull CqlIdentifier columnId) {
        return Optional.ofNullable(this.getColumns().get(columnId));
    }

    @NonNull
    default public Optional<ColumnMetadata> getColumn(@NonNull String columnName) {
        return this.getColumn(CqlIdentifier.fromCql(columnName));
    }

    @NonNull
    public Map<CqlIdentifier, Object> getOptions();
}

