/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.partitionrelease;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.failover.partitionrelease.ConsumerRegionGroupExecutionView;
import org.apache.flink.runtime.scheduler.strategy.SchedulingPipelinedRegion;

class ConsumerRegionGroupExecutionViewMaintainer {
    private final Map<SchedulingPipelinedRegion, Set<ConsumerRegionGroupExecutionView>> executionViewByRegion = new HashMap<SchedulingPipelinedRegion, Set<ConsumerRegionGroupExecutionView>>();

    ConsumerRegionGroupExecutionViewMaintainer() {
    }

    void notifyNewRegionGroupExecutionViews(Iterable<ConsumerRegionGroupExecutionView> executionViews) {
        for (ConsumerRegionGroupExecutionView executionView : executionViews) {
            for (SchedulingPipelinedRegion region : executionView) {
                this.executionViewByRegion.computeIfAbsent(region, r -> Collections.newSetFromMap(new IdentityHashMap())).add(executionView);
            }
        }
    }

    void regionFinished(SchedulingPipelinedRegion region) {
        for (ConsumerRegionGroupExecutionView executionView : this.executionViewByRegion.getOrDefault(region, Collections.emptySet())) {
            executionView.regionFinished(region);
        }
    }

    void regionUnfinished(SchedulingPipelinedRegion region) {
        for (ConsumerRegionGroupExecutionView executionView : this.executionViewByRegion.getOrDefault(region, Collections.emptySet())) {
            executionView.regionUnfinished(region);
        }
    }
}

